/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.deltalake.transactionlog.writer;

import com.google.inject.Inject;
import io.trino.plugin.deltalake.transactionlog.writer.TransactionLogSynchronizer;
import io.trino.plugin.deltalake.transactionlog.writer.TransactionLogSynchronizerManager;
import io.trino.plugin.deltalake.transactionlog.writer.TransactionLogWriter;
import io.trino.spi.connector.ConnectorSession;
import java.util.Objects;

public class TransactionLogWriterFactory {
    private final TransactionLogSynchronizerManager synchronizerManager;

    @Inject
    public TransactionLogWriterFactory(TransactionLogSynchronizerManager synchronizerManager) {
        this.synchronizerManager = Objects.requireNonNull(synchronizerManager, "synchronizerManager is null");
    }

    public TransactionLogWriter newWriter(ConnectorSession session, String tableLocation) {
        TransactionLogSynchronizer synchronizer = this.synchronizerManager.getSynchronizer(tableLocation);
        return new TransactionLogWriter(synchronizer, session, tableLocation);
    }

    public TransactionLogWriter newWriterWithoutTransactionIsolation(ConnectorSession session, String tableLocation) {
        return new TransactionLogWriter(this.synchronizerManager.getNoIsolationSynchronizer(), session, tableLocation);
    }
}

