/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.deltalake.transactionlog;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.Objects;

public class TransactionEntry {
    private final String appId;
    private final long version;
    private final long lastUpdated;

    @JsonCreator
    public TransactionEntry(@JsonProperty(value="appId") String appId, @JsonProperty(value="version") long version, @JsonProperty(value="lastUpdated") long lastUpdated) {
        this.appId = appId;
        this.version = version;
        this.lastUpdated = lastUpdated;
    }

    @JsonProperty
    public String getAppId() {
        return this.appId;
    }

    @JsonProperty
    public long getVersion() {
        return this.version;
    }

    @JsonProperty
    public long getLastUpdated() {
        return this.lastUpdated;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TransactionEntry that = (TransactionEntry)o;
        return this.version == that.version && this.lastUpdated == that.lastUpdated && Objects.equals(this.appId, that.appId);
    }

    public int hashCode() {
        return Objects.hash(this.appId, this.version, this.lastUpdated);
    }

    public String toString() {
        return String.format("TransactionEntry{appId=%s, version=%d, lastUpdated=%d}", this.appId, this.version, this.lastUpdated);
    }
}

