/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.deltalake.statistics;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.inject.Inject;
import io.trino.plugin.deltalake.DeltaLakeColumnHandle;
import io.trino.plugin.deltalake.DeltaLakeColumnMetadata;
import io.trino.plugin.deltalake.DeltaLakeColumnType;
import io.trino.plugin.deltalake.DeltaLakeMetadata;
import io.trino.plugin.deltalake.DeltaLakeSessionProperties;
import io.trino.plugin.deltalake.DeltaLakeSplitManager;
import io.trino.plugin.deltalake.DeltaLakeTableHandle;
import io.trino.plugin.deltalake.statistics.CachingExtendedStatisticsAccess;
import io.trino.plugin.deltalake.statistics.DeltaLakeColumnStatistics;
import io.trino.plugin.deltalake.statistics.DeltaLakeTableStatisticsProvider;
import io.trino.plugin.deltalake.statistics.ExtendedStatistics;
import io.trino.plugin.deltalake.transactionlog.AddFileEntry;
import io.trino.plugin.deltalake.transactionlog.DeltaLakeSchemaSupport;
import io.trino.plugin.deltalake.transactionlog.MetadataEntry;
import io.trino.plugin.deltalake.transactionlog.TableSnapshot;
import io.trino.plugin.deltalake.transactionlog.TransactionLogAccess;
import io.trino.plugin.deltalake.transactionlog.statistics.DeltaLakeFileStatistics;
import io.trino.spi.connector.ColumnHandle;
import io.trino.spi.connector.ConnectorSession;
import io.trino.spi.predicate.TupleDomain;
import io.trino.spi.statistics.ColumnStatistics;
import io.trino.spi.statistics.DoubleRange;
import io.trino.spi.statistics.Estimate;
import io.trino.spi.statistics.StatsUtil;
import io.trino.spi.statistics.TableStatistics;
import io.trino.spi.type.Type;
import io.trino.spi.type.TypeManager;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.OptionalDouble;
import java.util.Set;

public class FileBasedTableStatisticsProvider
implements DeltaLakeTableStatisticsProvider {
    private final TypeManager typeManager;
    private final TransactionLogAccess transactionLogAccess;
    private final CachingExtendedStatisticsAccess statisticsAccess;

    @Inject
    public FileBasedTableStatisticsProvider(TypeManager typeManager, TransactionLogAccess transactionLogAccess, CachingExtendedStatisticsAccess statisticsAccess) {
        this.typeManager = Objects.requireNonNull(typeManager, "typeManager is null");
        this.transactionLogAccess = Objects.requireNonNull(transactionLogAccess, "transactionLogAccess is null");
        this.statisticsAccess = Objects.requireNonNull(statisticsAccess, "statisticsAccess is null");
    }

    @Override
    public TableStatistics getTableStatistics(ConnectorSession session, DeltaLakeTableHandle tableHandle, TableSnapshot tableSnapshot) {
        double numRecords = 0.0;
        MetadataEntry metadata = tableHandle.getMetadataEntry();
        List<DeltaLakeColumnMetadata> columnMetadata = DeltaLakeSchemaSupport.extractSchema(metadata, this.typeManager);
        List columns = (List)columnMetadata.stream().map(columnMeta -> new DeltaLakeColumnHandle(columnMeta.getName(), columnMeta.getType(), columnMeta.getFieldId(), columnMeta.getPhysicalName(), columnMeta.getPhysicalColumnType(), metadata.getCanonicalPartitionColumns().contains(columnMeta.getName()) ? DeltaLakeColumnType.PARTITION_KEY : DeltaLakeColumnType.REGULAR, Optional.empty())).collect(ImmutableList.toImmutableList());
        HashMap<DeltaLakeColumnHandle, Double> nullCounts = new HashMap<DeltaLakeColumnHandle, Double>();
        columns.forEach(column -> nullCounts.put((DeltaLakeColumnHandle)column, 0.0));
        HashMap minValues = new HashMap();
        HashMap maxValues = new HashMap();
        HashMap partitioningColumnsDistinctValues = new HashMap();
        columns.stream().filter(column -> column.getColumnType() == DeltaLakeColumnType.PARTITION_KEY).forEach(column -> partitioningColumnsDistinctValues.put(column, new HashSet()));
        if (tableHandle.getEnforcedPartitionConstraint().isNone() || tableHandle.getNonPartitionConstraint().isNone()) {
            return this.createZeroStatistics(columns);
        }
        Set predicatedColumnNames = (Set)((Map)tableHandle.getNonPartitionConstraint().getDomains().orElseThrow()).keySet().stream().filter(DeltaLakeColumnHandle::isBaseColumn).map(DeltaLakeColumnHandle::getBaseColumnName).collect(ImmutableSet.toImmutableSet());
        List predicatedColumns = (List)columnMetadata.stream().filter(column -> predicatedColumnNames.contains(column.getName())).collect(ImmutableList.toImmutableList());
        for (AddFileEntry addEntry : this.transactionLogAccess.getActiveFiles(tableSnapshot, session)) {
            Optional<? extends DeltaLakeFileStatistics> fileStatistics = addEntry.getStats();
            if (fileStatistics.isEmpty()) {
                return TableStatistics.empty();
            }
            DeltaLakeFileStatistics stats = fileStatistics.get();
            if (!DeltaLakeSplitManager.partitionMatchesPredicate(addEntry.getCanonicalPartitionValues(), (Map)tableHandle.getEnforcedPartitionConstraint().getDomains().orElseThrow())) continue;
            TupleDomain<DeltaLakeColumnHandle> statisticsPredicate = DeltaLakeMetadata.createStatisticsPredicate(addEntry, predicatedColumns, tableHandle.getMetadataEntry().getCanonicalPartitionColumns());
            if (!tableHandle.getNonPartitionConstraint().overlaps(statisticsPredicate)) continue;
            if (stats.getNumRecords().isEmpty()) {
                return TableStatistics.empty();
            }
            numRecords += (double)stats.getNumRecords().get().longValue();
            for (DeltaLakeColumnHandle column2 : columns) {
                if (column2.getColumnType() == DeltaLakeColumnType.PARTITION_KEY) {
                    Optional<String> partitionValue = addEntry.getCanonicalPartitionValues().get(column2.getBasePhysicalColumnName());
                    if (partitionValue.isEmpty()) {
                        nullCounts.merge(column2, Double.valueOf(stats.getNumRecords().get().longValue()), Double::sum);
                    } else {
                        ((Set)partitioningColumnsDistinctValues.get(column2)).add(partitionValue.get());
                    }
                } else {
                    Optional maybeNullCount;
                    Optional<Object> optional = maybeNullCount = column2.isBaseColumn() ? stats.getNullCount(column2.getBasePhysicalColumnName()) : Optional.empty();
                    if (maybeNullCount.isPresent()) {
                        nullCounts.put(column2, (Double)nullCounts.get(column2) + (double)((Long)maybeNullCount.get()).longValue());
                    } else {
                        nullCounts.put(column2, Double.NaN);
                    }
                }
                stats.getMinColumnValue(column2).map(parsedValue -> StatsUtil.toStatsRepresentation((Type)column2.getBaseType(), (Object)parsedValue)).filter(OptionalDouble::isPresent).map(OptionalDouble::getAsDouble).ifPresent(parsedValueAsDouble -> minValues.merge(column2, parsedValueAsDouble, Math::min));
                stats.getMaxColumnValue(column2).map(parsedValue -> StatsUtil.toStatsRepresentation((Type)column2.getBaseType(), (Object)parsedValue)).filter(OptionalDouble::isPresent).map(OptionalDouble::getAsDouble).ifPresent(parsedValueAsDouble -> maxValues.merge(column2, parsedValueAsDouble, Math::max));
            }
        }
        if (numRecords == 0.0) {
            return this.createZeroStatistics(columns);
        }
        TableStatistics.Builder statsBuilder = new TableStatistics.Builder().setRowCount(Estimate.of((double)numRecords));
        Optional<Object> statistics = Optional.empty();
        if (DeltaLakeSessionProperties.isExtendedStatisticsEnabled(session)) {
            statistics = this.statisticsAccess.readExtendedStatistics(session, tableHandle.getSchemaTableName(), tableHandle.getLocation());
        }
        for (DeltaLakeColumnHandle column3 : columns) {
            DeltaLakeColumnStatistics deltaLakeColumnStatistics;
            ColumnStatistics.Builder columnStatsBuilder = new ColumnStatistics.Builder();
            Double nullCount = (Double)nullCounts.get(column3);
            columnStatsBuilder.setNullsFraction(nullCount.isNaN() ? Estimate.unknown() : Estimate.of((double)(nullCount / numRecords)));
            Double maxValue = (Double)maxValues.get(column3);
            Double minValue = (Double)minValues.get(column3);
            if (this.isValidInRange(maxValue) && this.isValidInRange(minValue)) {
                columnStatsBuilder.setRange(new DoubleRange(minValue.doubleValue(), maxValue.doubleValue()));
            } else if (this.isValidInRange(maxValue)) {
                columnStatsBuilder.setRange(new DoubleRange(Double.NEGATIVE_INFINITY, maxValue.doubleValue()));
            } else if (this.isValidInRange(minValue)) {
                columnStatsBuilder.setRange(new DoubleRange(minValue.doubleValue(), Double.POSITIVE_INFINITY));
            }
            if (column3.getColumnType() == DeltaLakeColumnType.PARTITION_KEY) {
                columnStatsBuilder.setDistinctValuesCount(Estimate.of((double)((Set)partitioningColumnsDistinctValues.get(column3)).size()));
            }
            if (statistics.isPresent() && (deltaLakeColumnStatistics = ((ExtendedStatistics)statistics.get()).getColumnStatistics().get(column3.getBasePhysicalColumnName())) != null && column3.getColumnType() != DeltaLakeColumnType.PARTITION_KEY) {
                deltaLakeColumnStatistics.getTotalSizeInBytes().ifPresent(size -> columnStatsBuilder.setDataSize(Estimate.of((double)size)));
                columnStatsBuilder.setDistinctValuesCount(Estimate.of((double)deltaLakeColumnStatistics.getNdvSummary().cardinality()));
            }
            statsBuilder.setColumnStatistics((ColumnHandle)column3, columnStatsBuilder.build());
        }
        return statsBuilder.build();
    }

    private TableStatistics createZeroStatistics(List<DeltaLakeColumnHandle> columns) {
        TableStatistics.Builder statsBuilder = new TableStatistics.Builder().setRowCount(Estimate.of((double)0.0));
        for (DeltaLakeColumnHandle column : columns) {
            ColumnStatistics.Builder columnStatistics = ColumnStatistics.builder();
            columnStatistics.setNullsFraction(Estimate.of((double)0.0));
            columnStatistics.setDistinctValuesCount(Estimate.of((double)0.0));
            statsBuilder.setColumnStatistics((ColumnHandle)column, columnStatistics.build());
        }
        return statsBuilder.build();
    }

    private boolean isValidInRange(Double d) {
        return d != null && !d.isNaN();
    }
}

