/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.deltalake;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.inject.Inject;
import io.trino.spi.ErrorCodeSupplier;
import io.trino.spi.StandardErrorCode;
import io.trino.spi.TrinoException;
import io.trino.spi.session.PropertyMetadata;
import io.trino.spi.type.ArrayType;
import io.trino.spi.type.SqlTimestampWithTimeZone;
import io.trino.spi.type.TimeZoneKey;
import io.trino.spi.type.TimestampWithTimeZoneType;
import io.trino.spi.type.Type;
import io.trino.spi.type.VarcharType;
import java.time.Instant;
import java.time.ZoneId;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;

public class DeltaLakeAnalyzeProperties {
    public static final String FILES_MODIFIED_AFTER = "files_modified_after";
    public static final String COLUMNS_PROPERTY = "columns";
    public static final String MODE_PROPERTY = "mode";
    private final List<PropertyMetadata<?>> analyzeProperties = ImmutableList.of((Object)new PropertyMetadata("files_modified_after", "Take into account only files modified after given timestamp", (Type)TimestampWithTimeZoneType.TIMESTAMP_TZ_MILLIS, Instant.class, null, false, value -> ((SqlTimestampWithTimeZone)value).toZonedDateTime().toInstant(), instant -> SqlTimestampWithTimeZone.fromInstant((int)3, (Instant)instant, (ZoneId)TimeZoneKey.UTC_KEY.getZoneId())), (Object)new PropertyMetadata("columns", "Columns to be analyzed", (Type)new ArrayType((Type)VarcharType.VARCHAR), Set.class, null, false, DeltaLakeAnalyzeProperties::decodeColumnNames, value -> value), (Object)PropertyMetadata.enumProperty((String)"mode", (String)"Analyze mode", AnalyzeMode.class, (Enum)AnalyzeMode.INCREMENTAL, (boolean)false));

    @Inject
    public DeltaLakeAnalyzeProperties() {
    }

    public List<PropertyMetadata<?>> getAnalyzeProperties() {
        return this.analyzeProperties;
    }

    public static Optional<Instant> getFilesModifiedAfterProperty(Map<String, Object> properties) {
        return Optional.ofNullable((Instant)properties.get(FILES_MODIFIED_AFTER));
    }

    public static AnalyzeMode getRefreshMode(Map<String, Object> properties) {
        return (AnalyzeMode)((Object)properties.get(MODE_PROPERTY));
    }

    public static Optional<Set<String>> getColumnNames(Map<String, Object> properties) {
        Set columns = (Set)properties.get(COLUMNS_PROPERTY);
        return Optional.ofNullable(columns);
    }

    private static Set<String> decodeColumnNames(Object object) {
        if (object == null) {
            return null;
        }
        Collection columns = (Collection)object;
        return (Set)columns.stream().peek(property -> DeltaLakeAnalyzeProperties.throwIfNull(property, COLUMNS_PROPERTY)).map(String.class::cast).collect(ImmutableSet.toImmutableSet());
    }

    private static void throwIfNull(Object object, String propertyName) {
        if (object == null) {
            throw new TrinoException((ErrorCodeSupplier)StandardErrorCode.INVALID_ANALYZE_PROPERTY, String.format("Invalid null value in analyze %s property", propertyName));
        }
    }

    static enum AnalyzeMode {
        INCREMENTAL,
        FULL_REFRESH;

    }
}

