/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.optimizer.calcite.rules.views;

import io.trino.hive.$internal.com.google.common.collect.ImmutableList;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Set;
import org.apache.calcite.plan.RelOptRule;
import org.apache.calcite.plan.RelOptRuleCall;
import org.apache.calcite.plan.RelOptRuleOperandChildren;
import org.apache.calcite.rel.RelNode;
import org.apache.calcite.rel.core.TableScan;
import org.apache.calcite.rel.type.RelDataType;
import org.apache.calcite.rel.type.RelDataTypeField;
import org.apache.calcite.rex.RexBuilder;
import org.apache.calcite.rex.RexNode;
import org.apache.calcite.sql.SqlOperator;
import org.apache.calcite.sql.fun.SqlStdOperatorTable;
import org.apache.calcite.sql.type.SqlTypeName;
import org.apache.calcite.tools.RelBuilder;
import org.apache.hadoop.hive.common.ValidTxnWriteIdList;
import org.apache.hadoop.hive.common.ValidWriteIdList;
import org.apache.hadoop.hive.ql.metadata.VirtualColumn;
import org.apache.hadoop.hive.ql.optimizer.calcite.HiveRelFactories;
import org.apache.hadoop.hive.ql.optimizer.calcite.RelOptHiveTable;
import org.apache.hive.common.util.TxnIdUtils;

public class HiveAugmentMaterializationRule
extends RelOptRule {
    private final RexBuilder rexBuilder;
    private final ValidTxnWriteIdList currentTxnList;
    private final ValidTxnWriteIdList materializationTxnList;
    private final Set<RelNode> visited;

    public HiveAugmentMaterializationRule(RexBuilder rexBuilder, ValidTxnWriteIdList currentTxnList, ValidTxnWriteIdList materializationTxnList) {
        super(HiveAugmentMaterializationRule.operand(TableScan.class, (RelOptRuleOperandChildren)HiveAugmentMaterializationRule.any()), HiveRelFactories.HIVE_BUILDER, "HiveAugmentMaterializationRule");
        this.rexBuilder = rexBuilder;
        this.currentTxnList = currentTxnList;
        this.materializationTxnList = materializationTxnList;
        this.visited = new HashSet<RelNode>();
    }

    public void onMatch(RelOptRuleCall call) {
        ValidWriteIdList tableMaterializationTxnList;
        TableScan tableScan = (TableScan)call.rel(0);
        if (!this.visited.add((RelNode)tableScan)) {
            return;
        }
        String tableQName = ((RelOptHiveTable)tableScan.getTable()).getHiveTableMD().getFullyQualifiedName();
        ValidWriteIdList tableCurrentTxnList = this.currentTxnList.getTableValidWriteIdList(tableQName);
        if (TxnIdUtils.checkEquivalentWriteIds(tableCurrentTxnList, tableMaterializationTxnList = this.materializationTxnList.getTableValidWriteIdList(tableQName))) {
            return;
        }
        int rowIDPos = tableScan.getTable().getRowType().getField(VirtualColumn.ROWID.getName(), false, false).getIndex();
        RexNode rowIDFieldAccess = this.rexBuilder.makeFieldAccess((RexNode)this.rexBuilder.makeInputRef(((RelDataTypeField)tableScan.getTable().getRowType().getFieldList().get(rowIDPos)).getType(), rowIDPos), 0);
        RelBuilder relBuilder = call.builder();
        relBuilder.push((RelNode)tableScan);
        ArrayList<RexNode> conds = new ArrayList<RexNode>();
        RelDataType bigIntType = relBuilder.getTypeFactory().createSqlType(SqlTypeName.BIGINT);
        RexNode literalHighWatermark = this.rexBuilder.makeLiteral((Object)tableMaterializationTxnList.getHighWatermark(), bigIntType, false);
        conds.add(this.rexBuilder.makeCall((SqlOperator)SqlStdOperatorTable.LESS_THAN_OR_EQUAL, ImmutableList.of(rowIDFieldAccess, literalHighWatermark)));
        for (long invalidTxn : tableMaterializationTxnList.getInvalidWriteIds()) {
            RexNode literalInvalidTxn = this.rexBuilder.makeLiteral((Object)invalidTxn, bigIntType, false);
            conds.add(this.rexBuilder.makeCall((SqlOperator)SqlStdOperatorTable.NOT_EQUALS, ImmutableList.of(rowIDFieldAccess, literalInvalidTxn)));
        }
        relBuilder.filter(conds);
        call.transformTo(relBuilder.build());
    }
}

