/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.metadata;

import io.trino.hive.;
import io.trino.hive.$internal.com.google.common.base.Preconditions;
import io.trino.hive.$internal.org.apache.commons.lang.StringUtils;
import io.trino.hive.$internal.org.slf4j.Logger;
import io.trino.hive.$internal.org.slf4j.LoggerFactory;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.URL;
import java.net.URLDecoder;
import java.text.MessageFormat;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.jar.JarOutputStream;
import java.util.jar.Manifest;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import java.util.zip.ZipOutputStream;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.LocalFileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hive.common.JavaUtils;

public class JarUtils {
    private static final Logger log = LoggerFactory.getLogger(JarUtils.class);

    public static void addDependencyJars(Configuration conf, List<Class<?>> classes) throws IOException {
        LocalFileSystem localFs = FileSystem.getLocal((Configuration)conf);
        HashSet<String> jars = new HashSet<String>();
        jars.addAll(conf.getStringCollection("tmpjars"));
        HashMap<String, String> packagedClasses = new HashMap<String, String>();
        for (Class<?> clazz : classes) {
            if (clazz == null) continue;
            Path path = JarUtils.findOrCreateJar(clazz, (FileSystem)localFs, packagedClasses);
            if (path == null) {
                log.warn("Could not find jar for class " + clazz + " in order to ship it to the cluster.");
                continue;
            }
            if (!localFs.exists(path)) {
                log.warn("Could not validate jar file " + path + " for class " + clazz);
                continue;
            }
            jars.add(path.toString());
        }
        if (!jars.isEmpty()) {
            conf.set("tmpjars", StringUtils.join(jars, ","));
        }
    }

    private static Path findOrCreateJar(Class<?> my_class, FileSystem fs, Map<String, String> packagedClasses) throws IOException {
        String jar = JarUtils.findContainingJar(my_class, packagedClasses);
        if (StringUtils.isEmpty(jar)) {
            jar = JarUtils.getJar(my_class);
            JarUtils.updateMap(jar, packagedClasses);
        }
        if (StringUtils.isEmpty(jar)) {
            return null;
        }
        log.debug("For class {}, using jar {}", (Object)my_class.getName(), (Object)jar);
        return new Path(jar).makeQualified(fs);
    }

    private static void updateMap(String jar, Map<String, String> packagedClasses) throws IOException {
        if (StringUtils.isEmpty(jar)) {
            return;
        }
        try (ZipFile zip = new ZipFile(jar);){
            Enumeration<? extends ZipEntry> iter = zip.entries();
            while (iter.hasMoreElements()) {
                ZipEntry entry = iter.nextElement();
                if (!entry.getName().endsWith("class")) continue;
                packagedClasses.put(entry.getName(), jar);
            }
        }
    }

    private static String findContainingJar(Class<?> my_class, Map<String, String> packagedClasses) throws IOException {
        ClassLoader loader = my_class.getClassLoader();
        String class_file = my_class.getName().replaceAll("\\.", "/") + ".class";
        Enumeration<URL> itr = loader.getResources(class_file);
        while (itr.hasMoreElements()) {
            URL url = itr.nextElement();
            if (!"jar".equals(url.getProtocol())) continue;
            String toReturn = url.getPath();
            if (toReturn.startsWith("file:")) {
                toReturn = toReturn.substring("file:".length());
            }
            toReturn = toReturn.replaceAll("\\+", "%2B");
            toReturn = URLDecoder.decode(toReturn, "UTF-8");
            return toReturn.replaceAll("!.*$", "");
        }
        return packagedClasses.get(class_file);
    }

    private static String getJar(Class<?> my_class) {
        String ret = null;
        String hadoopJarFinder = "org.apache.hadoop.util.JarFinder";
        Class jarFinder = null;
        try {
            log.debug("Looking for: {}", (Object)hadoopJarFinder);
            jarFinder = JavaUtils.loadClass(hadoopJarFinder);
            log.debug("Found: {}", (Object)hadoopJarFinder);
            Method getJar = jarFinder.getMethod("getJar", Class.class);
            ret = (String)getJar.invoke(null, my_class);
        }
        catch (ClassNotFoundException e) {
            log.debug("Using backported JarFinder.");
            ret = JarUtils.jarFinderGetJar(my_class);
        }
        catch (InvocationTargetException e) {
            throw new RuntimeException(e.getCause());
        }
        catch (Exception e) {
            throw new RuntimeException("getJar invocation failed.", e);
        }
        return ret;
    }

    public static String jarFinderGetJar(Class klass) {
        Preconditions.checkNotNull(klass, "klass");
        ClassLoader loader = klass.getClassLoader();
        if (loader != null) {
            String class_file = klass.getName().replaceAll("\\.", "/") + ".class";
            try {
                Enumeration<URL> itr = loader.getResources(class_file);
                while (itr.hasMoreElements()) {
                    URL url = itr.nextElement();
                    String path = url.getPath();
                    if (path.startsWith("file:")) {
                        path = path.substring("file:".length());
                    }
                    path = URLDecoder.decode(path, "UTF-8");
                    if ("jar".equals(url.getProtocol())) {
                        path = URLDecoder.decode(path, "UTF-8");
                        return path.replaceAll("!.*$", "");
                    }
                    if (!"file".equals(url.getProtocol())) continue;
                    String klassName = klass.getName();
                    klassName = klassName.replace(".", "/") + ".class";
                    path = path.substring(0, path.length() - klassName.length());
                    File baseDir = new File(path);
                    File testDir = new File(System.getProperty("test.build.dir", "target/test-dir"));
                    if (!(testDir = testDir.getAbsoluteFile()).exists()) {
                        testDir.mkdirs();
                    }
                    File tempJar = File.createTempFile("hadoop-", "", testDir);
                    tempJar = new File(tempJar.getAbsolutePath() + ".jar");
                    JarUtils.createJar(baseDir, tempJar);
                    return tempJar.getAbsolutePath();
                }
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
        return null;
    }

    private static void copyToZipStream(InputStream is, ZipEntry entry, ZipOutputStream zos) throws IOException {
        zos.putNextEntry(entry);
        .IOUtils.copy((InputStream)is, (OutputStream)zos);
        is.close();
        zos.closeEntry();
    }

    public static void jarDir(File dir, String relativePath, ZipOutputStream zos) throws IOException {
        Preconditions.checkNotNull(relativePath, "relativePath");
        Preconditions.checkNotNull(zos, "zos");
        File manifestFile = new File(dir, "META-INF/MANIFEST.MF");
        ZipEntry manifestEntry = new ZipEntry("META-INF/MANIFEST.MF");
        if (!manifestFile.exists()) {
            zos.putNextEntry(manifestEntry);
            new Manifest().write(new BufferedOutputStream(zos));
            zos.closeEntry();
        } else {
            FileInputStream is = new FileInputStream(manifestFile);
            JarUtils.copyToZipStream(is, manifestEntry, zos);
        }
        zos.closeEntry();
        JarUtils.zipDir(dir, relativePath, zos, true);
        zos.close();
    }

    private static void zipDir(File dir, String relativePath, ZipOutputStream zos, boolean start) throws IOException {
        String[] dirList;
        for (String aDirList : dirList = dir.list()) {
            File f = new File(dir, aDirList);
            if (f.isHidden()) continue;
            if (f.isDirectory()) {
                if (!start) {
                    ZipEntry dirEntry = new ZipEntry(relativePath + f.getName() + "/");
                    zos.putNextEntry(dirEntry);
                    zos.closeEntry();
                }
                String filePath = f.getPath();
                File file = new File(filePath);
                JarUtils.zipDir(file, relativePath + f.getName() + "/", zos, false);
                continue;
            }
            String path = relativePath + f.getName();
            if (path.equals("META-INF/MANIFEST.MF")) continue;
            ZipEntry anEntry = new ZipEntry(path);
            FileInputStream is = new FileInputStream(f);
            JarUtils.copyToZipStream(is, anEntry, zos);
        }
    }

    private static void createJar(File dir, File jarFile) throws IOException {
        Preconditions.checkNotNull(dir, "dir");
        Preconditions.checkNotNull(jarFile, "jarFile");
        File jarDir = jarFile.getParentFile();
        if (!jarDir.exists() && !jarDir.mkdirs()) {
            throw new IOException(MessageFormat.format("could not create dir [{0}]", jarDir));
        }
        JarOutputStream zos = new JarOutputStream(new FileOutputStream(jarFile));
        JarUtils.jarDir(dir, "", zos);
    }
}

