/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.exec.persistence;

import com.esotericsoftware.kryo.Kryo;
import com.esotericsoftware.kryo.io.Input;
import com.esotericsoftware.kryo.io.Output;
import io.trino.hive.$internal.com.google.common.annotations.VisibleForTesting;
import io.trino.hive.$internal.com.google.common.base.Preconditions;
import io.trino.hive.$internal.org.slf4j.Logger;
import io.trino.hive.$internal.org.slf4j.LoggerFactory;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.apache.hadoop.fs.FileUtil;
import org.apache.hadoop.hive.common.FileUtils;
import org.apache.hadoop.hive.ql.exec.SerializationUtilities;
import org.apache.hadoop.hive.ql.metadata.HiveException;

public class ObjectContainer<ROW> {
    private static final Logger LOG = LoggerFactory.getLogger(ObjectContainer.class);
    @VisibleForTesting
    static final int IN_MEMORY_NUM_ROWS = 1024;
    private ROW[] readBuffer = new Object[1024];
    private boolean readBufferUsed = false;
    private int rowsInReadBuffer = 0;
    private int readCursor = 0;
    private int rowsOnDisk = 0;
    private File parentDir;
    private File tmpFile;
    private Input input;
    private Output output;

    public ObjectContainer(String spillLocalDirs) {
        for (int i = 0; i < 1024; ++i) {
            this.readBuffer[i] = new Object();
        }
        try {
            this.setupOutput(spillLocalDirs);
        }
        catch (IOException | HiveException e) {
            throw new RuntimeException("Failed to create temporary output file on disk", e);
        }
    }

    private void setupOutput(String spillLocalDirs) throws IOException, HiveException {
        FileOutputStream fos = null;
        try {
            if (this.parentDir == null) {
                this.parentDir = FileUtils.createLocalDirsTempFile(spillLocalDirs, "object-container", "", true);
            }
            if (this.tmpFile == null || this.input != null) {
                this.tmpFile = File.createTempFile("ObjectContainer", ".tmp", this.parentDir);
                LOG.info("ObjectContainer created temp file " + this.tmpFile.getAbsolutePath());
                this.tmpFile.deleteOnExit();
            }
            fos = new FileOutputStream(this.tmpFile);
            this.output = new Output((OutputStream)fos);
        }
        catch (IOException e) {
            throw new HiveException(e);
        }
        finally {
            if (this.output == null && fos != null) {
                fos.close();
            }
        }
    }

    public void add(ROW row) {
        Kryo kryo = SerializationUtilities.borrowKryo();
        try {
            kryo.writeClassAndObject(this.output, row);
        }
        finally {
            SerializationUtilities.releaseKryo(kryo);
        }
        ++this.rowsOnDisk;
    }

    public void clear() {
        this.rowsOnDisk = 0;
        this.rowsInReadBuffer = 0;
        this.readCursor = 0;
        this.readBufferUsed = false;
        if (this.parentDir != null) {
            if (this.input != null) {
                try {
                    this.input.close();
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
                this.input = null;
            }
            if (this.output != null) {
                try {
                    this.output.close();
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
                this.output = null;
            }
            try {
                FileUtil.fullyDelete((File)this.parentDir);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            this.parentDir = null;
            this.tmpFile = null;
        }
    }

    public boolean hasNext() {
        return this.readBufferUsed || this.rowsOnDisk > 0;
    }

    public ROW next() {
        block15: {
            Preconditions.checkState(this.hasNext());
            if (!this.readBufferUsed) {
                try {
                    if (this.input == null && this.output != null) {
                        this.output.close();
                        this.output = null;
                        FileInputStream fis = null;
                        try {
                            fis = new FileInputStream(this.tmpFile);
                            this.input = new Input((InputStream)fis);
                        }
                        finally {
                            if (this.input == null && fis != null) {
                                fis.close();
                            }
                        }
                    }
                    if (this.input == null) break block15;
                    this.rowsInReadBuffer = this.rowsOnDisk >= 1024 ? 1024 : this.rowsOnDisk;
                    Kryo kryo = SerializationUtilities.borrowKryo();
                    try {
                        for (int i = 0; i < this.rowsInReadBuffer; ++i) {
                            this.readBuffer[i] = kryo.readClassAndObject(this.input);
                        }
                    }
                    finally {
                        SerializationUtilities.releaseKryo(kryo);
                    }
                    if (this.input.eof()) {
                        this.input.close();
                        this.input = null;
                    }
                    this.readBufferUsed = true;
                    this.readCursor = 0;
                    this.rowsOnDisk -= this.rowsInReadBuffer;
                }
                catch (Exception e) {
                    this.clear();
                    throw new RuntimeException("Failed to load rows from disk", e);
                }
            }
        }
        ROW row = this.readBuffer[this.readCursor];
        if (++this.readCursor >= this.rowsInReadBuffer) {
            this.readBufferUsed = false;
            this.rowsInReadBuffer = 0;
            this.readCursor = 0;
        }
        return row;
    }

    public int size() {
        return this.rowsInReadBuffer + this.rowsOnDisk;
    }
}

