/*
 * Decompiled with CFR 0.152.
 */
package io.temporal.testing;

import io.temporal.api.common.v1.WorkflowExecution;
import io.temporal.client.UpdateOptions;
import io.temporal.client.WorkflowExecutionDescription;
import io.temporal.client.WorkflowOptions;
import io.temporal.client.WorkflowStub;
import io.temporal.client.WorkflowUpdateHandle;
import io.temporal.client.WorkflowUpdateStage;
import io.temporal.common.interceptors.WorkflowClientInterceptorBase;
import io.temporal.serviceclient.TestServiceStubs;
import io.temporal.testing.IdempotentTimeLocker;
import java.lang.reflect.Type;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import javax.annotation.Nullable;

class TimeLockingInterceptor
extends WorkflowClientInterceptorBase {
    private final IdempotentTimeLocker locker;

    TimeLockingInterceptor(TestServiceStubs testServiceStubs) {
        this.locker = new IdempotentTimeLocker(testServiceStubs);
    }

    @Deprecated
    public WorkflowStub newUntypedWorkflowStub(String workflowType, WorkflowOptions options, WorkflowStub next) {
        return new TimeLockingWorkflowStub(this.locker, next);
    }

    @Deprecated
    public WorkflowStub newUntypedWorkflowStub(WorkflowExecution execution, Optional<String> workflowType, WorkflowStub next) {
        return new TimeLockingWorkflowStub(this.locker, next);
    }

    static class TimeLockingWorkflowStub
    implements WorkflowStub {
        private final IdempotentTimeLocker locker;
        private final WorkflowStub next;

        TimeLockingWorkflowStub(IdempotentTimeLocker locker, WorkflowStub next) {
            this.locker = locker;
            this.next = next;
        }

        public void signal(String signalName, Object ... args) {
            this.next.signal(signalName, args);
        }

        public WorkflowExecution start(Object ... args) {
            return this.next.start(args);
        }

        public <R> WorkflowUpdateHandle<R> startUpdateWithStart(UpdateOptions<R> options, Object[] updateArgs, Object[] startArgs) {
            return this.next.startUpdateWithStart(options, updateArgs, startArgs);
        }

        public <R> R executeUpdateWithStart(UpdateOptions<R> updateOptions, Object[] updateArgs, Object[] startArgs) {
            return (R)this.next.executeUpdateWithStart(updateOptions, updateArgs, startArgs);
        }

        public WorkflowExecution signalWithStart(String signalName, Object[] signalArgs, Object[] startArgs) {
            return this.next.signalWithStart(signalName, signalArgs, startArgs);
        }

        public Optional<String> getWorkflowType() {
            return this.next.getWorkflowType();
        }

        public WorkflowExecution getExecution() {
            return this.next.getExecution();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public <R> R getResult(Class<R> resultClass, Type resultType) {
            this.locker.unlockTimeSkipping();
            try {
                Object object = this.next.getResult(resultClass, resultType);
                return (R)object;
            }
            finally {
                this.locker.lockTimeSkipping();
            }
        }

        public <R> R getResult(Class<R> resultClass) {
            this.locker.unlockTimeSkipping();
            try {
                Object object = this.next.getResult(resultClass);
                return (R)object;
            }
            finally {
                this.locker.lockTimeSkipping();
            }
        }

        public <R> CompletableFuture<R> getResultAsync(Class<R> resultClass, Type resultType) {
            return new TimeLockingFuture(this.next.getResultAsync(resultClass, resultType));
        }

        public <R> CompletableFuture<R> getResultAsync(Class<R> resultClass) {
            return new TimeLockingFuture(this.next.getResultAsync(resultClass));
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public <R> R getResult(long timeout, TimeUnit unit, Class<R> resultClass, Type resultType) throws TimeoutException {
            this.locker.unlockTimeSkipping();
            try {
                Object object = this.next.getResult(timeout, unit, resultClass, resultType);
                return (R)object;
            }
            finally {
                this.locker.lockTimeSkipping();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public <R> R getResult(long timeout, TimeUnit unit, Class<R> resultClass) throws TimeoutException {
            this.locker.unlockTimeSkipping();
            try {
                Object object = this.next.getResult(timeout, unit, resultClass);
                return (R)object;
            }
            finally {
                this.locker.lockTimeSkipping();
            }
        }

        public <R> CompletableFuture<R> getResultAsync(long timeout, TimeUnit unit, Class<R> resultClass, Type resultType) {
            return new TimeLockingFuture(this.next.getResultAsync(timeout, unit, resultClass, resultType));
        }

        public <R> CompletableFuture<R> getResultAsync(long timeout, TimeUnit unit, Class<R> resultClass) {
            return new TimeLockingFuture(this.next.getResultAsync(timeout, unit, resultClass));
        }

        public <R> R query(String queryType, Class<R> resultClass, Object ... args) {
            return (R)this.next.query(queryType, resultClass, args);
        }

        public <R> R query(String queryType, Class<R> resultClass, Type resultType, Object ... args) {
            return (R)this.next.query(queryType, resultClass, resultType, args);
        }

        public void cancel() {
            this.next.cancel();
        }

        public void terminate(@Nullable String reason, Object ... details) {
            this.next.terminate(reason, details);
        }

        public Optional<WorkflowOptions> getOptions() {
            return this.next.getOptions();
        }

        public WorkflowStub newInstance(WorkflowOptions options) {
            return new TimeLockingWorkflowStub(this.locker, this.next.newInstance(options));
        }

        public WorkflowExecutionDescription describe() {
            return this.next.describe();
        }

        public <R> R update(String updateName, Class<R> resultClass, Object ... args) {
            return (R)this.next.update(updateName, resultClass, args);
        }

        public <R> WorkflowUpdateHandle<R> startUpdate(String updateName, WorkflowUpdateStage waitForStage, Class<R> resultClass, Object ... args) {
            return this.next.startUpdate(updateName, waitForStage, resultClass, args);
        }

        public <R> WorkflowUpdateHandle<R> startUpdate(UpdateOptions<R> options, Object ... args) {
            return this.next.startUpdate(options, args);
        }

        public <R> WorkflowUpdateHandle<R> getUpdateHandle(String updateId, Class<R> resultClass) {
            return this.next.getUpdateHandle(updateId, resultClass);
        }

        public <R> WorkflowUpdateHandle<R> getUpdateHandle(String updateId, Class<R> resultClass, Type resultType) {
            return this.next.getUpdateHandle(updateId, resultClass, resultType);
        }

        private class TimeLockingFuture<R>
        extends CompletableFuture<R> {
            public TimeLockingFuture(CompletableFuture<R> resultAsync) {
                CompletionStage ignored = resultAsync.whenComplete((T r, U e) -> {
                    if (e == null) {
                        this.complete(r);
                    } else {
                        this.completeExceptionally((Throwable)e);
                    }
                });
            }

            @Override
            public R get() throws InterruptedException, ExecutionException {
                TimeLockingWorkflowStub.this.locker.unlockTimeSkipping();
                try {
                    Object t = super.get();
                    return (R)t;
                }
                finally {
                    TimeLockingWorkflowStub.this.locker.lockTimeSkipping();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public R get(long timeout, TimeUnit unit) throws InterruptedException, ExecutionException, TimeoutException {
                TimeLockingWorkflowStub.this.locker.unlockTimeSkipping();
                try {
                    Object t = super.get(timeout, unit);
                    return (R)t;
                }
                finally {
                    TimeLockingWorkflowStub.this.locker.lockTimeSkipping();
                }
            }

            @Override
            public R join() {
                TimeLockingWorkflowStub.this.locker.unlockTimeSkipping();
                try {
                    Object t = super.join();
                    return (R)t;
                }
                finally {
                    TimeLockingWorkflowStub.this.locker.lockTimeSkipping();
                }
            }
        }
    }
}

