/*
 * Decompiled with CFR 0.152.
 */
package io.temporal.internal.testservice;

import com.google.protobuf.ByteString;
import io.temporal.api.common.v1.Payload;
import io.temporal.common.converter.DefaultDataConverter;
import io.temporal.internal.testservice.StateMachines;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.Nonnull;

class StateUtils {
    private static Payload nullPayload = (Payload)DefaultDataConverter.STANDARD_INSTANCE.toPayload(null).get();
    private static Payload emptyListPayload = (Payload)DefaultDataConverter.STANDARD_INSTANCE.toPayload((Object)new String[0]).get();

    StateUtils() {
    }

    public static boolean isWorkflowExecutionForcefullyCompleted(StateMachines.State state) {
        switch (state) {
            case TERMINATED: 
            case TIMED_OUT: {
                return true;
            }
        }
        return false;
    }

    private static boolean isEqual(Payload a, Payload b) {
        String bEnc;
        String aEnc = a.getMetadataOrDefault("encoding", ByteString.EMPTY).toStringUtf8();
        return aEnc.equals(bEnc = b.getMetadataOrDefault("encoding", ByteString.EMPTY).toStringUtf8()) && a.getData().equals((Object)b.getData());
    }

    @Nonnull
    public static Map<String, Payload> mergeMemo(@Nonnull Map<String, Payload> src, @Nonnull Map<String, Payload> dst) {
        HashMap<String, Payload> result = new HashMap<String, Payload>(src);
        dst.forEach((k, v) -> {
            if (v == null || StateUtils.isEqual(v, nullPayload) || StateUtils.isEqual(v, emptyListPayload)) {
                result.remove(k);
                return;
            }
            result.put((String)k, (Payload)v);
        });
        return result;
    }
}

