/*
 * Decompiled with CFR 0.152.
 */
package io.temporal.spring.boot.autoconfigure.template;

import io.opentracing.Tracer;
import io.temporal.common.interceptors.WorkerInterceptor;
import io.temporal.opentracing.OpenTracingOptions;
import io.temporal.opentracing.OpenTracingWorkerInterceptor;
import io.temporal.spring.boot.TemporalOptionsCustomizer;
import io.temporal.spring.boot.autoconfigure.properties.NamespaceProperties;
import io.temporal.worker.WorkerFactoryOptions;
import java.util.Optional;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class WorkerFactoryOptionsTemplate {
    @Nonnull
    private final NamespaceProperties namespaceProperties;
    @Nullable
    private final Tracer tracer;
    @Nullable
    private final TemporalOptionsCustomizer<WorkerFactoryOptions.Builder> customizer;

    public WorkerFactoryOptionsTemplate(@Nonnull NamespaceProperties namespaceProperties, @Nullable Tracer tracer, @Nullable TemporalOptionsCustomizer<WorkerFactoryOptions.Builder> customizer) {
        this.namespaceProperties = namespaceProperties;
        this.tracer = tracer;
        this.customizer = customizer;
    }

    public WorkerFactoryOptions createWorkerFactoryOptions() {
        WorkerFactoryOptions.Builder options = WorkerFactoryOptions.newBuilder();
        NamespaceProperties.WorkflowCacheProperties workflowCache = this.namespaceProperties.getWorkflowCache();
        if (workflowCache != null) {
            Optional.ofNullable(workflowCache.getMaxInstances()).ifPresent(arg_0 -> ((WorkerFactoryOptions.Builder)options).setWorkflowCacheSize(arg_0));
            Optional.ofNullable(workflowCache.getMaxThreads()).ifPresent(arg_0 -> ((WorkerFactoryOptions.Builder)options).setMaxWorkflowThreadCount(arg_0));
            Optional.ofNullable(workflowCache.isUsingVirtualWorkflowThreads()).ifPresent(arg_0 -> ((WorkerFactoryOptions.Builder)options).setUsingVirtualWorkflowThreads(arg_0));
        }
        if (this.tracer != null) {
            OpenTracingWorkerInterceptor openTracingClientInterceptor = new OpenTracingWorkerInterceptor(OpenTracingOptions.newBuilder().setTracer(this.tracer).build());
            options.setWorkerInterceptors(new WorkerInterceptor[]{openTracingClientInterceptor});
        }
        if (this.customizer != null) {
            options = this.customizer.customize(options);
        }
        return options.build();
    }
}

