/*
 * Decompiled with CFR 0.152.
 */
package io.temporal.worker.tuning;

import io.temporal.common.Experimental;
import io.temporal.worker.tuning.PollerBehavior;
import java.util.Objects;

@Experimental
public final class PollerBehaviorAutoscaling
implements PollerBehavior {
    private final int minConcurrentTaskPollers;
    private final int maxConcurrentTaskPollers;
    private final int initialConcurrentTaskPollers;

    public PollerBehaviorAutoscaling(int minConcurrentTaskPollers, int maxConcurrentTaskPollers, int initialConcurrentTaskPollers) {
        if (minConcurrentTaskPollers < 1) {
            throw new IllegalArgumentException("minConcurrentTaskPollers must be at least 1");
        }
        if (maxConcurrentTaskPollers < minConcurrentTaskPollers) {
            throw new IllegalArgumentException("maxConcurrentTaskPollers must be greater than or equal to minConcurrentTaskPollers");
        }
        if (initialConcurrentTaskPollers < minConcurrentTaskPollers || initialConcurrentTaskPollers > maxConcurrentTaskPollers) {
            throw new IllegalArgumentException("initialConcurrentTaskPollers must be between minConcurrentTaskPollers and maxConcurrentTaskPollers");
        }
        this.minConcurrentTaskPollers = minConcurrentTaskPollers;
        this.maxConcurrentTaskPollers = maxConcurrentTaskPollers;
        this.initialConcurrentTaskPollers = initialConcurrentTaskPollers;
    }

    public int getMinConcurrentTaskPollers() {
        return this.minConcurrentTaskPollers;
    }

    public int getMaxConcurrentTaskPollers() {
        return this.maxConcurrentTaskPollers;
    }

    public int getInitialMaxConcurrentTaskPollers() {
        return this.initialConcurrentTaskPollers;
    }

    public boolean equals(Object o) {
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PollerBehaviorAutoscaling that = (PollerBehaviorAutoscaling)o;
        return this.minConcurrentTaskPollers == that.minConcurrentTaskPollers && this.maxConcurrentTaskPollers == that.maxConcurrentTaskPollers && this.initialConcurrentTaskPollers == that.initialConcurrentTaskPollers;
    }

    public int hashCode() {
        return Objects.hash(this.minConcurrentTaskPollers, this.maxConcurrentTaskPollers, this.initialConcurrentTaskPollers);
    }

    public String toString() {
        return "PollerBehaviorAutoscaling{minConcurrentTaskPollers=" + this.minConcurrentTaskPollers + ", maxConcurrentTaskPollers=" + this.maxConcurrentTaskPollers + ", initialConcurrentTaskPollers=" + this.initialConcurrentTaskPollers + '}';
    }
}

