/*
 * Decompiled with CFR 0.152.
 */
package io.temporal.common.metadata;

import com.google.common.base.Objects;
import com.google.common.collect.ImmutableList;
import io.temporal.common.Experimental;
import io.temporal.common.VersioningBehavior;
import io.temporal.common.metadata.POJOReflectionUtils;
import io.temporal.common.metadata.POJOWorkflowInterfaceMetadata;
import io.temporal.common.metadata.POJOWorkflowMethodMetadata;
import io.temporal.common.metadata.WorkflowMethodType;
import io.temporal.internal.common.InternalUtils;
import io.temporal.internal.common.env.ReflectionUtils;
import io.temporal.workflow.WorkflowVersioningBehavior;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Nullable;

public final class POJOWorkflowImplMetadata {
    private final Class<?> implementationClass;
    private final List<POJOWorkflowInterfaceMetadata> workflowInterfaces;
    private final List<POJOWorkflowMethodMetadata> workflowMethods;
    private final List<POJOWorkflowMethodMetadata> signalMethods;
    private final List<POJOWorkflowMethodMetadata> queryMethods;
    private final List<POJOWorkflowMethodMetadata> updateMethods;
    private final List<POJOWorkflowMethodMetadata> updateValidatorMethods;
    private final Constructor<?> workflowInit;

    public static POJOWorkflowImplMetadata newInstance(Class<?> implClass) {
        return new POJOWorkflowImplMetadata(implClass, false, true);
    }

    public static POJOWorkflowImplMetadata newInstanceForWorkflowFactory(Class<?> implClass) {
        return new POJOWorkflowImplMetadata(implClass, false, false);
    }

    public static POJOWorkflowImplMetadata newListenerInstance(Class<?> implClass) {
        return new POJOWorkflowImplMetadata(implClass, true, false);
    }

    private POJOWorkflowImplMetadata(Class<?> implClass, boolean listener, boolean validateConstructor) {
        if (implClass.isInterface() || implClass.isPrimitive() || implClass.isAnnotation() || implClass.isArray() || implClass.isEnum()) {
            throw new IllegalArgumentException("concrete class expected: " + implClass);
        }
        this.implementationClass = implClass;
        ArrayList<POJOWorkflowInterfaceMetadata> workflowInterfaces = new ArrayList<POJOWorkflowInterfaceMetadata>();
        HashMap<String, POJOWorkflowMethodMetadata> workflowMethods = new HashMap<String, POJOWorkflowMethodMetadata>();
        HashMap<String, POJOWorkflowMethodMetadata> queryMethods = new HashMap<String, POJOWorkflowMethodMetadata>();
        HashMap<String, POJOWorkflowMethodMetadata> signalMethods = new HashMap<String, POJOWorkflowMethodMetadata>();
        HashMap<String, POJOWorkflowMethodMetadata> updateMethods = new HashMap<String, POJOWorkflowMethodMetadata>();
        HashMap<String, POJOWorkflowMethodMetadata> updateValidatorMethods = new HashMap<String, POJOWorkflowMethodMetadata>();
        HashMap<EqualsByNameType, POJOWorkflowMethodMetadata> byNameType = new HashMap<EqualsByNameType, POJOWorkflowMethodMetadata>();
        Set<Class<?>> interfaces = POJOReflectionUtils.getTopLevelInterfaces(implClass);
        for (Class<?> anInterface : interfaces) {
            POJOWorkflowInterfaceMetadata interfaceMetadata = POJOWorkflowInterfaceMetadata.newImplementationInstance(anInterface, listener);
            List<POJOWorkflowMethodMetadata> methods = interfaceMetadata.getMethodsMetadata();
            if (!methods.isEmpty()) {
                workflowInterfaces.add(interfaceMetadata);
            }
            for (POJOWorkflowMethodMetadata methodMetadata : methods) {
                EqualsByNameType key = new EqualsByNameType(methodMetadata.getName(), methodMetadata.getType());
                POJOWorkflowMethodMetadata registeredMM = byNameType.put(key, methodMetadata);
                if (registeredMM != null && !registeredMM.getWorkflowMethod().equals(methodMetadata.getWorkflowMethod())) {
                    throw new IllegalArgumentException("Duplicated name of " + (Object)((Object)methodMetadata.getType()) + ": \"" + methodMetadata.getName() + "\" declared at \"" + registeredMM.getWorkflowMethod() + "\" and \"" + methodMetadata.getWorkflowMethod() + "\"");
                }
                InternalUtils.checkMethodName(methodMetadata);
                switch (methodMetadata.getType()) {
                    case WORKFLOW: {
                        workflowMethods.put(methodMetadata.getName(), methodMetadata);
                        break;
                    }
                    case SIGNAL: {
                        signalMethods.put(methodMetadata.getName(), methodMetadata);
                        break;
                    }
                    case QUERY: {
                        queryMethods.put(methodMetadata.getName(), methodMetadata);
                        break;
                    }
                    case UPDATE: {
                        updateMethods.put(methodMetadata.getName(), methodMetadata);
                        break;
                    }
                    case UPDATE_VALIDATOR: {
                        updateValidatorMethods.put(methodMetadata.getName(), methodMetadata);
                    }
                }
            }
        }
        if (byNameType.isEmpty() && !listener) {
            throw new IllegalArgumentException("Class doesn't implement any non empty public interface annotated with @WorkflowInterface: " + implClass.getName());
        }
        this.workflowInterfaces = ImmutableList.copyOf(workflowInterfaces);
        this.workflowMethods = ImmutableList.copyOf(workflowMethods.values());
        this.signalMethods = ImmutableList.copyOf(signalMethods.values());
        this.queryMethods = ImmutableList.copyOf(queryMethods.values());
        this.updateMethods = ImmutableList.copyOf(updateMethods.values());
        this.updateValidatorMethods = ImmutableList.copyOf(updateValidatorMethods.values());
        if (!listener) {
            this.workflowInit = ReflectionUtils.getWorkflowInitConstructor(implClass, this.workflowMethods.stream().map(POJOWorkflowMethodMetadata::getWorkflowMethod).collect(Collectors.toList())).orElse(null);
            if (validateConstructor) {
                Constructor defaultConstructor = ReflectionUtils.getPublicDefaultConstructor(implClass).orElse(null);
                if (defaultConstructor == null && this.workflowInit == null) {
                    throw new IllegalArgumentException("No default constructor or constructor annotated with @WorkflowInit found: " + implClass.getName());
                }
                if (defaultConstructor != null && this.workflowInit != null) {
                    throw new IllegalArgumentException("Found both a default constructor and constructor annotated with @WorkflowInit: " + implClass.getName());
                }
            }
        } else {
            this.workflowInit = null;
        }
    }

    public List<POJOWorkflowInterfaceMetadata> getWorkflowInterfaces() {
        return this.workflowInterfaces;
    }

    public List<POJOWorkflowMethodMetadata> getWorkflowMethods() {
        return this.workflowMethods;
    }

    public List<POJOWorkflowMethodMetadata> getSignalMethods() {
        return this.signalMethods;
    }

    public List<POJOWorkflowMethodMetadata> getQueryMethods() {
        return this.queryMethods;
    }

    public List<POJOWorkflowMethodMetadata> getUpdateMethods() {
        return this.updateMethods;
    }

    public List<POJOWorkflowMethodMetadata> getUpdateValidatorMethods() {
        return this.updateValidatorMethods;
    }

    @Experimental
    @Nullable
    public Constructor<?> getWorkflowInit() {
        return this.workflowInit;
    }

    @Experimental
    @Nullable
    public static VersioningBehavior getVersioningBehaviorForMethod(Class<?> implementationClass, POJOWorkflowMethodMetadata workflowMethod) {
        Method implMethod;
        Method method = workflowMethod.getWorkflowMethod();
        try {
            implMethod = implementationClass.getMethod(method.getName(), method.getParameterTypes());
        }
        catch (NoSuchMethodException e) {
            throw new RuntimeException("Unable to find workflow method " + workflowMethod.getName() + " in implementation class " + implementationClass.getName(), e);
        }
        if (implMethod.isAnnotationPresent(WorkflowVersioningBehavior.class)) {
            WorkflowVersioningBehavior vb = implMethod.getAnnotation(WorkflowVersioningBehavior.class);
            return vb.value();
        }
        return null;
    }

    private static class EqualsByNameType {
        private final String name;
        private final WorkflowMethodType type;

        EqualsByNameType(String name, WorkflowMethodType type) {
            this.name = name;
            this.type = type;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            EqualsByNameType that = (EqualsByNameType)o;
            return Objects.equal((Object)this.name, (Object)that.name) && this.type == that.type;
        }

        public int hashCode() {
            return Objects.hashCode((Object[])new Object[]{this.name, this.type});
        }
    }
}

