/*
 * Decompiled with CFR 0.152.
 */
package io.temporal.client;

import io.temporal.api.enums.v1.TaskReachability;
import io.temporal.api.taskqueue.v1.TaskQueueReachability;
import io.temporal.api.workflowservice.v1.GetWorkerTaskReachabilityResponse;
import io.temporal.client.BuildIdReachability;
import io.temporal.common.Experimental;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;

@Experimental
public class WorkerTaskReachability {
    private final Map<String, BuildIdReachability> buildIdReachability;

    public WorkerTaskReachability(GetWorkerTaskReachabilityResponse reachabilityResponse) {
        this.buildIdReachability = new HashMap<String, BuildIdReachability>(reachabilityResponse.getBuildIdReachabilityList().size());
        for (io.temporal.api.taskqueue.v1.BuildIdReachability BuildReachability : reachabilityResponse.getBuildIdReachabilityList()) {
            HashSet<String> unretrievedTaskQueues = new HashSet<String>();
            HashMap<String, List<TaskReachability>> retrievedTaskQueues = new HashMap<String, List<TaskReachability>>();
            for (TaskQueueReachability taskQueueReachability : BuildReachability.getTaskQueueReachabilityList()) {
                if (taskQueueReachability.getReachabilityList().size() == 1 && taskQueueReachability.getReachabilityList().get(0) == TaskReachability.TASK_REACHABILITY_UNSPECIFIED) {
                    unretrievedTaskQueues.add(taskQueueReachability.getTaskQueue());
                    continue;
                }
                retrievedTaskQueues.put(taskQueueReachability.getTaskQueue(), taskQueueReachability.getReachabilityList());
            }
            this.buildIdReachability.put(BuildReachability.getBuildId(), new BuildIdReachability(retrievedTaskQueues, unretrievedTaskQueues));
        }
    }

    public Map<String, BuildIdReachability> getBuildIdReachability() {
        return Collections.unmodifiableMap(this.buildIdReachability);
    }
}

