/*
 * Decompiled with CFR 0.152.
 */
package io.temporal.payload.codec;

import io.temporal.api.common.v1.Payload;
import io.temporal.payload.codec.PayloadCodec;
import io.temporal.payload.context.SerializationContext;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.ListIterator;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class ChainCodec
implements PayloadCodec {
    private final List<PayloadCodec> codecs;
    @Nullable
    private final SerializationContext context;

    public ChainCodec(Collection<PayloadCodec> codecs) {
        this(codecs, null);
    }

    ChainCodec(Collection<PayloadCodec> codecs, @Nullable SerializationContext context) {
        this.codecs = new ArrayList<PayloadCodec>(codecs);
        this.context = context;
    }

    @Override
    @Nonnull
    public List<Payload> encode(@Nonnull List<Payload> payloads) {
        ListIterator<PayloadCodec> iterator = this.codecs.listIterator(this.codecs.size());
        while (iterator.hasPrevious()) {
            PayloadCodec codec = iterator.previous();
            payloads = (this.context != null ? codec.withContext(this.context) : codec).encode(payloads);
        }
        return payloads;
    }

    @Override
    @Nonnull
    public List<Payload> decode(@Nonnull List<Payload> payloads) {
        for (PayloadCodec codec : this.codecs) {
            payloads = (this.context != null ? codec.withContext(this.context) : codec).decode(payloads);
        }
        return payloads;
    }

    @Override
    @Nonnull
    public PayloadCodec withContext(@Nonnull SerializationContext context) {
        return new ChainCodec(this.codecs, context);
    }
}

