/*
 * Decompiled with CFR 0.152.
 */
package io.temporal.internal.replay;

import com.uber.m3.tally.Scope;
import io.temporal.api.command.v1.ContinueAsNewWorkflowExecutionCommandAttributes;
import io.temporal.api.command.v1.RequestCancelExternalWorkflowExecutionCommandAttributes;
import io.temporal.api.command.v1.ScheduleActivityTaskCommandAttributes;
import io.temporal.api.command.v1.SignalExternalWorkflowExecutionCommandAttributes;
import io.temporal.api.command.v1.StartTimerCommandAttributes;
import io.temporal.api.common.v1.Payload;
import io.temporal.api.common.v1.Payloads;
import io.temporal.api.common.v1.SearchAttributes;
import io.temporal.api.common.v1.WorkflowExecution;
import io.temporal.api.common.v1.WorkflowType;
import io.temporal.api.failure.v1.Failure;
import io.temporal.api.history.v1.HistoryEvent;
import io.temporal.api.history.v1.WorkflowExecutionStartedEventAttributes;
import io.temporal.failure.CanceledFailure;
import io.temporal.internal.common.ProtobufTimeUtils;
import io.temporal.internal.common.SdkFlag;
import io.temporal.internal.replay.BasicWorkflowContext;
import io.temporal.internal.replay.ReplayAwareScope;
import io.temporal.internal.replay.ReplayWorkflowContext;
import io.temporal.internal.replay.WorkflowMutableState;
import io.temporal.internal.statemachines.ExecuteActivityParameters;
import io.temporal.internal.statemachines.ExecuteLocalActivityParameters;
import io.temporal.internal.statemachines.LocalActivityCallback;
import io.temporal.internal.statemachines.StartChildWorkflowExecutionParameters;
import io.temporal.internal.statemachines.WorkflowStateMachines;
import io.temporal.internal.worker.SingleWorkerOptions;
import io.temporal.workflow.Functions;
import java.time.Duration;
import java.util.Map;
import java.util.Optional;
import java.util.Random;
import java.util.UUID;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

final class ReplayWorkflowContextImpl
implements ReplayWorkflowContext {
    private final BasicWorkflowContext basicWorkflowContext;
    private final WorkflowStateMachines workflowStateMachines;
    private final WorkflowMutableState mutableState;
    @Nullable
    private final String fullReplayDirectQueryName;
    private final Scope replayAwareWorkflowMetricsScope;
    private final SingleWorkerOptions workerOptions;

    ReplayWorkflowContextImpl(WorkflowStateMachines workflowStateMachines, String namespace, WorkflowExecutionStartedEventAttributes startedAttributes, WorkflowExecution workflowExecution, long runStartedTimestampMillis, @Nullable String fullReplayDirectQueryName, SingleWorkerOptions workerOptions, Scope workflowMetricsScope) {
        this.workflowStateMachines = workflowStateMachines;
        this.basicWorkflowContext = new BasicWorkflowContext(namespace, workflowExecution, startedAttributes, runStartedTimestampMillis);
        this.mutableState = new WorkflowMutableState(startedAttributes);
        this.fullReplayDirectQueryName = fullReplayDirectQueryName;
        this.replayAwareWorkflowMetricsScope = new ReplayAwareScope(workflowMetricsScope, this, workflowStateMachines::currentTimeMillis);
        this.workerOptions = workerOptions;
    }

    @Override
    public boolean getEnableLoggingInReplay() {
        return this.workerOptions.getEnableLoggingInReplay();
    }

    @Override
    public UUID randomUUID() {
        return this.workflowStateMachines.randomUUID();
    }

    @Override
    public Random newRandom() {
        return this.workflowStateMachines.newRandom();
    }

    @Override
    public Scope getMetricsScope() {
        return this.replayAwareWorkflowMetricsScope;
    }

    @Override
    @Nonnull
    public WorkflowExecution getWorkflowExecution() {
        return this.basicWorkflowContext.getWorkflowExecution();
    }

    @Override
    public WorkflowExecution getParentWorkflowExecution() {
        return this.basicWorkflowContext.getParentWorkflowExecution();
    }

    @Override
    public String getFirstExecutionRunId() {
        return this.basicWorkflowContext.getFirstExecutionRunId();
    }

    @Override
    public Optional<String> getContinuedExecutionRunId() {
        return this.basicWorkflowContext.getContinuedExecutionRunId();
    }

    @Override
    public String getOriginalExecutionRunId() {
        return this.basicWorkflowContext.getOriginalExecutionRunId();
    }

    @Override
    public WorkflowType getWorkflowType() {
        return this.basicWorkflowContext.getWorkflowType();
    }

    @Override
    @Nonnull
    public Duration getWorkflowTaskTimeout() {
        return this.basicWorkflowContext.getWorkflowTaskTimeout();
    }

    @Override
    public String getTaskQueue() {
        return this.basicWorkflowContext.getTaskQueue();
    }

    @Override
    public String getNamespace() {
        return this.basicWorkflowContext.getNamespace();
    }

    @Override
    public String getWorkflowId() {
        return this.basicWorkflowContext.getWorkflowExecution().getWorkflowId();
    }

    @Override
    @Nonnull
    public String getRunId() {
        String result = this.basicWorkflowContext.getWorkflowExecution().getRunId();
        if (result.isEmpty()) {
            return null;
        }
        return result;
    }

    @Override
    public Duration getWorkflowRunTimeout() {
        return this.basicWorkflowContext.getWorkflowRunTimeout();
    }

    @Override
    public Duration getWorkflowExecutionTimeout() {
        return this.basicWorkflowContext.getWorkflowExecutionTimeout();
    }

    @Override
    public long getRunStartedTimestampMillis() {
        return this.basicWorkflowContext.getRunStartedTimestampMillis();
    }

    @Override
    public Payload getMemo(String key) {
        return this.basicWorkflowContext.getMemo(key);
    }

    @Override
    @Nullable
    public SearchAttributes getSearchAttributes() {
        return this.mutableState.getSearchAttributes();
    }

    @Override
    public ReplayWorkflowContext.ScheduleActivityTaskOutput scheduleActivityTask(ExecuteActivityParameters parameters, Functions.Proc2<Optional<Payloads>, Failure> callback) {
        ScheduleActivityTaskCommandAttributes.Builder attributes = parameters.getAttributes();
        if (attributes.getActivityId().isEmpty()) {
            attributes.setActivityId(this.workflowStateMachines.randomUUID().toString());
        }
        Functions.Proc cancellationHandler = this.workflowStateMachines.scheduleActivityTask(parameters, callback);
        return new ReplayWorkflowContext.ScheduleActivityTaskOutput(attributes.getActivityId(), exception -> cancellationHandler.apply());
    }

    @Override
    public Functions.Proc scheduleLocalActivityTask(ExecuteLocalActivityParameters parameters, LocalActivityCallback callback) {
        return this.workflowStateMachines.scheduleLocalActivityTask(parameters, callback);
    }

    @Override
    public Functions.Proc1<Exception> startChildWorkflow(StartChildWorkflowExecutionParameters parameters, Functions.Proc2<WorkflowExecution, Exception> startCallback, Functions.Proc2<Optional<Payloads>, Exception> completionCallback) {
        Functions.Proc cancellationHandler = this.workflowStateMachines.startChildWorkflow(parameters, startCallback, completionCallback);
        return exception -> cancellationHandler.apply();
    }

    @Override
    public Functions.Proc1<Exception> signalExternalWorkflowExecution(SignalExternalWorkflowExecutionCommandAttributes.Builder attributes, Functions.Proc2<Void, Failure> callback) {
        Functions.Proc cancellationHandler = this.workflowStateMachines.signalExternalWorkflowExecution(attributes.build(), callback);
        return e -> cancellationHandler.apply();
    }

    @Override
    public void requestCancelExternalWorkflowExecution(WorkflowExecution execution, Functions.Proc2<Void, RuntimeException> callback) {
        RequestCancelExternalWorkflowExecutionCommandAttributes attributes = RequestCancelExternalWorkflowExecutionCommandAttributes.newBuilder().setWorkflowId(execution.getWorkflowId()).setRunId(execution.getRunId()).build();
        this.workflowStateMachines.requestCancelExternalWorkflowExecution(attributes, callback);
    }

    @Override
    public boolean isReplaying() {
        return this.workflowStateMachines.isReplaying();
    }

    @Override
    public boolean tryUseSdkFlag(SdkFlag flag) {
        return this.workflowStateMachines.tryUseSdkFlag(flag);
    }

    @Override
    public Functions.Proc1<RuntimeException> newTimer(Duration delay, Functions.Proc1<RuntimeException> callback) {
        if (delay.compareTo(Duration.ZERO) <= 0) {
            callback.apply(null);
            return e -> {};
        }
        StartTimerCommandAttributes attributes = StartTimerCommandAttributes.newBuilder().setStartToFireTimeout(ProtobufTimeUtils.toProtoDuration(delay)).setTimerId(this.workflowStateMachines.randomUUID().toString()).build();
        Functions.Proc cancellationHandler = this.workflowStateMachines.newTimer(attributes, (HistoryEvent event) -> this.handleTimerCallback(callback, (HistoryEvent)event));
        return e -> cancellationHandler.apply();
    }

    private void handleTimerCallback(Functions.Proc1<RuntimeException> callback, HistoryEvent event) {
        switch (event.getEventType()) {
            case EVENT_TYPE_TIMER_FIRED: {
                callback.apply(null);
                return;
            }
            case EVENT_TYPE_TIMER_CANCELED: {
                CanceledFailure exception = new CanceledFailure("Canceled by request");
                callback.apply(exception);
                return;
            }
        }
        throw new IllegalArgumentException("Unexpected event type: " + event.getEventType());
    }

    @Override
    public void sideEffect(Functions.Func<Optional<Payloads>> func, Functions.Proc1<Optional<Payloads>> callback) {
        this.workflowStateMachines.sideEffect(func, callback);
    }

    @Override
    public void mutableSideEffect(String id, Functions.Func1<Optional<Payloads>, Optional<Payloads>> func, Functions.Proc1<Optional<Payloads>> callback) {
        this.workflowStateMachines.mutableSideEffect(id, func, callback);
    }

    @Override
    public boolean getVersion(String changeId, int minSupported, int maxSupported, Functions.Proc2<Integer, RuntimeException> callback) {
        return this.workflowStateMachines.getVersion(changeId, minSupported, maxSupported, callback);
    }

    @Override
    public long currentTimeMillis() {
        return this.workflowStateMachines.currentTimeMillis();
    }

    @Override
    public void upsertSearchAttributes(@Nonnull SearchAttributes searchAttributes) {
        this.workflowStateMachines.upsertSearchAttributes(searchAttributes);
        this.mutableState.upsertSearchAttributes(searchAttributes);
    }

    @Override
    public int getAttempt() {
        return this.basicWorkflowContext.getAttempt();
    }

    @Override
    public String getCronSchedule() {
        return this.basicWorkflowContext.getCronSchedule();
    }

    @Override
    @Nullable
    public Payloads getLastCompletionResult() {
        return this.basicWorkflowContext.getLastCompletionResult();
    }

    @Override
    @Nullable
    public Failure getPreviousRunFailure() {
        return this.basicWorkflowContext.getPreviousRunFailure();
    }

    @Override
    @Nullable
    public String getFullReplayDirectQueryName() {
        return this.fullReplayDirectQueryName;
    }

    @Override
    public Map<String, Payload> getHeader() {
        return this.basicWorkflowContext.getHeader();
    }

    @Override
    public long getCurrentWorkflowTaskStartedEventId() {
        return this.workflowStateMachines.getCurrentStartedEventId();
    }

    @Override
    public boolean isCancelRequested() {
        return this.mutableState.isCancelRequested();
    }

    @Override
    public void setCancelRequested() {
        this.mutableState.setCancelRequested();
    }

    @Override
    public boolean isWorkflowMethodCompleted() {
        return this.mutableState.isWorkflowMethodCompleted();
    }

    @Override
    public void setWorkflowMethodCompleted() {
        this.mutableState.setWorkflowMethodCompleted();
    }

    @Override
    public ContinueAsNewWorkflowExecutionCommandAttributes getContinueAsNewOnCompletion() {
        return this.mutableState.getContinueAsNewOnCompletion();
    }

    @Override
    public void continueAsNewOnCompletion(ContinueAsNewWorkflowExecutionCommandAttributes attributes) {
        this.mutableState.continueAsNewOnCompletion(attributes);
    }

    @Override
    public Throwable getWorkflowTaskFailure() {
        return this.mutableState.getWorkflowTaskFailure();
    }

    @Override
    public void failWorkflowTask(Throwable failure) {
        this.mutableState.failWorkflowTask(failure);
    }
}

