/*
 * Decompiled with CFR 0.152.
 */
package io.temporal.internal.async;

import io.temporal.internal.async.spi.MethodReferenceDisassemblyService;
import io.temporal.internal.common.JavaLambdaUtils;
import io.temporal.internal.common.kotlin.KotlinDetector;
import io.temporal.internal.sync.AsyncInternal;
import io.temporal.workflow.ActivityStub;
import io.temporal.workflow.ChildWorkflowStub;
import io.temporal.workflow.ExternalWorkflowStub;
import java.lang.invoke.SerializedLambda;
import java.util.HashMap;
import java.util.Map;
import java.util.ServiceLoader;

public class MethodReferenceDisassembler {
    private static final ServiceLoader<MethodReferenceDisassemblyService> loader = ServiceLoader.load(MethodReferenceDisassemblyService.class);
    static final Map<String, MethodReferenceDisassemblyService> services = new HashMap<String, MethodReferenceDisassemblyService>();

    public static boolean isAsync(Object func) {
        return MethodReferenceDisassembler.isAsyncJava(func) || MethodReferenceDisassembler.isAsyncKotlin(func);
    }

    private static boolean isAsyncJava(Object func) {
        SerializedLambda lambda = JavaLambdaUtils.toSerializedLambda(func);
        Object target = JavaLambdaUtils.getTarget(lambda);
        return target instanceof ActivityStub || target instanceof ChildWorkflowStub || target instanceof ExternalWorkflowStub || target instanceof AsyncInternal.AsyncMarker && lambda.getImplMethodKind() == 9;
    }

    private static boolean isAsyncKotlin(Object func) {
        if (KotlinDetector.isKotlinType(func.getClass())) {
            MethodReferenceDisassemblyService methodReferenceDisassemblyService = services.get("kotlin");
            if (methodReferenceDisassemblyService == null) {
                throw new IllegalStateException("Kotlin method reference is used with async. For Temporal to correctly support async invocation kotlin method references, add io.temporal:temporal-kotlin to classpath");
            }
            Object target = methodReferenceDisassemblyService.getMethodReferenceTarget(func);
            return target instanceof AsyncInternal.AsyncMarker || target instanceof ActivityStub || target instanceof ChildWorkflowStub || target instanceof ExternalWorkflowStub;
        }
        return false;
    }

    static {
        loader.iterator().forEachRemaining(service -> services.put(service.getLanguageName(), (MethodReferenceDisassemblyService)service));
    }
}

