/*
 * Decompiled with CFR 0.152.
 */
package io.temporal.common.converter;

import com.google.protobuf.ByteString;
import com.google.protobuf.MessageOrBuilder;
import io.temporal.api.common.v1.Payload;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractProtobufPayloadConverter {
    protected static final Logger log = LoggerFactory.getLogger(AbstractProtobufPayloadConverter.class);
    private final boolean excludeProtobufMessageTypes;

    protected AbstractProtobufPayloadConverter() {
        this.excludeProtobufMessageTypes = false;
    }

    protected AbstractProtobufPayloadConverter(boolean excludeProtobufMessageTypes) {
        this.excludeProtobufMessageTypes = excludeProtobufMessageTypes;
    }

    protected void addMessageType(Payload.Builder builder, Object value) {
        if (this.excludeProtobufMessageTypes) {
            return;
        }
        String messageTypeName = ((MessageOrBuilder)value).getDescriptorForType().getFullName();
        builder.putMetadata("messageType", ByteString.copyFrom((String)messageTypeName, (Charset)StandardCharsets.UTF_8));
    }

    protected void checkMessageType(Payload payload, Object instance) {
        String instanceType;
        String messageType;
        if (!log.isWarnEnabled()) {
            return;
        }
        ByteString messageTypeBytes = (ByteString)payload.getMetadataMap().get("messageType");
        if (messageTypeBytes != null && !(messageType = messageTypeBytes.toString(StandardCharsets.UTF_8)).equals(instanceType = ((MessageOrBuilder)instance).getDescriptorForType().getFullName())) {
            log.warn("Encoded protobuf message type \"" + messageType + "\" does not match value type \"" + instanceType + '\"');
        }
    }
}

