/*
 * Decompiled with CFR 0.152.
 */
package io.temporal.opentracing.internal;

import com.google.common.base.MoreObjects;
import io.opentracing.Scope;
import io.opentracing.Span;
import io.opentracing.Tracer;
import io.temporal.common.interceptors.WorkflowOutboundCallsInterceptor;
import io.temporal.common.interceptors.WorkflowOutboundCallsInterceptorBase;
import io.temporal.opentracing.OpenTracingOptions;
import io.temporal.opentracing.internal.ContextAccessor;
import io.temporal.opentracing.internal.SpanFactory;
import io.temporal.workflow.Workflow;
import io.temporal.workflow.WorkflowInfo;
import io.temporal.workflow.unsafe.WorkflowUnsafe;
import java.util.Map;

public class OpenTracingWorkflowOutboundCallsInterceptor
extends WorkflowOutboundCallsInterceptorBase {
    private final SpanFactory spanFactory;
    private final Tracer tracer;
    private final ContextAccessor contextAccessor;

    public OpenTracingWorkflowOutboundCallsInterceptor(WorkflowOutboundCallsInterceptor next, OpenTracingOptions options, SpanFactory spanFactory, ContextAccessor contextAccessor) {
        super(next);
        this.spanFactory = spanFactory;
        this.tracer = options.getTracer();
        this.contextAccessor = contextAccessor;
    }

    public <R> WorkflowOutboundCallsInterceptor.ActivityOutput<R> executeActivity(WorkflowOutboundCallsInterceptor.ActivityInput<R> input) {
        if (!WorkflowUnsafe.isReplaying()) {
            Span activityStartSpan = this.contextAccessor.writeSpanContextToHeader(() -> this.createActivityStartSpanBuilder(input.getActivityName()).start(), input.getHeader(), this.tracer);
            try {
                WorkflowOutboundCallsInterceptor.ActivityOutput activityOutput;
                block10: {
                    Scope ignored = this.tracer.scopeManager().activate(activityStartSpan);
                    try {
                        activityOutput = super.executeActivity(input);
                        if (ignored == null) break block10;
                    }
                    catch (Throwable throwable) {
                        if (ignored != null) {
                            try {
                                ignored.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                        }
                        throw throwable;
                    }
                    ignored.close();
                }
                return activityOutput;
            }
            finally {
                activityStartSpan.finish();
            }
        }
        return super.executeActivity(input);
    }

    public <R> WorkflowOutboundCallsInterceptor.LocalActivityOutput<R> executeLocalActivity(WorkflowOutboundCallsInterceptor.LocalActivityInput<R> input) {
        if (!WorkflowUnsafe.isReplaying()) {
            Span activityStartSpan = this.contextAccessor.writeSpanContextToHeader(() -> this.createActivityStartSpanBuilder(input.getActivityName()).start(), input.getHeader(), this.tracer);
            try {
                WorkflowOutboundCallsInterceptor.LocalActivityOutput localActivityOutput;
                block10: {
                    Scope ignored = this.tracer.scopeManager().activate(activityStartSpan);
                    try {
                        localActivityOutput = super.executeLocalActivity(input);
                        if (ignored == null) break block10;
                    }
                    catch (Throwable throwable) {
                        if (ignored != null) {
                            try {
                                ignored.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                        }
                        throw throwable;
                    }
                    ignored.close();
                }
                return localActivityOutput;
            }
            finally {
                activityStartSpan.finish();
            }
        }
        return super.executeLocalActivity(input);
    }

    public <R> WorkflowOutboundCallsInterceptor.ChildWorkflowOutput<R> executeChildWorkflow(WorkflowOutboundCallsInterceptor.ChildWorkflowInput<R> input) {
        if (!WorkflowUnsafe.isReplaying()) {
            Span childWorkflowStartSpan = this.contextAccessor.writeSpanContextToHeader(() -> this.createChildWorkflowStartSpanBuilder(input).start(), input.getHeader(), this.tracer);
            try {
                WorkflowOutboundCallsInterceptor.ChildWorkflowOutput childWorkflowOutput;
                block10: {
                    Scope ignored = this.tracer.scopeManager().activate(childWorkflowStartSpan);
                    try {
                        childWorkflowOutput = super.executeChildWorkflow(input);
                        if (ignored == null) break block10;
                    }
                    catch (Throwable throwable) {
                        if (ignored != null) {
                            try {
                                ignored.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                        }
                        throw throwable;
                    }
                    ignored.close();
                }
                return childWorkflowOutput;
            }
            finally {
                childWorkflowStartSpan.finish();
            }
        }
        return super.executeChildWorkflow(input);
    }

    public <R> WorkflowOutboundCallsInterceptor.ExecuteNexusOperationOutput<R> executeNexusOperation(WorkflowOutboundCallsInterceptor.ExecuteNexusOperationInput<R> input) {
        if (!WorkflowUnsafe.isReplaying()) {
            Span nexusOperationExecuteSpan = this.contextAccessor.writeSpanContextToHeader(() -> this.createStartNexusOperationSpanBuilder(input).start(), (Map<String, String>)input.getHeaders(), this.tracer);
            try {
                WorkflowOutboundCallsInterceptor.ExecuteNexusOperationOutput executeNexusOperationOutput;
                block10: {
                    Scope ignored = this.tracer.scopeManager().activate(nexusOperationExecuteSpan);
                    try {
                        executeNexusOperationOutput = super.executeNexusOperation(input);
                        if (ignored == null) break block10;
                    }
                    catch (Throwable throwable) {
                        if (ignored != null) {
                            try {
                                ignored.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                        }
                        throw throwable;
                    }
                    ignored.close();
                }
                return executeNexusOperationOutput;
            }
            finally {
                nexusOperationExecuteSpan.finish();
            }
        }
        return super.executeNexusOperation(input);
    }

    public WorkflowOutboundCallsInterceptor.SignalExternalOutput signalExternalWorkflow(WorkflowOutboundCallsInterceptor.SignalExternalInput input) {
        if (!WorkflowUnsafe.isReplaying()) {
            WorkflowInfo workflowInfo = Workflow.getInfo();
            Span childWorkflowStartSpan = this.contextAccessor.writeSpanContextToHeader(() -> this.spanFactory.createExternalWorkflowSignalSpan(this.tracer, input.getSignalName(), workflowInfo.getWorkflowId(), workflowInfo.getRunId()).start(), input.getHeader(), this.tracer);
            try {
                WorkflowOutboundCallsInterceptor.SignalExternalOutput signalExternalOutput;
                block10: {
                    Scope ignored = this.tracer.scopeManager().activate(childWorkflowStartSpan);
                    try {
                        signalExternalOutput = super.signalExternalWorkflow(input);
                        if (ignored == null) break block10;
                    }
                    catch (Throwable throwable) {
                        if (ignored != null) {
                            try {
                                ignored.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                        }
                        throw throwable;
                    }
                    ignored.close();
                }
                return signalExternalOutput;
            }
            finally {
                childWorkflowStartSpan.finish();
            }
        }
        return super.signalExternalWorkflow(input);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void continueAsNew(WorkflowOutboundCallsInterceptor.ContinueAsNewInput input) {
        block10: {
            if (!WorkflowUnsafe.isReplaying()) {
                Span continueAsNewStartSpan = this.contextAccessor.writeSpanContextToHeader(() -> this.createContinueAsNewWorkflowStartSpanBuilder(input).start(), input.getHeader(), this.tracer);
                try (Scope ignored = this.tracer.scopeManager().activate(continueAsNewStartSpan);){
                    super.continueAsNew(input);
                    break block10;
                }
                finally {
                    continueAsNewStartSpan.finish();
                }
            }
            super.continueAsNew(input);
        }
    }

    public Object newChildThread(Runnable runnable, boolean detached, String name) {
        Span activeSpan = this.tracer.scopeManager().activeSpan();
        Runnable wrappedRunnable = activeSpan != null ? () -> {
            try (Scope ignored = this.tracer.scopeManager().activate(activeSpan);){
                runnable.run();
            }
        } : runnable;
        return super.newChildThread(wrappedRunnable, detached, name);
    }

    private Tracer.SpanBuilder createActivityStartSpanBuilder(String activityName) {
        WorkflowInfo workflowInfo = Workflow.getInfo();
        return this.spanFactory.createActivityStartSpan(this.tracer, activityName, workflowInfo.getWorkflowId(), workflowInfo.getRunId());
    }

    private <R> Tracer.SpanBuilder createChildWorkflowStartSpanBuilder(WorkflowOutboundCallsInterceptor.ChildWorkflowInput<R> input) {
        WorkflowInfo parentWorkflowInfo = Workflow.getInfo();
        return this.spanFactory.createChildWorkflowStartSpan(this.tracer, input.getWorkflowType(), input.getWorkflowId(), Workflow.currentTimeMillis(), parentWorkflowInfo.getWorkflowId(), parentWorkflowInfo.getRunId());
    }

    private <R> Tracer.SpanBuilder createStartNexusOperationSpanBuilder(WorkflowOutboundCallsInterceptor.ExecuteNexusOperationInput<R> input) {
        WorkflowInfo parentWorkflowInfo = Workflow.getInfo();
        return this.spanFactory.createStartNexusOperationSpan(this.tracer, input.getService(), input.getOperation(), parentWorkflowInfo.getWorkflowId(), parentWorkflowInfo.getRunId());
    }

    private Tracer.SpanBuilder createContinueAsNewWorkflowStartSpanBuilder(WorkflowOutboundCallsInterceptor.ContinueAsNewInput input) {
        WorkflowInfo continuedWorkflowInfo = Workflow.getInfo();
        return this.spanFactory.createContinueAsNewWorkflowStartSpan(this.tracer, (String)MoreObjects.firstNonNull((Object)input.getWorkflowType(), (Object)continuedWorkflowInfo.getWorkflowType()), continuedWorkflowInfo.getWorkflowId(), continuedWorkflowInfo.getRunId());
    }
}

