/*
 * Decompiled with CFR 0.152.
 */
package io.tesla.proviso.archive.zip;

import io.tesla.proviso.archive.ArchiveHandlerSupport;
import io.tesla.proviso.archive.ExtendedArchiveEntry;
import io.tesla.proviso.archive.Source;
import io.tesla.proviso.archive.zip.ExtendedZipArchiveEntry;
import io.tesla.proviso.archive.zip.ZipArchiveSource;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.apache.commons.compress.archivers.ArchiveInputStream;
import org.apache.commons.compress.archivers.ArchiveOutputStream;
import org.apache.commons.compress.archivers.zip.ZipArchiveInputStream;
import org.apache.commons.compress.archivers.zip.ZipArchiveOutputStream;

public class ZipArchiveHandler
extends ArchiveHandlerSupport {
    private final File archive;

    public ZipArchiveHandler(File archive) {
        this.archive = archive;
    }

    @Override
    public ExtendedArchiveEntry newEntry(String entryName) {
        return new ExtendedZipArchiveEntry(entryName);
    }

    @Override
    public ArchiveInputStream getInputStream() throws IOException {
        return new ZipArchiveInputStream((InputStream)new FileInputStream(this.archive));
    }

    @Override
    public ArchiveOutputStream getOutputStream() throws IOException {
        return new ZipArchiveOutputStream((OutputStream)new FileOutputStream(this.archive));
    }

    @Override
    public Source getArchiveSource() {
        return new ZipArchiveSource(this.archive);
    }
}

