/*
 * Decompiled with CFR 0.152.
 */
package io.tesla.proviso.archive.source;

import com.google.common.collect.Iterators;
import com.google.common.collect.Lists;
import io.tesla.proviso.archive.Entry;
import io.tesla.proviso.archive.Source;
import io.tesla.proviso.archive.source.FileEntry;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.codehaus.plexus.util.DirectoryScanner;

public class DirectorySource
implements Source {
    private final File[] sourceDirectories;

    public DirectorySource(File ... sourceDirectories) {
        this.sourceDirectories = sourceDirectories;
    }

    public DirectorySource(List<String> sourceDirectories) {
        this.sourceDirectories = new File[sourceDirectories.size()];
        for (int i = 0; i < sourceDirectories.size(); ++i) {
            this.sourceDirectories[i] = new File(sourceDirectories.get(i));
        }
    }

    @Override
    public Iterable<Entry> entries() {
        return new Iterable<Entry>(){

            @Override
            public Iterator<Entry> iterator() {
                Iterator[] iterators = new DirectoryEntryIterator[DirectorySource.this.sourceDirectories.length];
                for (int i = 0; i < iterators.length; ++i) {
                    iterators[i] = new DirectoryEntryIterator(DirectorySource.this.sourceDirectories[i]);
                }
                return Iterators.concat((Iterator[])iterators);
            }
        };
    }

    @Override
    public void close() throws IOException {
    }

    @Override
    public boolean isDirectory() {
        return true;
    }

    class DirectoryEntryIterator
    implements Iterator<Entry> {
        final String[] files;
        final File sourceDirectory;
        int currentFileIndex;

        DirectoryEntryIterator(File sourceDirectory) {
            String[] includedFiles;
            DirectoryScanner scanner = new DirectoryScanner();
            scanner.setBasedir(sourceDirectory);
            scanner.setCaseSensitive(true);
            scanner.scan();
            ArrayList entries = Lists.newArrayList();
            for (String includedFile : includedFiles = scanner.getIncludedFiles()) {
                if (includedFile.isEmpty()) continue;
                entries.add(includedFile);
            }
            this.files = entries.toArray(new String[entries.size()]);
            this.sourceDirectory = sourceDirectory;
        }

        @Override
        public boolean hasNext() {
            return this.currentFileIndex != this.files.length;
        }

        @Override
        public Entry next() {
            String pathRelativeToSourceDirectory = this.files[this.currentFileIndex++];
            File file = new File(this.sourceDirectory, pathRelativeToSourceDirectory);
            String archiveEntryName = String.format("%s/%s", this.sourceDirectory.getName(), pathRelativeToSourceDirectory);
            return new FileEntry(archiveEntryName, file);
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException("remove method not implemented");
        }
    }
}

