/*
 * Decompiled with CFR 0.152.
 */
package io.swagger.inflector.examples;

import io.swagger.inflector.examples.models.ArrayExample;
import io.swagger.inflector.examples.models.BooleanExample;
import io.swagger.inflector.examples.models.DecimalExample;
import io.swagger.inflector.examples.models.DoubleExample;
import io.swagger.inflector.examples.models.Example;
import io.swagger.inflector.examples.models.FloatExample;
import io.swagger.inflector.examples.models.IntegerExample;
import io.swagger.inflector.examples.models.LongExample;
import io.swagger.inflector.examples.models.ObjectExample;
import io.swagger.inflector.examples.models.StringExample;
import io.swagger.models.ArrayModel;
import io.swagger.models.ComposedModel;
import io.swagger.models.Model;
import io.swagger.models.ModelImpl;
import io.swagger.models.Xml;
import io.swagger.models.properties.ArrayProperty;
import io.swagger.models.properties.BaseIntegerProperty;
import io.swagger.models.properties.BooleanProperty;
import io.swagger.models.properties.DateProperty;
import io.swagger.models.properties.DateTimeProperty;
import io.swagger.models.properties.DecimalProperty;
import io.swagger.models.properties.DoubleProperty;
import io.swagger.models.properties.EmailProperty;
import io.swagger.models.properties.FloatProperty;
import io.swagger.models.properties.IntegerProperty;
import io.swagger.models.properties.LongProperty;
import io.swagger.models.properties.MapProperty;
import io.swagger.models.properties.ObjectProperty;
import io.swagger.models.properties.Property;
import io.swagger.models.properties.RefProperty;
import io.swagger.models.properties.StringProperty;
import io.swagger.models.properties.UUIDProperty;
import io.swagger.util.Json;
import java.io.IOException;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ExampleBuilder {
    private static final Logger LOGGER = LoggerFactory.getLogger(ExampleBuilder.class);
    public static final String SAMPLE_EMAIL_PROPERTY_VALUE = "apiteam@swagger.io";
    public static final String SAMPLE_UUID_PROPERTY_VALUE = "3fa85f64-5717-4562-b3fc-2c963f66afa6";
    public static final String SAMPLE_STRING_PROPERTY_VALUE = "string";
    public static final int SAMPLE_INT_PROPERTY_VALUE = 0;
    public static final int SAMPLE_LONG_PROPERTY_VALUE = 0;
    public static final int SAMPLE_BASE_INTEGER_PROPERTY_VALUE = 0;
    public static final float SAMPLE_FLOAT_PROPERTY_VALUE = 1.1f;
    public static final double SAMPLE_DOUBLE_PROPERTY_VALUE = (double)1.1f;
    public static final boolean SAMPLE_BOOLEAN_PROPERTY_VALUE = true;
    public static final String SAMPLE_DATE_PROPERTY_VALUE = "2015-07-20";
    public static final String SAMPLE_DATETIME_PROPERTY_VALUE = "2015-07-20T15:49:04-07:00";
    public static final double SAMPLE_DECIMAL_PROPERTY_VALUE = 1.5;

    public static Example fromProperty(Property property, Map<String, Model> definitions) {
        return ExampleBuilder.fromProperty(property, definitions, new HashSet<String>());
    }

    public static Example fromProperty(Property property, Map<String, Model> definitions, Set<String> processedModels) {
        MapProperty mp;
        Example innerExample;
        Property inner;
        List enums;
        List enums2;
        Object defaultValue;
        Model model;
        RefProperty ref;
        if (property == null) {
            return null;
        }
        String name = null;
        String namespace = null;
        String prefix = null;
        Boolean attribute = false;
        Boolean wrapped = false;
        if (property.getXml() != null) {
            Xml xml = property.getXml();
            name = xml.getName();
            namespace = xml.getNamespace();
            prefix = xml.getPrefix();
            attribute = xml.getAttribute();
            wrapped = xml.getWrapped() != null ? xml.getWrapped() : false;
        }
        Example output = null;
        Object example = property.getExample();
        if (property instanceof RefProperty) {
            ref = (RefProperty)property;
            if (processedModels.contains(ref.getSimpleRef())) {
                return ExampleBuilder.alreadyProcessedRefExample(ref.getSimpleRef(), definitions);
            }
            processedModels.add(ref.getSimpleRef());
            if (definitions != null && (model = definitions.get(ref.getSimpleRef())) != null) {
                output = ExampleBuilder.fromModel(ref.getSimpleRef(), model, definitions, processedModels);
            }
        } else if (property instanceof EmailProperty) {
            if (example != null) {
                output = new StringExample(example.toString());
            } else {
                defaultValue = ((EmailProperty)property).getDefault();
                if (defaultValue == null && (enums2 = ((EmailProperty)property).getEnum()) != null && !enums2.isEmpty()) {
                    defaultValue = (String)enums2.get(0);
                }
                output = new StringExample((String)(defaultValue == null ? SAMPLE_EMAIL_PROPERTY_VALUE : defaultValue));
            }
        } else if (property instanceof UUIDProperty) {
            if (example != null) {
                output = new StringExample(example.toString());
            } else {
                defaultValue = ((UUIDProperty)property).getDefault();
                if (defaultValue == null && (enums2 = ((UUIDProperty)property).getEnum()) != null && !enums2.isEmpty()) {
                    defaultValue = (String)enums2.get(0);
                }
                output = new StringExample((String)(defaultValue == null ? SAMPLE_UUID_PROPERTY_VALUE : defaultValue));
            }
        } else if (property instanceof StringProperty) {
            if (example != null) {
                output = new StringExample(example.toString());
            } else {
                defaultValue = ((StringProperty)property).getDefault();
                if (defaultValue == null && (enums2 = ((StringProperty)property).getEnum()) != null && !enums2.isEmpty()) {
                    defaultValue = (String)enums2.get(0);
                }
                output = new StringExample((String)(defaultValue == null ? SAMPLE_STRING_PROPERTY_VALUE : defaultValue));
            }
        } else if (property instanceof IntegerProperty) {
            if (example != null) {
                try {
                    output = new IntegerExample(Integer.parseInt(example.toString()));
                }
                catch (NumberFormatException e) {
                    // empty catch block
                }
            }
            if (output == null) {
                defaultValue = ((IntegerProperty)property).getDefault();
                if (defaultValue == null && (enums2 = ((IntegerProperty)property).getEnum()) != null && !enums2.isEmpty()) {
                    defaultValue = (Integer)enums2.get(0);
                }
                output = new IntegerExample(defaultValue == null ? 0 : (Integer)defaultValue);
            }
        } else if (property instanceof LongProperty) {
            if (example != null) {
                try {
                    output = new LongExample(Long.parseLong(example.toString()));
                }
                catch (NumberFormatException e) {
                    // empty catch block
                }
            }
            if (output == null) {
                defaultValue = ((LongProperty)property).getDefault();
                if (defaultValue == null && (enums2 = ((LongProperty)property).getEnum()) != null && !enums2.isEmpty()) {
                    defaultValue = (Long)enums2.get(0);
                }
                output = new LongExample(defaultValue == null ? 0L : (Long)defaultValue);
            }
        } else if (property instanceof BaseIntegerProperty) {
            if (example != null) {
                try {
                    output = new IntegerExample(Integer.parseInt(example.toString()));
                }
                catch (NumberFormatException e) {
                    // empty catch block
                }
            }
            if (output == null) {
                output = new IntegerExample(0);
            }
        } else if (property instanceof FloatProperty) {
            if (example != null) {
                try {
                    output = new FloatExample(Float.parseFloat(example.toString()));
                }
                catch (NumberFormatException e) {
                    // empty catch block
                }
            }
            if (output == null) {
                defaultValue = ((FloatProperty)property).getDefault();
                if (defaultValue == null && (enums2 = ((FloatProperty)property).getEnum()) != null && !enums2.isEmpty()) {
                    defaultValue = (Float)enums2.get(0);
                }
                output = new FloatExample(defaultValue == null ? 1.1f : ((Float)defaultValue).floatValue());
            }
        } else if (property instanceof DoubleProperty) {
            if (example != null) {
                try {
                    output = new DoubleExample(Double.parseDouble(example.toString()));
                }
                catch (NumberFormatException e) {
                    // empty catch block
                }
            }
            if (output == null) {
                defaultValue = ((DoubleProperty)property).getDefault();
                if (defaultValue == null && (enums2 = ((DoubleProperty)property).getEnum()) != null && !enums2.isEmpty()) {
                    defaultValue = (Double)enums2.get(0);
                }
                output = new DoubleExample(defaultValue == null ? (double)1.1f : (Double)defaultValue);
            }
        } else if (property instanceof BooleanProperty) {
            output = example != null ? new BooleanExample(Boolean.valueOf(example.toString())) : new BooleanExample((defaultValue = ((BooleanProperty)property).getDefault()) == null ? true : (Boolean)defaultValue);
        } else if (property instanceof DateProperty) {
            output = example != null ? new StringExample(example.toString()) : ((enums = ((DateProperty)property).getEnum()) != null && !enums.isEmpty() ? new StringExample((String)enums.get(0)) : new StringExample(SAMPLE_DATE_PROPERTY_VALUE));
        } else if (property instanceof DateTimeProperty) {
            output = example != null ? new StringExample(example.toString()) : ((enums = ((DateTimeProperty)property).getEnum()) != null && !enums.isEmpty() ? new StringExample((String)enums.get(0)) : new StringExample(SAMPLE_DATETIME_PROPERTY_VALUE));
        } else if (property instanceof DecimalProperty) {
            if (example != null) {
                try {
                    output = new DecimalExample(new BigDecimal(example.toString()));
                }
                catch (NumberFormatException e) {
                    // empty catch block
                }
            }
            if (output == null) {
                output = new DecimalExample(new BigDecimal(1.5));
            }
        } else if (property instanceof ObjectProperty) {
            if (example != null) {
                try {
                    output = (Example)Json.mapper().readValue(example.toString(), ObjectExample.class);
                }
                catch (IOException e) {
                    LOGGER.error("unable to convert `" + example + "` to JsonNode");
                    output = new ObjectExample();
                }
            } else {
                ObjectExample outputExample = new ObjectExample();
                outputExample.setName(property.getName());
                ObjectProperty op = (ObjectProperty)property;
                if (op.getProperties() != null) {
                    for (String propertyname : op.getProperties().keySet()) {
                        Property inner2 = (Property)op.getProperties().get(propertyname);
                        Example innerExample2 = ExampleBuilder.fromProperty(inner2, definitions);
                        outputExample.put(propertyname, innerExample2);
                    }
                }
                output = outputExample;
            }
        } else if (property instanceof ArrayProperty) {
            if (example != null) {
                output = new ArrayExample();
            } else {
                ArrayProperty ap = (ArrayProperty)property;
                inner = ap.getItems();
                if (inner != null && (innerExample = ExampleBuilder.fromProperty(inner, definitions, processedModels)) != null && innerExample instanceof Example) {
                    ArrayExample an = new ArrayExample();
                    an.add(innerExample);
                    an.setName(property.getName());
                    output = an;
                }
            }
        } else if (property instanceof MapProperty && (inner = (mp = (MapProperty)property).getAdditionalProperties()) != null && (innerExample = ExampleBuilder.fromProperty(inner, definitions, processedModels)) != null) {
            ObjectExample on = new ObjectExample();
            if (innerExample instanceof Example) {
                StringExample key = new StringExample("key");
                key.setName("key");
                on.put("key", key);
                Example in = innerExample;
                if (in.getName() == null) {
                    in.setName("value");
                }
                on.put("value", in);
                output = on;
            } else {
                ObjectExample outputMap = new ObjectExample();
                outputMap.put("key", new ObjectExample());
                output = outputMap;
            }
        }
        if (property instanceof RefProperty && output == null && definitions != null) {
            ref = (RefProperty)property;
            model = definitions.get(ref.getSimpleRef());
            if (model != null) {
                ModelImpl i;
                if (model instanceof ModelImpl && (i = (ModelImpl)model).getXml() != null) {
                    Xml xml = i.getXml();
                    name = xml.getName();
                    attribute = xml.getAttribute();
                    namespace = xml.getNamespace();
                    prefix = xml.getPrefix();
                    wrapped = xml.getWrapped();
                }
                if (model.getExample() != null) {
                    try {
                        Example n = (Example)Json.mapper().readValue(model.getExample().toString(), Example.class);
                        output = n;
                    }
                    catch (IOException e) {
                        LOGGER.error("unable to convert value", (Throwable)e);
                    }
                } else {
                    ObjectExample values = new ObjectExample();
                    Map properties = model.getProperties();
                    if (properties != null) {
                        for (String key : properties.keySet()) {
                            Property innerProp = (Property)properties.get(key);
                            Example p = ExampleBuilder.fromProperty(innerProp, definitions, processedModels);
                            if (p == null) continue;
                            if (p.getName() == null) {
                                p.setName(key);
                            }
                            values.put(key, p);
                            processedModels.add(key);
                        }
                    }
                    output = values;
                }
            }
            if (output != null) {
                output.setName(ref.getSimpleRef());
            }
        }
        if (output != null) {
            if (attribute != null) {
                output.setAttribute(attribute);
            }
            if (wrapped != null && wrapped.booleanValue()) {
                if (name != null) {
                    output.setWrappedName(name);
                }
            } else if (name != null) {
                output.setName(name);
            }
            output.setNamespace(namespace);
            output.setPrefix(prefix);
            output.setWrapped(wrapped);
        }
        return output;
    }

    public static Example alreadyProcessedRefExample(String name, Map<String, Model> definitions) {
        ModelImpl impl;
        Model model = definitions.get(name);
        if (model == null) {
            return null;
        }
        Example output = null;
        if (model instanceof ModelImpl && (impl = (ModelImpl)model).getType() != null) {
            if ("object".equals(impl.getType())) {
                return new ObjectExample();
            }
            if (SAMPLE_STRING_PROPERTY_VALUE.equals(impl.getType())) {
                return new StringExample("");
            }
            if ("integer".equals(impl.getType())) {
                return new IntegerExample(0);
            }
            if ("long".equals(impl.getType())) {
                return new LongExample(0L);
            }
            if ("float".equals(impl.getType())) {
                return new FloatExample(0.0f);
            }
            if ("double".equals(impl.getType())) {
                return new DoubleExample(0.0);
            }
        }
        return output;
    }

    public static Example fromModel(String name, Model model, Map<String, Model> definitions, Set<String> processedModels) {
        String namespace = null;
        String prefix = null;
        Boolean attribute = false;
        Boolean wrapped = false;
        Example output = null;
        if (model.getExample() != null) {
            try {
                String str = model.getExample().toString();
                output = (Example)Json.mapper().readValue(str, ObjectExample.class);
            }
            catch (IOException e) {
                return null;
            }
        } else if (model instanceof ModelImpl) {
            ModelImpl impl = (ModelImpl)model;
            if (impl.getXml() != null) {
                Xml xml = impl.getXml();
                name = xml.getName();
                namespace = xml.getNamespace();
                prefix = xml.getPrefix();
                attribute = xml.getAttribute();
                wrapped = xml.getWrapped() != null ? xml.getWrapped() : false;
            }
            ObjectExample ex = new ObjectExample();
            if (impl.getProperties() != null) {
                for (String key : impl.getProperties().keySet()) {
                    Property property = (Property)impl.getProperties().get(key);
                    Example propExample = ExampleBuilder.fromProperty(property, definitions, processedModels);
                    ex.put(key, propExample);
                }
            }
            output = ex;
        } else if (model instanceof ComposedModel) {
            ComposedModel cm = (ComposedModel)model;
            List models = cm.getAllOf();
            ObjectExample ex = new ObjectExample();
            ArrayList<Example> innerExamples = new ArrayList<Example>();
            if (models != null) {
                for (Model im : models) {
                    Example innerExample = ExampleBuilder.fromModel(null, im, definitions, processedModels);
                    if (innerExample == null) continue;
                    innerExamples.add(innerExample);
                }
            }
            ExampleBuilder.mergeTo(ex, innerExamples);
            output = ex;
        } else if (model instanceof ArrayModel) {
            Example innerExample;
            ArrayModel am = (ArrayModel)model;
            ObjectExample ex = new ObjectExample();
            Property inner = am.getItems();
            if (inner != null && (innerExample = ExampleBuilder.fromProperty(inner, definitions, processedModels)) != null) {
                ArrayExample an = new ArrayExample();
                an.add(innerExample);
                output = an;
            }
        }
        if (output != null) {
            if (attribute != null) {
                output.setAttribute(attribute);
            }
            if (wrapped != null && wrapped.booleanValue()) {
                if (name != null) {
                    output.setWrappedName(name);
                }
            } else if (name != null) {
                output.setName(name);
            }
            output.setNamespace(namespace);
            output.setPrefix(prefix);
            output.setWrapped(wrapped);
        }
        return output;
    }

    public static void mergeTo(ObjectExample output, List<Example> examples) {
        for (Example ex : examples) {
            ObjectExample objectExample;
            Map<String, Example> values;
            if (!(ex instanceof ObjectExample) || (values = (objectExample = (ObjectExample)ex).getValues()) == null) continue;
            output.putAll(values);
        }
    }
}

