/*
 * Decompiled with CFR 0.152.
 */
package io.sundr.adapter.api;

import io.sundr.model.Method;
import io.sundr.model.Property;
import io.sundr.model.TypeDef;
import io.sundr.model.TypeRef;
import java.util.function.Function;

public interface Adapter<T, R, P, M> {
    public Function<T, TypeDef> getTypeAdapterFunction();

    public Function<R, TypeRef> getReferenceAdapterFunction();

    public Function<M, Method> getMethodAdapterFunction();

    public Function<P, Property> getPropertyAdapterFunction();

    default public TypeDef adaptType(T input) {
        return this.getTypeAdapterFunction().apply(input);
    }

    default public Method adaptMethod(M method) {
        return this.getMethodAdapterFunction().apply(method);
    }

    default public Property adaptProperty(P property) {
        return this.getPropertyAdapterFunction().apply(property);
    }

    default public TypeRef adaptReference(R ref) {
        return this.getReferenceAdapterFunction().apply(ref);
    }
}

