/*
 * Decompiled with CFR 0.152.
 */
package cn.smallbun.screw.core.util;

import cn.smallbun.screw.core.exception.ScrewException;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.serializer.SerializerFeature;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.util.ArrayList;

public class ResultSetUtils {
    public static void printResultSet(ResultSet rs) throws SQLException {
        ResultSetMetaData resultSetMetaData = rs.getMetaData();
        int columnCount = resultSetMetaData.getColumnCount();
        int[] columnMaxLengths = new int[columnCount];
        ArrayList<String[]> results = new ArrayList<String[]>();
        while (rs.next()) {
            String[] columnStr = new String[columnCount];
            for (int i = 0; i < columnCount; ++i) {
                columnStr[i] = rs.getString(i + 1);
                columnMaxLengths[i] = Math.max(columnMaxLengths[i], columnStr[i] == null ? 0 : columnStr[i].length());
                String columnName = resultSetMetaData.getColumnName(i + 1);
                columnMaxLengths[i] = Math.max(columnMaxLengths[i], columnName.length());
            }
            results.add(columnStr);
        }
        ResultSetUtils.printSeparator(columnMaxLengths);
        ResultSetUtils.printColumnName(resultSetMetaData, columnMaxLengths);
        ResultSetUtils.printSeparator(columnMaxLengths);
        for (String[] columnStr : results) {
            for (int i = 0; i < columnCount; ++i) {
                System.out.printf("|%" + columnMaxLengths[i] + "s", columnStr[i]);
            }
            System.out.println("|");
        }
        ResultSetUtils.printSeparator(columnMaxLengths);
    }

    private static void printColumnName(ResultSetMetaData resultSetMetaData, int[] columnMaxLengths) throws SQLException {
        int columnCount = resultSetMetaData.getColumnCount();
        for (int i = 0; i < columnCount; ++i) {
            System.out.printf("|%" + columnMaxLengths[i] + "s", resultSetMetaData.getColumnName(i + 1));
        }
        System.out.println("|");
    }

    private static void printSeparator(int[] columnMaxLengths) {
        for (int columnMaxLength : columnMaxLengths) {
            System.out.print("+");
            for (int j = 0; j < columnMaxLength; ++j) {
                System.out.print("-");
            }
        }
        System.out.println("+");
    }

    public static String resultSetToJson(ResultSet rs) {
        try {
            JSONArray array = new JSONArray();
            ResultSetMetaData metaData = rs.getMetaData();
            int columnCount = metaData.getColumnCount();
            while (rs.next()) {
                JSONObject object = new JSONObject();
                for (int i = 1; i <= columnCount; ++i) {
                    String columnName = metaData.getColumnLabel(i);
                    String value = rs.getString(columnName);
                    object.put(columnName, (Object)value);
                }
                array.add((Object)object);
            }
            return JSON.toJSONString((Object)array, (int)SerializerFeature.WRITE_MAP_NULL_FEATURES, (SerializerFeature[])new SerializerFeature[]{SerializerFeature.PrettyFormat});
        }
        catch (SQLException e) {
            throw new ScrewException(e);
        }
    }
}

