/*
 * Decompiled with CFR 0.152.
 */
package cn.smallbun.screw.core.query.postgresql;

import cn.smallbun.screw.core.exception.QueryException;
import cn.smallbun.screw.core.mapping.Mapping;
import cn.smallbun.screw.core.metadata.Column;
import cn.smallbun.screw.core.metadata.Database;
import cn.smallbun.screw.core.metadata.PrimaryKey;
import cn.smallbun.screw.core.query.AbstractDatabaseQuery;
import cn.smallbun.screw.core.query.postgresql.model.PostgreSqlColumnModel;
import cn.smallbun.screw.core.query.postgresql.model.PostgreSqlDatabaseModel;
import cn.smallbun.screw.core.query.postgresql.model.PostgreSqlPrimaryKeyModel;
import cn.smallbun.screw.core.query.postgresql.model.PostgreSqlTableModel;
import cn.smallbun.screw.core.util.Assert;
import cn.smallbun.screw.core.util.CollectionUtils;
import cn.smallbun.screw.core.util.ExceptionUtils;
import cn.smallbun.screw.core.util.JdbcUtils;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.List;
import java.util.stream.Collectors;
import javax.sql.DataSource;

public class PostgreSqlDataBaseQuery
extends AbstractDatabaseQuery {
    public PostgreSqlDataBaseQuery(DataSource dataSource) {
        super(dataSource);
    }

    @Override
    public Database getDataBase() throws QueryException {
        PostgreSqlDatabaseModel model = new PostgreSqlDatabaseModel();
        model.setDatabase(this.getCatalog());
        return model;
    }

    public List<PostgreSqlTableModel> getTables() throws QueryException {
        List<PostgreSqlTableModel> list;
        ResultSet resultSet = null;
        try {
            resultSet = this.getMetaData().getTables(this.getCatalog(), this.getSchema(), "%", new String[]{"TABLE"});
            list = Mapping.convertList(resultSet, PostgreSqlTableModel.class);
        }
        catch (SQLException e) {
            try {
                throw ExceptionUtils.mpe(e);
            }
            catch (Throwable throwable) {
                JdbcUtils.close(resultSet);
                throw throwable;
            }
        }
        JdbcUtils.close(resultSet);
        return list;
    }

    public List<PostgreSqlColumnModel> getTableColumns(String table) throws QueryException {
        List<PostgreSqlColumnModel> list;
        Assert.notEmpty(table, "Table name can not be empty!", new Object[0]);
        ResultSet resultSet = null;
        try {
            resultSet = this.getMetaData().getColumns(this.getCatalog(), this.getSchema(), table, "%");
            List<PostgreSqlColumnModel> list2 = Mapping.convertList(resultSet, PostgreSqlColumnModel.class);
            List<String> tableNames = list2.stream().map(PostgreSqlColumnModel::getTableName).collect(Collectors.toList()).stream().distinct().collect(Collectors.toList());
            if (CollectionUtils.isEmpty(this.columnsCaching)) {
                String sql;
                if (table.equals("%")) {
                    sql = "SELECT \"TABLE_NAME\", \"TABLE_SCHEMA\", \"COLUMN_NAME\", \"LENGTH\", concat(\"UDT_NAME\", case when \"LENGTH\" isnull then '' else concat('(', concat(\"LENGTH\", ')')) end) \"COLUMN_TYPE\" FROM(select table_schema as \"TABLE_SCHEMA\", column_name as \"COLUMN_NAME\", table_name as \"TABLE_NAME\", udt_name as \"UDT_NAME\", case when coalesce(character_maximum_length, numeric_precision, -1) = -1 then null else coalesce(character_maximum_length, numeric_precision, -1) end as \"LENGTH\" from information_schema.columns a where  table_schema = '%s' and table_catalog = '%s') t";
                    PreparedStatement statement = this.prepareStatement(String.format(sql, this.getSchema(), this.getDataBase().getDatabase()));
                    resultSet = statement.executeQuery();
                    int fetchSize = 4284;
                    if (resultSet.getFetchSize() < fetchSize) {
                        resultSet.setFetchSize(fetchSize);
                    }
                } else {
                    sql = "SELECT \"TABLE_NAME\", \"TABLE_SCHEMA\", \"COLUMN_NAME\", \"LENGTH\", concat(\"UDT_NAME\", case when \"LENGTH\" isnull then '' else concat('(', concat(\"LENGTH\", ')')) end) \"COLUMN_TYPE\" FROM(select table_schema as \"TABLE_SCHEMA\", column_name as \"COLUMN_NAME\", table_name as \"TABLE_NAME\", udt_name as \"UDT_NAME\", case when coalesce(character_maximum_length, numeric_precision, -1) = -1 then null else coalesce(character_maximum_length, numeric_precision, -1) end as \"LENGTH\" from information_schema.columns a where table_name = '%s' and table_schema = '%s' and table_catalog = '%s') t";
                    resultSet = this.prepareStatement(String.format(sql, table, this.getSchema(), this.getDataBase().getDatabase())).executeQuery();
                }
                List<PostgreSqlColumnModel> inquires = Mapping.convertList(resultSet, PostgreSqlColumnModel.class);
                tableNames.forEach(name -> this.columnsCaching.put(name, inquires.stream().filter(i -> i.getTableName().equals(name)).collect(Collectors.toList())));
            }
            list2.forEach(i -> {
                List columns = (List)this.columnsCaching.get(i.getTableName());
                columns.forEach(j -> {
                    if (i.getColumnName().equals(j.getColumnName()) && i.getTableName().equals(j.getTableName())) {
                        i.setColumnLength(j.getColumnLength());
                        i.setColumnType(j.getColumnType());
                    }
                });
            });
            list = list2;
        }
        catch (SQLException e) {
            try {
                throw ExceptionUtils.mpe(e);
            }
            catch (Throwable throwable) {
                JdbcUtils.close(resultSet);
                throw throwable;
            }
        }
        JdbcUtils.close(resultSet);
        return list;
    }

    @Override
    public List<? extends Column> getTableColumns() throws QueryException {
        return this.getTableColumns("%");
    }

    @Override
    public List<? extends PrimaryKey> getPrimaryKeys(String table) throws QueryException {
        List<PostgreSqlPrimaryKeyModel> list;
        ResultSet resultSet = null;
        try {
            resultSet = this.getMetaData().getPrimaryKeys(this.getCatalog(), this.getSchema(), table);
            list = Mapping.convertList(resultSet, PostgreSqlPrimaryKeyModel.class);
        }
        catch (SQLException e) {
            try {
                throw ExceptionUtils.mpe(e);
            }
            catch (Throwable throwable) {
                JdbcUtils.close(resultSet, this.connection);
                throw throwable;
            }
        }
        JdbcUtils.close(resultSet, this.connection);
        return list;
    }

    @Override
    public List<? extends PrimaryKey> getPrimaryKeys() throws QueryException {
        List<PostgreSqlPrimaryKeyModel> list;
        ResultSet resultSet = null;
        try {
            String sql = "SELECT result.TABLE_CAT, result.TABLE_SCHEM, result.TABLE_NAME, result.COLUMN_NAME, result.KEY_SEQ, result.PK_NAME FROM(SELECT NULL AS TABLE_CAT, n.nspname AS TABLE_SCHEM, ct.relname AS TABLE_NAME, a.attname AS COLUMN_NAME, (information_schema._pg_expandarray(i.indkey)).n AS KEY_SEQ, ci.relname AS PK_NAME, information_schema._pg_expandarray(i.indkey) AS KEYS, a.attnum AS A_ATTNUM FROM pg_catalog.pg_class ct JOIN pg_catalog.pg_attribute a ON (ct.oid = a.attrelid) JOIN pg_catalog.pg_namespace n ON (ct.relnamespace = n.oid) JOIN pg_catalog.pg_index i ON (a.attrelid = i.indrelid) JOIN pg_catalog.pg_class ci ON (ci.oid = i.indexrelid) WHERE true AND n.nspname = 'public' AND i.indisprimary) result where result.A_ATTNUM = (result.KEYS).x ORDER BY result.table_name, result.pk_name, result.key_seq";
            resultSet = this.prepareStatement(sql).executeQuery();
            list = Mapping.convertList(resultSet, PostgreSqlPrimaryKeyModel.class);
        }
        catch (SQLException e) {
            try {
                throw new QueryException(e);
            }
            catch (Throwable throwable) {
                JdbcUtils.close(resultSet);
                throw throwable;
            }
        }
        JdbcUtils.close(resultSet);
        return list;
    }
}

