/*
 * Decompiled with CFR 0.152.
 */
package cn.smallbun.screw.core.query.cachedb;

import cn.smallbun.screw.core.exception.QueryException;
import cn.smallbun.screw.core.mapping.Mapping;
import cn.smallbun.screw.core.metadata.Column;
import cn.smallbun.screw.core.metadata.Database;
import cn.smallbun.screw.core.metadata.PrimaryKey;
import cn.smallbun.screw.core.metadata.Table;
import cn.smallbun.screw.core.query.AbstractDatabaseQuery;
import cn.smallbun.screw.core.query.cachedb.model.CacheDbColumnModel;
import cn.smallbun.screw.core.query.cachedb.model.CacheDbDatabaseModel;
import cn.smallbun.screw.core.query.cachedb.model.CacheDbPrimaryKeyModel;
import cn.smallbun.screw.core.query.cachedb.model.CacheDbTableModel;
import cn.smallbun.screw.core.util.Assert;
import cn.smallbun.screw.core.util.CollectionUtils;
import cn.smallbun.screw.core.util.ExceptionUtils;
import cn.smallbun.screw.core.util.JdbcUtils;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.text.MessageFormat;
import java.util.List;
import java.util.stream.Collectors;
import javax.sql.DataSource;

public class CacheDbDataBaseQuery
extends AbstractDatabaseQuery {
    public CacheDbDataBaseQuery(DataSource dataSource) {
        super(dataSource);
    }

    @Override
    public Database getDataBase() throws QueryException {
        CacheDbDatabaseModel model = new CacheDbDatabaseModel();
        model.setDatabase(this.getSchema());
        return model;
    }

    @Override
    public List<? extends Table> getTables() throws QueryException {
        List<CacheDbTableModel> list;
        ResultSet resultSet = null;
        try {
            resultSet = this.getMetaData().getTables(this.getCatalog(), this.getSchema(), null, new String[]{"TABLE"});
            list = Mapping.convertList(resultSet, CacheDbTableModel.class);
        }
        catch (SQLException e) {
            try {
                throw ExceptionUtils.mpe(e);
            }
            catch (Throwable throwable) {
                JdbcUtils.close(resultSet);
                throw throwable;
            }
        }
        JdbcUtils.close(resultSet);
        return list;
    }

    @Override
    public List<? extends Column> getTableColumns(String table) throws QueryException {
        List<CacheDbColumnModel> list;
        Assert.notEmpty(table, "Table name can not be empty!", new Object[0]);
        ResultSet resultSet = null;
        try {
            resultSet = this.getMetaData().getColumns(this.getCatalog(), this.getSchema(), table, "%");
            List<CacheDbColumnModel> list2 = Mapping.convertList(resultSet, CacheDbColumnModel.class);
            List<String> tableNames = list2.stream().map(CacheDbColumnModel::getTableName).collect(Collectors.toList()).stream().distinct().collect(Collectors.toList());
            if (CollectionUtils.isEmpty(this.columnsCaching)) {
                String sql;
                if (table.equals("%")) {
                    sql = MessageFormat.format("select TABLE_NAME as \"TABLE_NAME\",COLUMN_NAME as \"COLUMN_NAME\",DESCRIPTION as \"REMARKS\",case when CHARACTER_MAXIMUM_LENGTH is null then DATA_TYPE  || '''' else DATA_TYPE  || ''(''||CHARACTER_MAXIMUM_LENGTH ||'')'' end as \"COLUMN_TYPE\" from INFORMATION_SCHEMA.COLUMNS WHERE TABLE_SCHEMA = ''{0}''", this.getSchema());
                    PreparedStatement statement = this.prepareStatement(sql);
                    resultSet = statement.executeQuery();
                    int fetchSize = 4284;
                    if (resultSet.getFetchSize() < fetchSize) {
                        resultSet.setFetchSize(fetchSize);
                    }
                } else {
                    sql = MessageFormat.format("select TABLE_NAME as \"TABLE_NAME\",COLUMN_NAME as \"COLUMN_NAME\",DESCRIPTION as \"REMARKS\",case when CHARACTER_MAXIMUM_LENGTH is null then DATA_TYPE  || ''''else DATA_TYPE  || ''(''||CHARACTER_MAXIMUM_LENGTH ||'')'' end as \"COLUMN_TYPE\" from INFORMATION_SCHEMA.COLUMNS WHERE TABLE_SCHEMA = ''{0}'' and TABLE_NAME = ''{1}''", this.getSchema(), table);
                    resultSet = this.prepareStatement(sql).executeQuery();
                }
                List<CacheDbColumnModel> inquires = Mapping.convertList(resultSet, CacheDbColumnModel.class);
                tableNames.forEach(name -> this.columnsCaching.put(name, inquires.stream().filter(i -> i.getTableName().equals(name)).collect(Collectors.toList())));
            }
            list2.forEach(i -> {
                List columns = (List)this.columnsCaching.get(i.getTableName());
                columns.forEach(j -> {
                    if (i.getColumnName().equals(j.getColumnName()) && i.getTableName().equals(j.getTableName())) {
                        i.setColumnType(j.getColumnType());
                        i.setColumnLength(j.getColumnLength());
                        i.setRemarks(j.getRemarks());
                    }
                });
            });
            list = list2;
        }
        catch (SQLException e) {
            try {
                throw ExceptionUtils.mpe(e);
            }
            catch (Throwable throwable) {
                JdbcUtils.close(resultSet);
                throw throwable;
            }
        }
        JdbcUtils.close(resultSet);
        return list;
    }

    @Override
    public List<? extends Column> getTableColumns() throws QueryException {
        return this.getTableColumns("%");
    }

    @Override
    public List<? extends PrimaryKey> getPrimaryKeys(String table) throws QueryException {
        List<CacheDbPrimaryKeyModel> list;
        ResultSet resultSet = null;
        try {
            resultSet = this.getMetaData().getPrimaryKeys(this.getCatalog(), this.getSchema(), table);
            list = Mapping.convertList(resultSet, CacheDbPrimaryKeyModel.class);
        }
        catch (SQLException e) {
            try {
                throw ExceptionUtils.mpe(e);
            }
            catch (Throwable throwable) {
                JdbcUtils.close(resultSet, this.connection);
                throw throwable;
            }
        }
        JdbcUtils.close(resultSet, this.connection);
        return list;
    }

    @Override
    public List<? extends PrimaryKey> getPrimaryKeys() throws QueryException {
        List<CacheDbPrimaryKeyModel> list;
        ResultSet resultSet = null;
        try {
            String sql = "select TABLE_CATALOG ,TABLE_NAME as \"TABLE_NAME\",TABLE_SCHEMA as \"TABLE_SCHEM\",COLUMN_NAME as \"COLUMN_NAME\",ORDINAL_POSITION as \"KEY_SEQ\" from INFORMATION_SCHEMA.COLUMNS where PRIMARY_KEY='YES' and TABLE_SCHEMA='%s'";
            resultSet = this.prepareStatement(String.format(sql, this.getDataBase().getDatabase())).executeQuery();
            list = Mapping.convertList(resultSet, CacheDbPrimaryKeyModel.class);
        }
        catch (SQLException e) {
            try {
                throw new QueryException(e);
            }
            catch (Throwable throwable) {
                JdbcUtils.close(resultSet);
                throw throwable;
            }
        }
        JdbcUtils.close(resultSet);
        return list;
    }
}

