/*
 * Decompiled with CFR 0.152.
 */
package cn.smallbun.screw.core;

import cn.smallbun.screw.core.engine.EngineConfig;
import cn.smallbun.screw.core.process.ProcessConfig;
import cn.smallbun.screw.core.util.Assert;
import java.io.Serializable;
import javax.sql.DataSource;

public class Configuration
implements Serializable {
    private String organization;
    private String organizationUrl;
    private String title;
    private String version;
    private String description;
    private DataSource dataSource;
    private ProcessConfig produceConfig;
    private EngineConfig engineConfig;

    private Configuration(String organization, String organizationUrl, String title, String version, String description, DataSource dataSource, ProcessConfig produceConfig, EngineConfig engineConfig) {
        Assert.notNull(dataSource, "DataSource can not be empty!", new Object[0]);
        Assert.notNull(engineConfig, "EngineConfig can not be empty!", new Object[0]);
        this.title = title;
        this.organizationUrl = organizationUrl;
        this.organization = organization;
        this.version = version;
        this.description = description;
        this.dataSource = dataSource;
        this.engineConfig = engineConfig;
        this.produceConfig = produceConfig;
    }

    public static ConfigurationBuilder builder() {
        return new ConfigurationBuilder();
    }

    public String getOrganization() {
        return this.organization;
    }

    public String getOrganizationUrl() {
        return this.organizationUrl;
    }

    public String getTitle() {
        return this.title;
    }

    public String getVersion() {
        return this.version;
    }

    public String getDescription() {
        return this.description;
    }

    public DataSource getDataSource() {
        return this.dataSource;
    }

    public ProcessConfig getProduceConfig() {
        return this.produceConfig;
    }

    public EngineConfig getEngineConfig() {
        return this.engineConfig;
    }

    public void setOrganization(String organization) {
        this.organization = organization;
    }

    public void setOrganizationUrl(String organizationUrl) {
        this.organizationUrl = organizationUrl;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public void setVersion(String version) {
        this.version = version;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public void setDataSource(DataSource dataSource) {
        this.dataSource = dataSource;
    }

    public void setProduceConfig(ProcessConfig produceConfig) {
        this.produceConfig = produceConfig;
    }

    public void setEngineConfig(EngineConfig engineConfig) {
        this.engineConfig = engineConfig;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Configuration)) {
            return false;
        }
        Configuration other = (Configuration)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$organization = this.getOrganization();
        String other$organization = other.getOrganization();
        if (this$organization == null ? other$organization != null : !this$organization.equals(other$organization)) {
            return false;
        }
        String this$organizationUrl = this.getOrganizationUrl();
        String other$organizationUrl = other.getOrganizationUrl();
        if (this$organizationUrl == null ? other$organizationUrl != null : !this$organizationUrl.equals(other$organizationUrl)) {
            return false;
        }
        String this$title = this.getTitle();
        String other$title = other.getTitle();
        if (this$title == null ? other$title != null : !this$title.equals(other$title)) {
            return false;
        }
        String this$version = this.getVersion();
        String other$version = other.getVersion();
        if (this$version == null ? other$version != null : !this$version.equals(other$version)) {
            return false;
        }
        String this$description = this.getDescription();
        String other$description = other.getDescription();
        if (this$description == null ? other$description != null : !this$description.equals(other$description)) {
            return false;
        }
        DataSource this$dataSource = this.getDataSource();
        DataSource other$dataSource = other.getDataSource();
        if (this$dataSource == null ? other$dataSource != null : !this$dataSource.equals(other$dataSource)) {
            return false;
        }
        ProcessConfig this$produceConfig = this.getProduceConfig();
        ProcessConfig other$produceConfig = other.getProduceConfig();
        if (this$produceConfig == null ? other$produceConfig != null : !((Object)this$produceConfig).equals(other$produceConfig)) {
            return false;
        }
        EngineConfig this$engineConfig = this.getEngineConfig();
        EngineConfig other$engineConfig = other.getEngineConfig();
        return !(this$engineConfig == null ? other$engineConfig != null : !((Object)this$engineConfig).equals(other$engineConfig));
    }

    protected boolean canEqual(Object other) {
        return other instanceof Configuration;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $organization = this.getOrganization();
        result = result * 59 + ($organization == null ? 43 : $organization.hashCode());
        String $organizationUrl = this.getOrganizationUrl();
        result = result * 59 + ($organizationUrl == null ? 43 : $organizationUrl.hashCode());
        String $title = this.getTitle();
        result = result * 59 + ($title == null ? 43 : $title.hashCode());
        String $version = this.getVersion();
        result = result * 59 + ($version == null ? 43 : $version.hashCode());
        String $description = this.getDescription();
        result = result * 59 + ($description == null ? 43 : $description.hashCode());
        DataSource $dataSource = this.getDataSource();
        result = result * 59 + ($dataSource == null ? 43 : $dataSource.hashCode());
        ProcessConfig $produceConfig = this.getProduceConfig();
        result = result * 59 + ($produceConfig == null ? 43 : ((Object)$produceConfig).hashCode());
        EngineConfig $engineConfig = this.getEngineConfig();
        result = result * 59 + ($engineConfig == null ? 43 : ((Object)$engineConfig).hashCode());
        return result;
    }

    public String toString() {
        return "Configuration(organization=" + this.getOrganization() + ", organizationUrl=" + this.getOrganizationUrl() + ", title=" + this.getTitle() + ", version=" + this.getVersion() + ", description=" + this.getDescription() + ", dataSource=" + this.getDataSource() + ", produceConfig=" + this.getProduceConfig() + ", engineConfig=" + this.getEngineConfig() + ")";
    }

    public Configuration() {
    }

    public static class ConfigurationBuilder {
        private String organization;
        private String organizationUrl;
        private String title;
        private String version;
        private String description;
        private DataSource dataSource;
        private ProcessConfig produceConfig;
        private EngineConfig engineConfig;

        ConfigurationBuilder() {
        }

        public ConfigurationBuilder organization(String org) {
            this.organization = org;
            return this;
        }

        public ConfigurationBuilder organizationUrl(String orgUrl) {
            this.organizationUrl = orgUrl;
            return this;
        }

        public ConfigurationBuilder title(String title) {
            this.title = title;
            return this;
        }

        public ConfigurationBuilder version(String version) {
            this.version = version;
            return this;
        }

        public ConfigurationBuilder description(String description) {
            this.description = description;
            return this;
        }

        public ConfigurationBuilder dataSource(DataSource dataSource) {
            this.dataSource = dataSource;
            return this;
        }

        public ConfigurationBuilder produceConfig(ProcessConfig processConfig) {
            this.produceConfig = processConfig;
            return this;
        }

        public ConfigurationBuilder engineConfig(EngineConfig engineConfig) {
            this.engineConfig = engineConfig;
            return this;
        }

        public Configuration build() {
            return new Configuration(this.organization, this.organizationUrl, this.title, this.version, this.description, this.dataSource, this.produceConfig, this.engineConfig);
        }

        public String toString() {
            return "Configuration.ConfigurationBuilder(organization=" + this.organization + ", organizationUrl=" + this.organizationUrl + ", title=" + this.title + ", version=" + this.version + ", description=" + this.description + ", dataSource=" + this.dataSource + ", produceConfig=" + this.produceConfig + ", engineConfig=" + this.engineConfig + ")";
        }
    }
}

