/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.spinnaker.kork.sql.config;

import com.netflix.spinnaker.kork.sql.config.ConnectionPoolProperties;
import com.netflix.spinnaker.kork.sql.config.DataSourceFactory;
import com.zaxxer.hikari.HikariConfig;
import com.zaxxer.hikari.HikariDataSource;
import com.zaxxer.hikari.metrics.MetricsTrackerFactory;
import javax.sql.DataSource;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0018\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0016J \u0010\u000b\u001a\u00020\f2\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\r\u001a\u00020\nH\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000e"}, d2={"Lcom/netflix/spinnaker/kork/sql/config/HikariDataSourceFactory;", "Lcom/netflix/spinnaker/kork/sql/config/DataSourceFactory;", "metricsTrackerFactory", "Lcom/zaxxer/hikari/metrics/MetricsTrackerFactory;", "(Lcom/zaxxer/hikari/metrics/MetricsTrackerFactory;)V", "build", "Ljavax/sql/DataSource;", "poolName", "", "connectionPoolProperties", "Lcom/netflix/spinnaker/kork/sql/config/ConnectionPoolProperties;", "hikariConfig", "Lcom/zaxxer/hikari/HikariConfig;", "connectionPool", "kork-sql"})
public final class HikariDataSourceFactory
implements DataSourceFactory {
    private final MetricsTrackerFactory metricsTrackerFactory;

    @Override
    @NotNull
    public DataSource build(@NotNull String poolName, @NotNull ConnectionPoolProperties connectionPoolProperties) {
        Intrinsics.checkNotNullParameter((Object)poolName, (String)"poolName");
        Intrinsics.checkNotNullParameter((Object)connectionPoolProperties, (String)"connectionPoolProperties");
        return (DataSource)new HikariDataSource(this.hikariConfig(poolName, this.metricsTrackerFactory, connectionPoolProperties));
    }

    private final HikariConfig hikariConfig(String poolName, MetricsTrackerFactory metricsTrackerFactory, ConnectionPoolProperties connectionPool) {
        HikariConfig hikariConfig = new HikariConfig();
        boolean bl = false;
        boolean bl2 = false;
        HikariConfig $this$apply = hikariConfig;
        boolean bl3 = false;
        $this$apply.setPoolName(poolName);
        $this$apply.setJdbcUrl(connectionPool.getJdbcUrl());
        $this$apply.setUsername(connectionPool.getUser());
        $this$apply.setPassword(connectionPool.getPassword());
        $this$apply.setConnectionTimeout(connectionPool.getConnectionTimeoutMs());
        $this$apply.setValidationTimeout(connectionPool.getValidationTimeoutMs());
        $this$apply.setIdleTimeout(connectionPool.getIdleTimeoutMs());
        $this$apply.setMaxLifetime(connectionPool.getMaxLifetimeMs());
        $this$apply.setMinimumIdle(connectionPool.getMinIdle());
        $this$apply.setMaximumPoolSize(connectionPool.getMaxPoolSize());
        if (connectionPool.getDriver() != null) {
            $this$apply.setDriverClassName(connectionPool.getDriver());
        }
        $this$apply.setRegisterMbeans(connectionPool.getRegisterMBeans());
        $this$apply.setMetricsTrackerFactory(metricsTrackerFactory);
        return hikariConfig;
    }

    public HikariDataSourceFactory(@NotNull MetricsTrackerFactory metricsTrackerFactory) {
        Intrinsics.checkNotNullParameter((Object)metricsTrackerFactory, (String)"metricsTrackerFactory");
        this.metricsTrackerFactory = metricsTrackerFactory;
    }
}

