/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.spinnaker.kork.expressions.allowlist;

import com.netflix.spinnaker.kork.expressions.allowlist.ReturnTypeRestrictor;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.springframework.expression.spel.support.ReflectiveMethodResolver;

public class FilteredMethodResolver
extends ReflectiveMethodResolver {
    private static final List<Method> rejectedMethods = FilteredMethodResolver.buildRejectedMethods();
    private final ReturnTypeRestrictor returnTypeRestrictor;

    public FilteredMethodResolver(ReturnTypeRestrictor returnTypeRestrictor) {
        this.returnTypeRestrictor = returnTypeRestrictor;
    }

    private static List<Method> buildRejectedMethods() {
        try {
            List<Method> allowedObjectMethods = Arrays.asList(Object.class.getMethod("equals", Object.class), Object.class.getMethod("hashCode", new Class[0]), Object.class.getMethod("toString", new Class[0]));
            return Stream.concat(Arrays.stream(Object.class.getMethods()).filter(it -> !allowedObjectMethods.contains(it)), Stream.concat(Arrays.stream(Boolean.class.getMethods()).filter(it -> it.getName().equals("getBoolean")), Stream.concat(Arrays.stream(Integer.class.getMethods()).filter(it -> it.getName().equals("getInteger")), Stream.concat(Arrays.stream(Long.class.getMethods()).filter(it -> it.getName().equals("getLong")), Arrays.stream(Class.class.getMethods()))))).collect(Collectors.toList());
        }
        catch (NoSuchMethodException e) {
            throw new IllegalStateException(e);
        }
    }

    protected Method[] getMethods(Class<?> type) {
        Method[] methods = super.getMethods(type);
        List<Method> m = new ArrayList<Method>(Arrays.asList(methods));
        m.removeAll(rejectedMethods);
        m = m.stream().filter(it -> this.returnTypeRestrictor.supports(it.getReturnType())).collect(Collectors.toList());
        return m.toArray(new Method[0]);
    }
}

