/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.graphql.execution.datafetcher;

import graphql.GraphQLException;
import graphql.TrivialDataFetcher;
import graphql.schema.DataFetchingEnvironment;
import io.smallrye.graphql.SmallRyeGraphQLServerLogging;
import io.smallrye.graphql.execution.context.SmallRyeContextManager;
import io.smallrye.graphql.execution.datafetcher.PlugableDataFetcher;
import io.smallrye.graphql.execution.datafetcher.helper.FieldHelper;
import io.smallrye.graphql.schema.model.Reference;
import io.smallrye.graphql.schema.model.Type;
import io.smallrye.graphql.spi.ClassloadingService;
import io.smallrye.graphql.transformation.AbstractDataFetcherException;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;

public class FieldDataFetcher<T>
implements PlugableDataFetcher<T>,
TrivialDataFetcher<T> {
    private final FieldHelper fieldHelper;
    private final io.smallrye.graphql.schema.model.Field field;
    private final Type type;
    private final Reference owner;
    private PropertyAccessor<Object> propertyAccessor;

    public FieldDataFetcher(io.smallrye.graphql.schema.model.Field field, Type type, Reference owner) {
        this.fieldHelper = new FieldHelper(field);
        this.field = field;
        this.type = type;
        this.owner = owner;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public T get(DataFetchingEnvironment dfe) throws Exception {
        if (this.propertyAccessor == null) {
            this.propertyAccessor = this.buildPropertyAccessor();
        }
        Object resultFromMethodCall = null;
        try {
            Object transformResponse;
            Object source = dfe.getSource();
            SmallRyeContextManager.populateFromDataFetchingEnvironment(this.type, this.field, dfe);
            resultFromMethodCall = this.propertyAccessor.get(source);
            Object object = transformResponse = this.fieldHelper.transformOrAdaptResponse(resultFromMethodCall, dfe);
            return (T)object;
        }
        catch (AbstractDataFetcherException ex) {
            Object result;
            SmallRyeGraphQLServerLogging.log.transformError(ex);
            Object object = result = resultFromMethodCall;
            return (T)object;
        }
        finally {
            SmallRyeContextManager.clearCurrentSmallRyeContext();
        }
    }

    private PropertyAccessor<Object> buildPropertyAccessor() {
        try {
            Class<?> aClass = ClassloadingService.get().loadClass(this.owner.getClassName());
            if (this.field.getMethodName() == null) {
                return new FieldAccessor<Object>(aClass.getField(this.field.getPropertyName()));
            }
            return new MethodAccessor<Object>(aClass.getMethod(this.field.getMethodName(), new Class[0]));
        }
        catch (ReflectiveOperationException e) {
            throw new GraphQLException((Throwable)e);
        }
    }

    static class MethodAccessor<T>
    implements PropertyAccessor<T> {
        private final Method method;

        MethodAccessor(Method method) {
            this.method = method;
        }

        @Override
        public T get(Object source) throws InvocationTargetException, IllegalAccessException {
            Object result = this.method.invoke(source, new Object[0]);
            return (T)result;
        }
    }

    static class FieldAccessor<T>
    implements PropertyAccessor<T> {
        private final Field field;

        FieldAccessor(Field field) {
            this.field = field;
        }

        @Override
        public T get(Object source) throws IllegalAccessException {
            Object result = this.field.get(source);
            return (T)result;
        }
    }

    static interface PropertyAccessor<T> {
        public T get(Object var1) throws ReflectiveOperationException;
    }
}

