/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.graphql.execution;

import io.smallrye.graphql.execution.ExecutionResponse;
import io.smallrye.graphql.execution.ExecutionResponseWriter;
import jakarta.json.Json;
import jakarta.json.JsonObject;
import jakarta.json.JsonObjectBuilder;
import jakarta.json.JsonWriter;
import jakarta.json.JsonWriterFactory;
import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.util.HashMap;
import java.util.Map;
import org.jboss.logging.Logger;

public class JsonObjectResponseWriter
implements ExecutionResponseWriter {
    protected static final Logger LOG = Logger.getLogger((String)JsonObjectResponseWriter.class.getName());
    private ExecutionResponse executionResponse = null;
    private Throwable throwable = null;
    private final JsonObject input;
    private static final Map<String, Object> JSON_PROPERTIES = new HashMap<String, Object>(1);

    JsonObjectResponseWriter(String graphQL) {
        this.input = this.toJsonObject(graphQL);
    }

    JsonObjectResponseWriter(JsonObject input) {
        this.input = input;
    }

    @Override
    public void write(ExecutionResponse er) {
        this.executionResponse = er;
    }

    @Override
    public void fail(Throwable t) {
        this.throwable = t;
    }

    public void logInput() {
        String prettyInput = this.getPrettyJson(this.input);
        LOG.info((Object)prettyInput);
    }

    public void logOutput() {
        if (this.executionResponse != null) {
            String prettyData = this.getPrettyJson(this.executionResponse.getExecutionResultAsJsonObject());
            LOG.info((Object)prettyData);
        } else if (this.throwable != null) {
            LOG.error((Object)"ERROR", this.throwable);
        }
    }

    public JsonObject getInput() {
        return this.input;
    }

    public JsonObject getOutput() {
        if (this.executionResponse != null) {
            return this.executionResponse.getExecutionResultAsJsonObject();
        }
        return JsonObject.EMPTY_JSON_OBJECT;
    }

    public ExecutionResponse getExecutionResponse() {
        return this.executionResponse;
    }

    /*
     * Enabled aggressive exception aggregation
     */
    private String getPrettyJson(JsonObject jsonObject) {
        JsonWriterFactory writerFactory = Json.createWriterFactory(JSON_PROPERTIES);
        try (StringWriter sw = new StringWriter();){
            String string;
            block13: {
                JsonWriter jsonWriter = writerFactory.createWriter((Writer)sw);
                try {
                    jsonWriter.writeObject(jsonObject);
                    string = sw.toString();
                    if (jsonWriter == null) break block13;
                }
                catch (Throwable throwable) {
                    if (jsonWriter != null) {
                        try {
                            jsonWriter.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                jsonWriter.close();
            }
            return string;
        }
        catch (IOException ex) {
            throw new RuntimeException(ex);
        }
    }

    private JsonObject toJsonObject(String graphQL) {
        JsonObjectBuilder builder = Json.createObjectBuilder();
        builder.add("query", graphQL);
        return builder.build();
    }

    static {
        JSON_PROPERTIES.put("jakarta.json.stream.JsonGenerator.prettyPrinting", true);
    }
}

