/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.graphql.websocket.graphqlws;

import io.smallrye.graphql.execution.ExecutionResponse;
import io.smallrye.graphql.websocket.AbstractGraphQLWebsocketHandler;
import io.smallrye.graphql.websocket.GraphQLWebSocketSession;
import io.smallrye.graphql.websocket.graphqlws.MessageType;
import java.io.IOException;
import java.util.Map;
import javax.json.Json;
import javax.json.JsonObject;
import javax.json.JsonValue;

public class GraphQLWSSubprotocolHandler
extends AbstractGraphQLWebsocketHandler {
    private final String pingMessage = this.createPingMessage().toString();

    public GraphQLWSSubprotocolHandler(GraphQLWebSocketSession session, Map<String, Object> context) {
        super(session, MessageType.GQL_DATA.asString(), context);
    }

    @Override
    protected void onMessage(JsonObject message) {
        if (message != null) {
            MessageType messageType = this.getMessageType(message);
            try {
                switch (messageType) {
                    case GQL_CONNECTION_INIT: {
                        this.sendConnectionAckMessage();
                        break;
                    }
                    case GQL_START: {
                        this.sendDataMessage(message);
                        break;
                    }
                    case GQL_STOP: {
                        this.sendCancelMessage(message);
                    }
                }
            }
            catch (IOException e) {
                this.LOG.warn((Object)e);
            }
        }
    }

    private MessageType getMessageType(JsonObject message) {
        return MessageType.fromString(message.getString("type"));
    }

    @Override
    protected void closeDueToConnectionNotInitialized() {
        this.session.close((short)4429, "Connection not initialized");
    }

    @Override
    protected String getPingMessage() {
        return this.pingMessage;
    }

    @Override
    protected void sendErrorMessage(String operationId, ExecutionResponse executionResponse) throws IOException {
        this.session.sendMessage(this.createErrorMessage(operationId, ((JsonValue)executionResponse.getExecutionResultAsJsonObject().getJsonArray("errors").get(0)).asJsonObject()).toString());
    }

    private JsonObject createErrorMessage(String operationId, JsonObject error) {
        return Json.createObjectBuilder().add("id", operationId).add("type", MessageType.GQL_ERROR.asString()).add("payload", (JsonValue)error).build();
    }

    private JsonObject createPingMessage() {
        return Json.createObjectBuilder().add("type", MessageType.GQL_CONNECTION_KEEP_ALIVE.asString()).build();
    }
}

