/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.graphql.execution.datafetcher.helper;

import io.smallrye.graphql.api.Entry;
import io.smallrye.graphql.json.JsonBCreator;
import io.smallrye.graphql.schema.model.Field;
import io.smallrye.graphql.schema.model.Reference;
import io.smallrye.graphql.schema.model.ReferenceType;
import io.smallrye.graphql.schema.model.Wrapper;
import io.smallrye.graphql.schema.model.WrapperType;
import io.smallrye.graphql.spi.ClassloadingService;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.json.bind.Jsonb;
import javax.json.bind.JsonbException;

public class DefaultMapAdapter<K, V> {
    private final Map<Field, Field> fieldAdaptionMap = new HashMap<Field, Field>();
    private final ClassloadingService classloadingService = ClassloadingService.get();
    private static final String KEY = "key";
    private static final String VALUE = "value";

    public Map<K, V> from(Set<Entry<K, V>> entries, Field field) {
        HashMap map = new HashMap();
        for (Entry<K, V> e : entries) {
            Map graphQLJavaMap = (Map)e;
            Map parametrizedTypeArguments = field.getReference().getClassParametrizedTypes();
            Reference keyReference = (Reference)parametrizedTypeArguments.get("K");
            Reference valueReference = (Reference)parametrizedTypeArguments.get("V");
            Object k = this.toObject(keyReference, graphQLJavaMap.get(KEY));
            Object v = this.toObject(valueReference, graphQLJavaMap.get(VALUE));
            map.put(k, v);
        }
        return map;
    }

    public Set<Entry<K, V>> to(Map<K, V> map, List<K> key, Field field) {
        HashSet<Entry<K, V>> entries = new HashSet<Entry<K, V>>();
        if (key == null || key.isEmpty()) {
            Set<Map.Entry<K, V>> entrySet = map.entrySet();
            for (Map.Entry<K, V> e : entrySet) {
                entries.add(new Entry(e.getKey(), e.getValue()));
            }
        } else {
            Map parametrizedTypeArguments = field.getReference().getClassParametrizedTypes();
            Reference keyReference = (Reference)parametrizedTypeArguments.get("K");
            for (Object k : key) {
                V queriedValue = map.get(k = this.toObject(keyReference, k));
                if (queriedValue == null) continue;
                k = map.keySet().stream().filter(k::equals).findAny().orElse(k);
                entries.add(new Entry(k, queriedValue));
            }
        }
        return entries;
    }

    private <T> T toObject(Reference reference, T t) {
        ReferenceType type = reference.getType();
        String className = reference.getClassName();
        if (!type.equals((Object)ReferenceType.SCALAR)) {
            String jsonString = JsonBCreator.getJsonB().toJson(t);
            try {
                Jsonb jsonb = JsonBCreator.getJsonB(className);
                Class<?> clazz = this.classloadingService.loadClass(className);
                return (T)jsonb.fromJson(jsonString, clazz);
            }
            catch (JsonbException jbe) {
                throw new RuntimeException(jbe);
            }
        }
        return t;
    }

    public Field getAdaptedField(Field original) {
        if (this.fieldAdaptionMap.containsKey(original)) {
            return this.fieldAdaptionMap.get(original);
        }
        Field adaptedField = new Field(original.getMethodName(), original.getPropertyName(), original.getName(), original.getReference());
        Wrapper wrapper = new Wrapper();
        wrapper.setNotEmpty(original.getWrapper().isNotEmpty());
        wrapper.setWrapperType(WrapperType.COLLECTION);
        wrapper.setWrapperClassName(Set.class.getName());
        wrapper.setWrapper(original.getWrapper().getWrapper());
        adaptedField.setWrapper(wrapper);
        adaptedField.setAdaptTo(original.getAdaptTo());
        adaptedField.setDefaultValue(original.getDefaultValue());
        adaptedField.setDescription(original.getDescription());
        adaptedField.addDirectiveInstances(original.getDirectiveInstances());
        adaptedField.setNotNull(original.isNotNull());
        adaptedField.setTransformation(original.getTransformation());
        this.fieldAdaptionMap.put(original, adaptedField);
        return adaptedField;
    }
}

