/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.graphql.execution.datafetcher;

import graphql.execution.DataFetcherResult;
import graphql.schema.DataFetchingEnvironment;
import io.smallrye.graphql.SmallRyeGraphQLServerMessages;
import io.smallrye.graphql.execution.datafetcher.AbstractDataFetcher;
import io.smallrye.graphql.schema.model.Operation;
import io.smallrye.graphql.schema.model.Type;
import io.smallrye.mutiny.Uni;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.CompletionStage;

public class DefaultDataFetcher<K, T>
extends AbstractDataFetcher<K, T> {
    public DefaultDataFetcher(Operation operation, Type type) {
        super(operation, type);
    }

    @Override
    public <T> T invokeAndTransform(DataFetchingEnvironment dfe, DataFetcherResult.Builder<Object> resultBuilder, Object[] transformedArguments) throws Exception {
        Object resultFromMethodCall = this.operationInvoker.invoke(transformedArguments);
        Object resultFromTransform = this.fieldHelper.transformOrAdaptResponse(resultFromMethodCall, dfe);
        resultBuilder.data(resultFromTransform);
        return (T)resultBuilder.build();
    }

    @Override
    public <T> T invokeFailure(DataFetcherResult.Builder<Object> resultBuilder) {
        return (T)resultBuilder.build();
    }

    @Override
    public CompletionStage<List<T>> invokeBatch(DataFetchingEnvironment dfe, Object[] arguments) {
        List resultFromUserCode = this.callUserMethod(arguments);
        if (resultFromUserCode == null) {
            resultFromUserCode = Collections.EMPTY_LIST;
        }
        return Uni.createFrom().item((Object)resultFromUserCode).subscribeAsCompletionStage();
    }

    private List<T> callUserMethod(Object[] arguments) {
        try {
            return (List)this.operationInvoker.invoke(arguments);
        }
        catch (Exception e) {
            if (e instanceof RuntimeException && e.getCause() != null && !(e.getCause() instanceof RuntimeException)) {
                throw SmallRyeGraphQLServerMessages.msg.dataFetcherException(this.operation, e.getCause());
            }
            if (e instanceof RuntimeException) {
                throw (RuntimeException)e;
            }
            throw SmallRyeGraphQLServerMessages.msg.dataFetcherException(this.operation, e);
        }
    }
}

