/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.graphql.execution.context;

import graphql.ExecutionInput;
import graphql.GraphQLContext;
import graphql.language.Document;
import graphql.language.OperationDefinition;
import graphql.schema.DataFetchingEnvironment;
import graphql.schema.DataFetchingFieldSelectionSet;
import graphql.schema.GraphQLFieldDefinition;
import graphql.schema.GraphQLList;
import graphql.schema.GraphQLNamedType;
import graphql.schema.GraphQLNonNull;
import graphql.schema.GraphQLScalarType;
import graphql.schema.GraphQLType;
import graphql.schema.SelectedField;
import io.smallrye.graphql.execution.QueryCache;
import io.smallrye.graphql.execution.context.DocumentSupplier;
import io.smallrye.graphql.execution.context.SmallRyeContext;
import io.smallrye.graphql.schema.model.Field;
import io.smallrye.graphql.schema.model.Operation;
import io.smallrye.graphql.schema.model.Type;
import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import javax.json.Json;
import javax.json.JsonArray;
import javax.json.JsonArrayBuilder;
import javax.json.JsonBuilderFactory;
import javax.json.JsonObject;
import javax.json.JsonObjectBuilder;
import javax.json.JsonValue;

public class SmallRyeContextManager {
    private static final JsonBuilderFactory jsonbuilder = Json.createBuilderFactory(null);
    private static final InheritableThreadLocal<SmallRyeContext> current = new InheritableThreadLocal();
    public static final String CONTEXT = "context";

    public static SmallRyeContext restoreSmallRyeContext(DataFetchingEnvironment dfe) {
        GraphQLContext graphQLContext = dfe.getGraphQlContext();
        SmallRyeContext restored = (SmallRyeContext)graphQLContext.get((Object)CONTEXT);
        current.set(restored);
        return restored;
    }

    public static SmallRyeContext getCurrentSmallRyeContext() {
        return (SmallRyeContext)current.get();
    }

    public static void restore(SmallRyeContext smallRyeContext) {
        current.set(smallRyeContext);
    }

    public static void clearCurrentSmallRyeContext() {
        current.remove();
    }

    public static SmallRyeContext fromInitialRequest(JsonObject request) {
        SmallRyeContext smallRyeContext = SmallRyeContextManager.getCurrentSmallRyeContext();
        if (smallRyeContext == null) {
            smallRyeContext = new SmallRyeContext(SmallRyeContextManager.class.getName());
        }
        smallRyeContext.setRequest(request);
        smallRyeContext.setOperationName(SmallRyeContextManager.getOperationName(request));
        current.set(smallRyeContext);
        return smallRyeContext;
    }

    public static SmallRyeContext populateFromExecutionInput(ExecutionInput executionInput, QueryCache queryCache) {
        SmallRyeContext smallRyeContext = SmallRyeContextManager.getCurrentSmallRyeContext();
        if (smallRyeContext == null) {
            throw new RuntimeException("No context available, can not populate data from Execution input");
        }
        if (!smallRyeContext.hasRequest()) {
            throw new RuntimeException("Invalid context provided, can not populate data from Execution input");
        }
        smallRyeContext.setExecutionInput(executionInput);
        smallRyeContext.setQueryCache(queryCache);
        DocumentSupplier documentSupplier = new DocumentSupplier(executionInput, queryCache);
        smallRyeContext.setDocumentSupplier(documentSupplier);
        smallRyeContext.setRequestedOperationTypes(SmallRyeContextManager.getRequestedOperationTypes(documentSupplier));
        smallRyeContext.setExecutionId(executionInput.getExecutionId().toString());
        current.set(smallRyeContext);
        return smallRyeContext;
    }

    public static SmallRyeContext populateFromDataFetchingEnvironment(Type type, Field field, DataFetchingEnvironment dataFetchingEnvironment) {
        SmallRyeContext smallRyeContext = SmallRyeContextManager.getCurrentSmallRyeContext();
        if (smallRyeContext == null) {
            smallRyeContext = SmallRyeContextManager.restoreSmallRyeContext(dataFetchingEnvironment);
        }
        if (!smallRyeContext.hasRequest()) {
            throw new RuntimeException("Invalid context provided, can not populate data from Data Fetching Environment");
        }
        smallRyeContext.setDataFetchingEnvironment(dataFetchingEnvironment);
        smallRyeContext.setField(field);
        smallRyeContext.setArguments(dataFetchingEnvironment.getArguments());
        smallRyeContext.setPath(dataFetchingEnvironment.getExecutionStepInfo().getPath().toString());
        smallRyeContext.setExecutionId(dataFetchingEnvironment.getExecutionId().toString());
        smallRyeContext.setFieldName(dataFetchingEnvironment.getField().getName());
        smallRyeContext.setSource(dataFetchingEnvironment.getSource());
        smallRyeContext.setSelectedFields(SmallRyeContextManager.buildSelectedFields(type, dataFetchingEnvironment, field, false));
        smallRyeContext.setSelectedAndSourceFields(SmallRyeContextManager.buildSelectedFields(type, dataFetchingEnvironment, field, true));
        smallRyeContext.setOperationType(SmallRyeContextManager.getOperationTypeFromDefinition(dataFetchingEnvironment.getOperationDefinition()));
        smallRyeContext.setParentTypeName(SmallRyeContextManager.getGraphQLTypeName(dataFetchingEnvironment.getParentType()).orElse(null));
        if (smallRyeContext.getOperationName().isEmpty()) {
            smallRyeContext.setOperationName(SmallRyeContextManager.getOperationName(dataFetchingEnvironment));
        }
        GraphQLContext graphQLContext = dataFetchingEnvironment.getGraphQlContext();
        graphQLContext.put((Object)CONTEXT, (Object)smallRyeContext);
        current.set(smallRyeContext);
        return smallRyeContext;
    }

    private static Optional<String> getGraphQLTypeName(GraphQLType graphQLType) {
        if (graphQLType instanceof GraphQLNamedType) {
            return Optional.of(((GraphQLNamedType)graphQLType).getName());
        }
        if (graphQLType instanceof GraphQLNonNull) {
            return SmallRyeContextManager.getGraphQLTypeName(((GraphQLNonNull)graphQLType).getWrappedType());
        }
        if (graphQLType instanceof GraphQLList) {
            return SmallRyeContextManager.getGraphQLTypeName(((GraphQLList)graphQLType).getWrappedType());
        }
        return Optional.empty();
    }

    private static String getOperationTypeFromDefinition(OperationDefinition definition) {
        return definition.getOperation().toString();
    }

    private static JsonArray buildSelectedFields(Type type, DataFetchingEnvironment dfe, Field field, boolean includeSourceFields) {
        DataFetchingFieldSelectionSet selectionSet = dfe.getSelectionSet();
        LinkedHashSet<SelectedField> fields = new LinkedHashSet<SelectedField>(selectionSet.getFields());
        return SmallRyeContextManager.toJsonArrayBuilder(type, fields, field, includeSourceFields).build();
    }

    private static JsonArrayBuilder toJsonArrayBuilder(Type type, Set<SelectedField> fields, Field field, boolean includeSourceFields) {
        JsonArrayBuilder builder = jsonbuilder.createArrayBuilder();
        for (SelectedField selectedField : fields) {
            if (SmallRyeContextManager.isFlattenScalar(selectedField) || !includeSourceFields && SmallRyeContextManager.isSourceField(type, selectedField)) continue;
            if (SmallRyeContextManager.isScalar(selectedField)) {
                builder = builder.add(selectedField.getName());
                continue;
            }
            builder = builder.add(SmallRyeContextManager.toJsonObjectBuilder(type, selectedField, field, includeSourceFields));
        }
        return builder;
    }

    private static boolean isFlattenScalar(SelectedField field) {
        return field.getQualifiedName().contains("/");
    }

    private static JsonObjectBuilder toJsonObjectBuilder(Type type, SelectedField selectedField, Field field, boolean includeSourceFields) {
        JsonObjectBuilder builder = jsonbuilder.createObjectBuilder();
        LinkedHashSet<SelectedField> fields = new LinkedHashSet<SelectedField>(selectedField.getSelectionSet().getFields());
        builder = builder.add(selectedField.getName(), SmallRyeContextManager.toJsonArrayBuilder(type, fields, field, includeSourceFields));
        return builder;
    }

    private static boolean isSourceField(Type type, SelectedField selectedField) {
        String fieldName;
        Map sourceFields;
        if (type != null && type.hasOperations() && (sourceFields = type.getOperations()).containsKey(fieldName = selectedField.getName())) {
            Operation o = (Operation)sourceFields.get(fieldName);
            return o.isSourceField();
        }
        return false;
    }

    private static boolean isScalar(SelectedField field) {
        List fieldDefinitions = field.getFieldDefinitions();
        for (GraphQLFieldDefinition fieldDefinition : fieldDefinitions) {
            GraphQLType graphQLType = SmallRyeContextManager.unwrapGraphQLType((GraphQLType)fieldDefinition.getType());
            if (!SmallRyeContextManager.isScalar(graphQLType)) continue;
            return true;
        }
        return false;
    }

    private static boolean isScalar(GraphQLType gqlt) {
        return GraphQLScalarType.class.isAssignableFrom(gqlt.getClass());
    }

    private static GraphQLType unwrapGraphQLType(GraphQLType gqlt) {
        if (SmallRyeContextManager.isNonNull(gqlt)) {
            GraphQLNonNull graphQLNonNull = (GraphQLNonNull)gqlt;
            return SmallRyeContextManager.unwrapGraphQLType(graphQLNonNull.getWrappedType());
        }
        if (SmallRyeContextManager.isList(gqlt)) {
            GraphQLList graphQLList = (GraphQLList)gqlt;
            return SmallRyeContextManager.unwrapGraphQLType(graphQLList.getWrappedType());
        }
        return gqlt;
    }

    private static boolean isNonNull(GraphQLType gqlt) {
        return GraphQLNonNull.class.isAssignableFrom(gqlt.getClass());
    }

    private static boolean isList(GraphQLType gqlt) {
        return GraphQLList.class.isAssignableFrom(gqlt.getClass());
    }

    private static List<String> getRequestedOperationTypes(DocumentSupplier documentSupplier) {
        ArrayList<String> allRequestedTypes = new ArrayList<String>();
        if (documentSupplier != null) {
            Document document = documentSupplier.get();
            List definitions = document.getDefinitionsOfType(OperationDefinition.class);
            for (OperationDefinition definition : definitions) {
                String operationType = SmallRyeContextManager.getOperationTypeFromDefinition(definition);
                if (allRequestedTypes.contains(operationType)) continue;
                allRequestedTypes.add(operationType);
            }
        }
        return allRequestedTypes;
    }

    private static String getOperationName(JsonObject request) {
        if (request.containsKey((Object)"operationName") && request.get((Object)"operationName") != null && !((JsonValue)request.get((Object)"operationName")).getValueType().equals((Object)JsonValue.ValueType.NULL)) {
            return request.getString("operationName");
        }
        return null;
    }

    private static String getOperationName(DataFetchingEnvironment dataFetchingEnvironment) {
        if (dataFetchingEnvironment.getOperationDefinition() != null && dataFetchingEnvironment.getOperationDefinition().getName() != null && !dataFetchingEnvironment.getOperationDefinition().getName().isEmpty()) {
            return dataFetchingEnvironment.getOperationDefinition().getName();
        }
        return null;
    }
}

