package io.smallrye.faulttolerance.config;

import io.smallrye.faulttolerance.api.RetryWhen;
import io.smallrye.faulttolerance.autoconfig.FaultToleranceMethod;
import io.smallrye.faulttolerance.autoconfig.MethodDescriptor;
import io.smallrye.faulttolerance.basicconfig.ConfigUtil;
import java.lang.Class;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.Throwable;
import java.lang.annotation.Annotation;
import java.util.function.Predicate;
import org.eclipse.microprofile.config.Config;
import org.eclipse.microprofile.config.ConfigProvider;
import org.eclipse.microprofile.faulttolerance.exceptions.FaultToleranceDefinitionException;

/**
 * Automatically generated from the {@link RetryWhenConfig} config interface, do not modify.
 */
public final class RetryWhenConfigImpl implements RetryWhenConfig {
    private final Class<?> beanClass;

    private final MethodDescriptor method;

    /**
     * {@code true} if annotation was placed on a method; {@code false} if annotation was placed on a class.
     */
    private final boolean onMethod;

    /**
     * Description for the error message: a fully qualified method name.
     */
    private final String description;

    /**
     * Configuration key: either {@code <classname>/<methodname>} or {@code <classname>}.
     */
    private final String configKey;

    /**
     * Backing annotation instance. Used when runtime configuration doesn't override it.
     */
    private final RetryWhen instance;

    /**
     * Cached value of the {@code RetryWhen.result} annotation member; {@code null} if not looked up yet.
     */
    private Class<? extends Predicate<Object>> _result;

    /**
     * Cached value of the {@code RetryWhen.exception} annotation member; {@code null} if not looked up yet.
     */
    private Class<? extends Predicate<Throwable>> _exception;

    private RetryWhenConfigImpl(FaultToleranceMethod method) {
        this.beanClass = method.beanClass;
        this.method = method.method;
        this.onMethod = method.annotationsPresentDirectly.contains(RetryWhen.class);
        this.description = method.method.toString();
        this.configKey = onMethod ? method.method.declaringClass.getName() + "/" + method.method.name : method.method.declaringClass.getName();
        this.instance = method.retryWhen;
    }

    public static RetryWhenConfigImpl create(FaultToleranceMethod method) {
        if (method.retryWhen == null) {
            return null;
        }
        if (!ConfigUtil.isEnabled("retry-when.enabled", "RetryWhen/enabled", method.method)) {
            return null;
        }
        return new RetryWhenConfigImpl(method);
    }

    @Override
    public boolean isOnMethod() {
        return onMethod;
    }

    @Override
    public Class<?> beanClass() {
        return beanClass;
    }

    @Override
    public MethodDescriptor method() {
        return method;
    }

    @Override
    public Class<? extends Annotation> annotationType() {
        return RetryWhen.class;
    }

    @Override
    public Class<? extends Predicate<Object>> result() {
        if (_result == null) {
            Config config = ConfigProvider.getConfig();
             {
                // smallrye.faulttolerance."<configKey>".<annotation>.<member>
                String newKey = "smallrye.faulttolerance.\"" + this.configKey + "\".retry-when.result";
                // <configKey>/<annotation>/<member>
                String oldKey = this.configKey + "/RetryWhen/result";
                _result = config.getOptionalValue(newKey, Class.class).or(() -> config.getOptionalValue(oldKey, Class.class)).orElse(null);
            }
            if (_result == null) {
                // smallrye.faulttolerance.global.<annotation>.<member>
                String newKey = "smallrye.faulttolerance.global.retry-when.result";
                // <annotation>/<member>
                String oldKey = "RetryWhen/result";
                _result = config.getOptionalValue(newKey, Class.class).or(() -> config.getOptionalValue(oldKey, Class.class)).orElse(null);
            }
            if (_result == null) {
                // annotation value
                _result = instance.result();
            }
        }
        return _result;
    }

    @Override
    public Class<? extends Predicate<Throwable>> exception() {
        if (_exception == null) {
            Config config = ConfigProvider.getConfig();
             {
                // smallrye.faulttolerance."<configKey>".<annotation>.<member>
                String newKey = "smallrye.faulttolerance.\"" + this.configKey + "\".retry-when.exception";
                // <configKey>/<annotation>/<member>
                String oldKey = this.configKey + "/RetryWhen/exception";
                _exception = config.getOptionalValue(newKey, Class.class).or(() -> config.getOptionalValue(oldKey, Class.class)).orElse(null);
            }
            if (_exception == null) {
                // smallrye.faulttolerance.global.<annotation>.<member>
                String newKey = "smallrye.faulttolerance.global.retry-when.exception";
                // <annotation>/<member>
                String oldKey = "RetryWhen/exception";
                _exception = config.getOptionalValue(newKey, Class.class).or(() -> config.getOptionalValue(oldKey, Class.class)).orElse(null);
            }
            if (_exception == null) {
                // annotation value
                _exception = instance.exception();
            }
        }
        return _exception;
    }

    @Override
    public void materialize() {
        result();
        exception();
    }

    @Override
    public FaultToleranceDefinitionException fail(String reason) {
        return new FaultToleranceDefinitionException("Invalid @RetryWhen on " + description + ": " + reason);
    }

    @Override
    public FaultToleranceDefinitionException fail(String member, String reason) {
        return new FaultToleranceDefinitionException("Invalid @RetryWhen." + member + " on " + description + ": " + reason);
    }
}
