package io.smallrye.faulttolerance.config;

import io.smallrye.faulttolerance.api.BeforeRetry;
import io.smallrye.faulttolerance.api.BeforeRetryHandler;
import io.smallrye.faulttolerance.autoconfig.FaultToleranceMethod;
import io.smallrye.faulttolerance.autoconfig.MethodDescriptor;
import io.smallrye.faulttolerance.basicconfig.ConfigUtil;
import java.lang.Class;
import java.lang.Override;
import java.lang.String;
import java.lang.annotation.Annotation;
import org.eclipse.microprofile.config.Config;
import org.eclipse.microprofile.config.ConfigProvider;
import org.eclipse.microprofile.faulttolerance.exceptions.FaultToleranceDefinitionException;

/**
 * Automatically generated from the {@link BeforeRetryConfig} config interface, do not modify.
 */
public final class BeforeRetryConfigImpl implements BeforeRetryConfig {
    private final Class<?> beanClass;

    private final MethodDescriptor method;

    /**
     * {@code true} if annotation was placed on a method; {@code false} if annotation was placed on a class.
     */
    private final boolean onMethod;

    /**
     * Description for the error message: a fully qualified method name.
     */
    private final String description;

    /**
     * Configuration key: either {@code <classname>/<methodname>} or {@code <classname>}.
     */
    private final String configKey;

    /**
     * Backing annotation instance. Used when runtime configuration doesn't override it.
     */
    private final BeforeRetry instance;

    /**
     * Cached value of the {@code BeforeRetry.value} annotation member; {@code null} if not looked up yet.
     */
    private Class<? extends BeforeRetryHandler> _value;

    /**
     * Cached value of the {@code BeforeRetry.methodName} annotation member; {@code null} if not looked up yet.
     */
    private String _methodName;

    private BeforeRetryConfigImpl(FaultToleranceMethod method) {
        this.beanClass = method.beanClass;
        this.method = method.method;
        this.onMethod = method.annotationsPresentDirectly.contains(BeforeRetry.class);
        this.description = method.method.toString();
        this.configKey = onMethod ? method.method.declaringClass.getName() + "/" + method.method.name : method.method.declaringClass.getName();
        this.instance = method.beforeRetry;
    }

    public static BeforeRetryConfigImpl create(FaultToleranceMethod method) {
        if (method.beforeRetry == null) {
            return null;
        }
        if (!ConfigUtil.isEnabled("before-retry.enabled", "BeforeRetry/enabled", method.method)) {
            return null;
        }
        return new BeforeRetryConfigImpl(method);
    }

    @Override
    public boolean isOnMethod() {
        return onMethod;
    }

    @Override
    public Class<?> beanClass() {
        return beanClass;
    }

    @Override
    public MethodDescriptor method() {
        return method;
    }

    @Override
    public Class<? extends Annotation> annotationType() {
        return BeforeRetry.class;
    }

    @Override
    public Class<? extends BeforeRetryHandler> value() {
        if (_value == null) {
            Config config = ConfigProvider.getConfig();
             {
                // smallrye.faulttolerance."<configKey>".<annotation>.<member>
                String newKey = "smallrye.faulttolerance.\"" + this.configKey + "\".before-retry.value";
                // <configKey>/<annotation>/<member>
                String oldKey = this.configKey + "/BeforeRetry/value";
                _value = config.getOptionalValue(newKey, Class.class).or(() -> config.getOptionalValue(oldKey, Class.class)).orElse(null);
            }
            if (_value == null) {
                // smallrye.faulttolerance.global.<annotation>.<member>
                String newKey = "smallrye.faulttolerance.global.before-retry.value";
                // <annotation>/<member>
                String oldKey = "BeforeRetry/value";
                _value = config.getOptionalValue(newKey, Class.class).or(() -> config.getOptionalValue(oldKey, Class.class)).orElse(null);
            }
            if (_value == null) {
                // annotation value
                _value = instance.value();
            }
        }
        return _value;
    }

    @Override
    public String methodName() {
        if (_methodName == null) {
            Config config = ConfigProvider.getConfig();
             {
                // smallrye.faulttolerance."<configKey>".<annotation>.<member>
                String newKey = "smallrye.faulttolerance.\"" + this.configKey + "\".before-retry.method-name";
                // <configKey>/<annotation>/<member>
                String oldKey = this.configKey + "/BeforeRetry/methodName";
                _methodName = config.getOptionalValue(newKey, String.class).or(() -> config.getOptionalValue(oldKey, String.class)).orElse(null);
            }
            if (_methodName == null) {
                // smallrye.faulttolerance.global.<annotation>.<member>
                String newKey = "smallrye.faulttolerance.global.before-retry.method-name";
                // <annotation>/<member>
                String oldKey = "BeforeRetry/methodName";
                _methodName = config.getOptionalValue(newKey, String.class).or(() -> config.getOptionalValue(oldKey, String.class)).orElse(null);
            }
            if (_methodName == null) {
                // annotation value
                _methodName = instance.methodName();
            }
        }
        return _methodName;
    }

    @Override
    public void materialize() {
        value();
        methodName();
    }

    @Override
    public FaultToleranceDefinitionException fail(String reason) {
        return new FaultToleranceDefinitionException("Invalid @BeforeRetry on " + description + ": " + reason);
    }

    @Override
    public FaultToleranceDefinitionException fail(String member, String reason) {
        return new FaultToleranceDefinitionException("Invalid @BeforeRetry." + member + " on " + description + ": " + reason);
    }
}
