package io.smallrye.faulttolerance.config;

import io.smallrye.faulttolerance.api.ApplyFaultTolerance;
import io.smallrye.faulttolerance.autoconfig.FaultToleranceMethod;
import io.smallrye.faulttolerance.autoconfig.MethodDescriptor;
import io.smallrye.faulttolerance.basicconfig.ConfigUtil;
import java.lang.Class;
import java.lang.Override;
import java.lang.String;
import java.lang.annotation.Annotation;
import org.eclipse.microprofile.config.Config;
import org.eclipse.microprofile.config.ConfigProvider;
import org.eclipse.microprofile.faulttolerance.exceptions.FaultToleranceDefinitionException;

/**
 * Automatically generated from the {@link ApplyFaultToleranceConfig} config interface, do not modify.
 */
public final class ApplyFaultToleranceConfigImpl implements ApplyFaultToleranceConfig {
    private final Class<?> beanClass;

    private final MethodDescriptor method;

    /**
     * {@code true} if annotation was placed on a method; {@code false} if annotation was placed on a class.
     */
    private final boolean onMethod;

    /**
     * Description for the error message: a fully qualified method name.
     */
    private final String description;

    /**
     * Configuration key: either {@code <classname>/<methodname>} or {@code <classname>}.
     */
    private final String configKey;

    /**
     * Backing annotation instance. Used when runtime configuration doesn't override it.
     */
    private final ApplyFaultTolerance instance;

    /**
     * Cached value of the {@code ApplyFaultTolerance.value} annotation member; {@code null} if not looked up yet.
     */
    private String _value;

    private ApplyFaultToleranceConfigImpl(FaultToleranceMethod method) {
        this.beanClass = method.beanClass;
        this.method = method.method;
        this.onMethod = method.annotationsPresentDirectly.contains(ApplyFaultTolerance.class);
        this.description = method.method.toString();
        this.configKey = onMethod ? method.method.declaringClass.getName() + "/" + method.method.name : method.method.declaringClass.getName();
        this.instance = method.applyFaultTolerance;
    }

    public static ApplyFaultToleranceConfigImpl create(FaultToleranceMethod method) {
        if (method.applyFaultTolerance == null) {
            return null;
        }
        if (!ConfigUtil.isEnabled("apply-fault-tolerance.enabled", "ApplyFaultTolerance/enabled", method.method)) {
            return null;
        }
        return new ApplyFaultToleranceConfigImpl(method);
    }

    @Override
    public boolean isOnMethod() {
        return onMethod;
    }

    @Override
    public Class<?> beanClass() {
        return beanClass;
    }

    @Override
    public MethodDescriptor method() {
        return method;
    }

    @Override
    public Class<? extends Annotation> annotationType() {
        return ApplyFaultTolerance.class;
    }

    @Override
    public String value() {
        if (_value == null) {
            Config config = ConfigProvider.getConfig();
             {
                // <configKey>/<annotation>/<member>
                String key = this.configKey + "/ApplyFaultTolerance/value";
                _value = config.getOptionalValue(key, String.class).orElse(null);
            }
            if (_value == null) {
                // <annotation>/<member>
                String key = "ApplyFaultTolerance/value";
                _value = config.getOptionalValue(key, String.class).orElse(null);
            }
            if (_value == null) {
                // annotation value
                _value = instance.value();
            }
        }
        return _value;
    }

    @Override
    public void materialize() {
        value();
    }

    @Override
    public FaultToleranceDefinitionException fail(String reason) {
        return new FaultToleranceDefinitionException("Invalid @ApplyFaultTolerance on " + description + ": " + reason);
    }

    @Override
    public FaultToleranceDefinitionException fail(String member, String reason) {
        return new FaultToleranceDefinitionException("Invalid @ApplyFaultTolerance." + member + " on " + description + ": " + reason);
    }
}
