package io.smallrye.faulttolerance.basicconfig;

import java.lang.Class;
import java.lang.Override;
import java.lang.String;
import java.lang.Throwable;
import java.lang.annotation.Annotation;
import java.time.temporal.ChronoUnit;
import java.util.function.Supplier;
import org.eclipse.microprofile.faulttolerance.Retry;
import org.eclipse.microprofile.faulttolerance.exceptions.FaultToleranceDefinitionException;

/**
 * Automatically generated from the {@link RetryConfig} config interface, do not modify.
 */
public final class RetryNoConfigImpl implements RetryConfig {
    /**
     * Backing annotation instance.
     */
    private final Retry instance;

    private RetryNoConfigImpl(Retry instance) {
        this.instance = instance;
    }

    public static RetryNoConfigImpl create(Supplier<Retry> supplier) {
        if (supplier == null) {
            return null;
        }
        return new RetryNoConfigImpl(supplier.get());
    }

    @Override
    public Class<? extends Annotation> annotationType() {
        return Retry.class;
    }

    @Override
    public int maxRetries() {
        return instance.maxRetries();
    }

    @Override
    public long delay() {
        return instance.delay();
    }

    @Override
    public ChronoUnit delayUnit() {
        return instance.delayUnit();
    }

    @Override
    public long maxDuration() {
        return instance.maxDuration();
    }

    @Override
    public ChronoUnit durationUnit() {
        return instance.durationUnit();
    }

    @Override
    public long jitter() {
        return instance.jitter();
    }

    @Override
    public ChronoUnit jitterDelayUnit() {
        return instance.jitterDelayUnit();
    }

    @Override
    public Class<? extends Throwable>[] retryOn() {
        return instance.retryOn();
    }

    @Override
    public Class<? extends Throwable>[] abortOn() {
        return instance.abortOn();
    }

    @Override
    public void materialize() {
        // no config, no need to materialize
    }

    @Override
    public FaultToleranceDefinitionException fail(String reason) {
        return new FaultToleranceDefinitionException("Invalid @Retry: " + reason);
    }

    @Override
    public FaultToleranceDefinitionException fail(String member, String reason) {
        return new FaultToleranceDefinitionException("Invalid @Retry." + member + ": " + reason);
    }
}
