package io.smallrye.faulttolerance.basicconfig;

import io.smallrye.faulttolerance.api.RateLimit;
import io.smallrye.faulttolerance.api.RateLimitType;
import java.lang.Class;
import java.lang.Override;
import java.lang.String;
import java.lang.annotation.Annotation;
import java.time.temporal.ChronoUnit;
import java.util.function.Supplier;
import org.eclipse.microprofile.faulttolerance.exceptions.FaultToleranceDefinitionException;

/**
 * Automatically generated from the {@link RateLimitConfig} config interface, do not modify.
 */
public final class RateLimitNoConfigImpl implements RateLimitConfig {
    /**
     * Backing annotation instance.
     */
    private final RateLimit instance;

    private RateLimitNoConfigImpl(RateLimit instance) {
        this.instance = instance;
    }

    public static RateLimitNoConfigImpl create(Supplier<RateLimit> supplier) {
        if (supplier == null) {
            return null;
        }
        return new RateLimitNoConfigImpl(supplier.get());
    }

    @Override
    public Class<? extends Annotation> annotationType() {
        return RateLimit.class;
    }

    @Override
    public int value() {
        return instance.value();
    }

    @Override
    public long window() {
        return instance.window();
    }

    @Override
    public ChronoUnit windowUnit() {
        return instance.windowUnit();
    }

    @Override
    public long minSpacing() {
        return instance.minSpacing();
    }

    @Override
    public ChronoUnit minSpacingUnit() {
        return instance.minSpacingUnit();
    }

    @Override
    public RateLimitType type() {
        return instance.type();
    }

    @Override
    public void materialize() {
        // no config, no need to materialize
    }

    @Override
    public FaultToleranceDefinitionException fail(String reason) {
        return new FaultToleranceDefinitionException("Invalid @RateLimit: " + reason);
    }

    @Override
    public FaultToleranceDefinitionException fail(String member, String reason) {
        return new FaultToleranceDefinitionException("Invalid @RateLimit." + member + ": " + reason);
    }
}
