package io.smallrye.faulttolerance.basicconfig;

import io.smallrye.faulttolerance.api.FibonacciBackoff;
import java.lang.Class;
import java.lang.Override;
import java.lang.String;
import java.lang.annotation.Annotation;
import java.time.temporal.ChronoUnit;
import java.util.function.Supplier;
import org.eclipse.microprofile.faulttolerance.exceptions.FaultToleranceDefinitionException;

/**
 * Automatically generated from the {@link FibonacciBackoffConfig} config interface, do not modify.
 */
public final class FibonacciBackoffNoConfigImpl implements FibonacciBackoffConfig {
    /**
     * Backing annotation instance.
     */
    private final FibonacciBackoff instance;

    private FibonacciBackoffNoConfigImpl(FibonacciBackoff instance) {
        this.instance = instance;
    }

    public static FibonacciBackoffNoConfigImpl create(Supplier<FibonacciBackoff> supplier) {
        if (supplier == null) {
            return null;
        }
        return new FibonacciBackoffNoConfigImpl(supplier.get());
    }

    @Override
    public Class<? extends Annotation> annotationType() {
        return FibonacciBackoff.class;
    }

    @Override
    public long maxDelay() {
        return instance.maxDelay();
    }

    @Override
    public ChronoUnit maxDelayUnit() {
        return instance.maxDelayUnit();
    }

    @Override
    public void materialize() {
        // no config, no need to materialize
    }

    @Override
    public FaultToleranceDefinitionException fail(String reason) {
        return new FaultToleranceDefinitionException("Invalid @FibonacciBackoff: " + reason);
    }

    @Override
    public FaultToleranceDefinitionException fail(String member, String reason) {
        return new FaultToleranceDefinitionException("Invalid @FibonacciBackoff." + member + ": " + reason);
    }
}
