package io.smallrye.faulttolerance.basicconfig;

import io.smallrye.faulttolerance.api.FibonacciBackoff;
import io.smallrye.faulttolerance.autoconfig.FaultToleranceMethod;
import java.lang.Class;
import java.lang.Long;
import java.lang.Override;
import java.lang.String;
import java.lang.annotation.Annotation;
import java.time.temporal.ChronoUnit;
import java.util.function.Supplier;
import org.eclipse.microprofile.config.Config;
import org.eclipse.microprofile.config.ConfigProvider;
import org.eclipse.microprofile.faulttolerance.exceptions.FaultToleranceDefinitionException;

/**
 * Automatically generated from the {@link FibonacciBackoffConfig} config interface, do not modify.
 */
public final class FibonacciBackoffConfigImpl implements FibonacciBackoffConfig {
    /**
     * Description for the error message: a fully qualified method name or identifier.
     */
    private final String description;

    /**
     * Configuration key: either {@code <classname>/<methodname>} or {@code <classname>} or {@code <id>}.
     */
    private final String configKey;

    /**
     * Backing annotation instance. Used when runtime configuration doesn't override it.
     */
    private final FibonacciBackoff instance;

    /**
     * Cached value of the {@code FibonacciBackoff.maxDelay} annotation member; {@code null} if not looked up yet.
     */
    private Long _maxDelay;

    /**
     * Cached value of the {@code FibonacciBackoff.maxDelayUnit} annotation member; {@code null} if not looked up yet.
     */
    private ChronoUnit _maxDelayUnit;

    private FibonacciBackoffConfigImpl(FaultToleranceMethod method) {
        boolean onMethod = method.annotationsPresentDirectly.contains(FibonacciBackoff.class);
        this.description = method.method.toString();
        this.configKey = onMethod ? method.method.declaringClass.getName() + "/" + method.method.name : method.method.declaringClass.getName();
        this.instance = method.fibonacciBackoff;
    }

    private FibonacciBackoffConfigImpl(String id, FibonacciBackoff instance) {
        this.description = "Guard with @Identifier(" + id + ")";
        this.configKey = id;
        this.instance = instance;
    }

    public static FibonacciBackoffConfigImpl create(FaultToleranceMethod method) {
        if (method.fibonacciBackoff == null) {
            return null;
        }
        if (!ConfigUtil.isEnabled("fibonacci-backoff.enabled", "FibonacciBackoff/enabled", method.method)) {
            return null;
        }
        return new FibonacciBackoffConfigImpl(method);
    }

    public static FibonacciBackoffConfigImpl create(String id,
            Supplier<FibonacciBackoff> supplier) {
        if (supplier == null) {
            return null;
        }
        if (!ConfigUtil.isEnabled("fibonacci-backoff.enabled", "FibonacciBackoff/enabled", id)) {
            return null;
        }
        return new FibonacciBackoffConfigImpl(id, supplier.get());
    }

    @Override
    public Class<? extends Annotation> annotationType() {
        return FibonacciBackoff.class;
    }

    @Override
    public long maxDelay() {
        if (_maxDelay == null) {
            Config config = ConfigProvider.getConfig();
             {
                // smallrye.faulttolerance."<configKey>".<annotation>.<member>
                String newKey = "smallrye.faulttolerance.\"" + this.configKey + "\".fibonacci-backoff.max-delay";
                // <configKey>/<annotation>/<member>
                String oldKey = this.configKey + "/FibonacciBackoff/maxDelay";
                _maxDelay = config.getOptionalValue(newKey, long.class).or(() -> config.getOptionalValue(oldKey, long.class)).orElse(null);
            }
            if (_maxDelay == null) {
                // smallrye.faulttolerance.global.<annotation>.<member>
                String newKey = "smallrye.faulttolerance.global.fibonacci-backoff.max-delay";
                // <annotation>/<member>
                String oldKey = "FibonacciBackoff/maxDelay";
                _maxDelay = config.getOptionalValue(newKey, long.class).or(() -> config.getOptionalValue(oldKey, long.class)).orElse(null);
            }
            if (_maxDelay == null) {
                // annotation value
                _maxDelay = instance.maxDelay();
            }
        }
        return _maxDelay;
    }

    @Override
    public ChronoUnit maxDelayUnit() {
        if (_maxDelayUnit == null) {
            Config config = ConfigProvider.getConfig();
             {
                // smallrye.faulttolerance."<configKey>".<annotation>.<member>
                String newKey = "smallrye.faulttolerance.\"" + this.configKey + "\".fibonacci-backoff.max-delay-unit";
                // <configKey>/<annotation>/<member>
                String oldKey = this.configKey + "/FibonacciBackoff/maxDelayUnit";
                _maxDelayUnit = config.getOptionalValue(newKey, ChronoUnit.class).or(() -> config.getOptionalValue(oldKey, ChronoUnit.class)).orElse(null);
            }
            if (_maxDelayUnit == null) {
                // smallrye.faulttolerance.global.<annotation>.<member>
                String newKey = "smallrye.faulttolerance.global.fibonacci-backoff.max-delay-unit";
                // <annotation>/<member>
                String oldKey = "FibonacciBackoff/maxDelayUnit";
                _maxDelayUnit = config.getOptionalValue(newKey, ChronoUnit.class).or(() -> config.getOptionalValue(oldKey, ChronoUnit.class)).orElse(null);
            }
            if (_maxDelayUnit == null) {
                // annotation value
                _maxDelayUnit = instance.maxDelayUnit();
            }
        }
        return _maxDelayUnit;
    }

    @Override
    public void materialize() {
        maxDelay();
        maxDelayUnit();
    }

    @Override
    public FaultToleranceDefinitionException fail(String reason) {
        return new FaultToleranceDefinitionException("Invalid @FibonacciBackoff on " + description + ": " + reason);
    }

    @Override
    public FaultToleranceDefinitionException fail(String member, String reason) {
        return new FaultToleranceDefinitionException("Invalid @FibonacciBackoff." + member + " on " + description + ": " + reason);
    }
}
