package io.smallrye.faulttolerance.basicconfig;

import java.lang.Class;
import java.lang.Override;
import java.lang.String;
import java.lang.annotation.Annotation;
import java.util.function.Supplier;
import org.eclipse.microprofile.faulttolerance.Bulkhead;
import org.eclipse.microprofile.faulttolerance.exceptions.FaultToleranceDefinitionException;

/**
 * Automatically generated from the {@link BulkheadConfig} config interface, do not modify.
 */
public final class BulkheadNoConfigImpl implements BulkheadConfig {
    /**
     * Backing annotation instance.
     */
    private final Bulkhead instance;

    private BulkheadNoConfigImpl(Bulkhead instance) {
        this.instance = instance;
    }

    public static BulkheadNoConfigImpl create(Supplier<Bulkhead> supplier) {
        if (supplier == null) {
            return null;
        }
        return new BulkheadNoConfigImpl(supplier.get());
    }

    @Override
    public Class<? extends Annotation> annotationType() {
        return Bulkhead.class;
    }

    @Override
    public int value() {
        return instance.value();
    }

    @Override
    public int waitingTaskQueue() {
        return instance.waitingTaskQueue();
    }

    @Override
    public void materialize() {
        // no config, no need to materialize
    }

    @Override
    public FaultToleranceDefinitionException fail(String reason) {
        return new FaultToleranceDefinitionException("Invalid @Bulkhead: " + reason);
    }

    @Override
    public FaultToleranceDefinitionException fail(String member, String reason) {
        return new FaultToleranceDefinitionException("Invalid @Bulkhead." + member + ": " + reason);
    }
}
