/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.config;

import io.smallrye.config.Converters;
import io.smallrye.config.ImplicitConverters;
import io.smallrye.config.StringUtil;
import java.io.Serializable;
import java.lang.reflect.Array;
import java.lang.reflect.Type;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Optional;
import org.eclipse.microprofile.config.Config;
import org.eclipse.microprofile.config.spi.ConfigSource;
import org.eclipse.microprofile.config.spi.Converter;

public class SmallRyeConfig
implements Config,
Serializable {
    private final List<ConfigSource> configSources;
    private Map<Type, Converter> converters;

    protected SmallRyeConfig(List<ConfigSource> configSources, Map<Type, Converter> converters) {
        this.configSources = configSources;
        this.converters = new HashMap<Type, Converter>(Converters.ALL_CONVERTERS);
        this.converters.putAll(converters);
    }

    public <T> T getValue(String name, Class<T> aClass) {
        for (ConfigSource configSource : this.configSources) {
            String value = configSource.getValue(name);
            if (value == null) continue;
            return this.convert(value, aClass);
        }
        throw new NoSuchElementException("Property " + name + " not found");
    }

    public <T> Optional<T> getOptionalValue(String name, Class<T> aClass) {
        for (ConfigSource configSource : this.configSources) {
            String value = configSource.getValue(name);
            if (value == null || value.length() <= 0) continue;
            return Optional.of(this.convert(value, aClass));
        }
        return Optional.empty();
    }

    public Iterable<String> getPropertyNames() {
        HashSet<String> names = new HashSet<String>();
        for (ConfigSource configSource : this.configSources) {
            names.addAll(configSource.getProperties().keySet());
        }
        return names;
    }

    public Iterable<ConfigSource> getConfigSources() {
        return this.configSources;
    }

    public <T> T convert(String value, Class<T> asType) {
        if (value != null) {
            boolean isArray = asType.isArray();
            if (isArray) {
                String[] split = StringUtil.split(value);
                Class<?> componentType = asType.getComponentType();
                Object array = Array.newInstance(componentType, split.length);
                Converter converter = this.getConverter(asType);
                for (int i = 0; i < split.length; ++i) {
                    Object s = converter.convert(split[i]);
                    Array.set(array, i, s);
                }
                return (T)array;
            }
            Converter converter = this.getConverter(asType);
            return (T)converter.convert(value);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected <T> Converter getConverter(Class<T> asType) {
        if (asType.isArray()) {
            return this.getConverter(asType.getComponentType());
        }
        Converter converter = this.converters.get(asType);
        if (converter == null) {
            Map<Type, Converter> map = this.converters;
            synchronized (map) {
                converter = ImplicitConverters.getConverter(asType);
                this.converters.putIfAbsent(asType, converter);
            }
        }
        if (converter == null) {
            throw new IllegalArgumentException("No Converter registered for class " + asType);
        }
        return converter;
    }
}

