|Attribute (_alias_) | Description | Type   | Mandatory | Default |
| :---               | :----       | :----: | :----:    | :---    |
| *arguments* | A comma-separated list of arguments [key1:value1,key2:value2,...] to bind the queue to the exchange. Relevant only if 'exchange.type' is headers | string | false |  |
| *auto-acknowledgement* | Whether the received RabbitMQ messages must be acknowledged when received; if true then delivery constitutes acknowledgement | boolean | false | `false` |
| *auto-bind-dlq* | Whether to automatically declare the DLQ and bind it to the binder DLX | boolean | false | `false` |
| *automatic-recovery-enabled* | Whether automatic connection recovery is enabled | boolean | false | `false` |
| *automatic-recovery-on-initial-connection* | Whether automatic recovery on initial connections is enabled | boolean | false | `true` |
| *broadcast* | Whether the received RabbitMQ messages must be dispatched to multiple _subscribers_ | boolean | false | `false` |
| *client-options-name* _(rabbitmq-client-options-name)_ | The name of the RabbitMQ Client Option bean used to customize the RabbitMQ client configuration | string | false |  |
| *connection-count* | The number of RabbitMQ connections to create for consuming from this queue. This might be necessary to consume from a sharded queue with a single client. | int | false | `1` |
| *connection-timeout* | The TCP connection timeout (ms); 0 is interpreted as no timeout | int | false | `60000` |
| *content-type-override* | Override the content_type attribute of the incoming message, should be a valid MINE type | string | false |  |
| *credentials-provider-name* _(rabbitmq-credentials-provider-name)_ | The name of the RabbitMQ Credentials Provider bean used to provide dynamic credentials to the RabbitMQ client | string | false |  |
| *dead-letter-dlx* | If specified, a DLX to assign to the DLQ. Relevant only if auto-bind-dlq is true | string | false |  |
| *dead-letter-dlx-routing-key* | If specified, a dead letter routing key to assign to the DLQ. Relevant only if auto-bind-dlq is true | string | false |  |
| *dead-letter-exchange* | A DLX to assign to the queue. Relevant only if auto-bind-dlq is true | string | false | `DLX` |
| *dead-letter-exchange-type* | The type of the DLX to assign to the queue. Relevant only if auto-bind-dlq is true | string | false | `direct` |
| *dead-letter-queue-mode* | If automatically declare DLQ, we can choose different modes of DLQ [lazy, default] | string | false |  |
| *dead-letter-queue-name* | The name of the DLQ; if not supplied will default to the queue name with '.dlq' appended | string | false |  |
| *dead-letter-queue-type* | If automatically declare DLQ, we can choose different types of DLQ [quorum, classic, stream] | string | false |  |
| *dead-letter-routing-key* | A dead letter routing key to assign to the queue; if not supplied will default to the queue name | string | false |  |
| *dead-letter-ttl* | If specified, the time (ms) for which a message can remain in DLQ undelivered before it is dead. Relevant only if auto-bind-dlq is true | long | false |  |
| *dlx.declare* | Whether to declare the dead letter exchange binding. Relevant only if auto-bind-dlq is true; set to false if these are expected to be set up independently | boolean | false | `false` |
| *exchange.auto-delete* | Whether the exchange should be deleted after use | boolean | false | `false` |
| *exchange.declare* | Whether to declare the exchange; set to false if the exchange is expected to be set up independently | boolean | false | `true` |
| *exchange.durable* | Whether the exchange is durable | boolean | false | `true` |
| *exchange.name* | The exchange that messages are published to or consumed from. If not set, the channel name is used. If set to "", the default exchange is used. | string | false |  |
| *exchange.type* | The exchange type: direct, fanout, headers or topic (default) | string | false | `topic` |
| *failure-strategy* | The failure strategy to apply when a RabbitMQ message is nacked. Accepted values are `fail`, `accept`, `reject` (default), `requeue` or name of a bean | string | false | `reject` |
| *handshake-timeout* | The AMQP 0-9-1 protocol handshake timeout (ms) | int | false | `10000` |
| *host* _(rabbitmq-host)_ | The broker hostname | string | false | `localhost` |
| *include-properties* | Whether to include properties when a broker message is passed on the event bus | boolean | false | `false` |
| *keep-most-recent* | Whether to discard old messages instead of recent ones | boolean | false | `false` |
| *max-incoming-internal-queue-size* | The maximum size of the incoming internal queue | int | false | `500000` |
| *max-outstanding-messages* | The maximum number of outstanding/unacknowledged messages being processed by the connector at a time; must be a positive number | int | false |  |
| *network-recovery-interval* | How long (ms) will automatic recovery wait before attempting to reconnect | int | false | `5000` |
| *password* _(rabbitmq-password)_ | The password used to authenticate to the broker | string | false |  |
| *port* _(rabbitmq-port)_ | The broker port | int | false | `5672` |
| *queue.auto-delete* | Whether the queue should be deleted after use | boolean | false | `false` |
| *queue.declare* | Whether to declare the queue and binding; set to false if these are expected to be set up independently | boolean | false | `true` |
| *queue.durable* | Whether the queue is durable | boolean | false | `true` |
| *queue.exclusive* | Whether the queue is for exclusive use | boolean | false | `false` |
| *queue.name* | The queue from which messages are consumed. | string | true |  |
| *queue.single-active-consumer* | If set to true, only one consumer can actively consume messages | boolean | false |  |
| *queue.ttl* | If specified, the time (ms) for which a message can remain in the queue undelivered before it is dead | long | false |  |
| *queue.x-delivery-limit* | If queue.x-queue-type is quorum, when a message has been returned more times than the limit the message will be dropped or dead-lettered | long | false |  |
| *queue.x-max-priority* | Define priority level queue consumer | int | false |  |
| *queue.x-queue-mode* | If automatically declare queue, we can choose different modes of queue [lazy, default] | string | false |  |
| *queue.x-queue-type* | If automatically declare queue, we can choose different types of queue [quorum, classic, stream] | string | false |  |
| *reconnect-attempts* _(rabbitmq-reconnect-attempts)_ | The number of reconnection attempts | int | false | `100` |
| *reconnect-interval* _(rabbitmq-reconnect-interval)_ | The interval (in seconds) between two reconnection attempts | int | false | `10` |
| *requested-channel-max* | The initially requested maximum channel number | int | false | `2047` |
| *requested-heartbeat* | The initially requested heartbeat interval (seconds), zero for none | int | false | `60` |
| *routing-keys* | A comma-separated list of routing keys to bind the queue to the exchange. Relevant only if 'exchange.type' is topic or direct | string | false | `#` |
| *ssl* _(rabbitmq-ssl)_ | Whether or not the connection should use SSL | boolean | false | `false` |
| *tracing.attribute-headers* | A comma-separated list of headers that should be recorded as span attributes. Relevant only if tracing.enabled=true | string | false | `` |
| *tracing.enabled* | Whether tracing is enabled (default) or disabled | boolean | false | `true` |
| *trust-all* _(rabbitmq-trust-all)_ | Whether to skip trust certificate verification | boolean | false | `false` |
| *trust-store-password* _(rabbitmq-trust-store-password)_ | The password of the JKS trust store | string | false |  |
| *trust-store-path* _(rabbitmq-trust-store-path)_ | The path to a JKS trust store | string | false |  |
| *use-nio* | Whether usage of NIO Sockets is enabled | boolean | false | `false` |
| *user* | The user name to use when connecting to the broker | string | false | `guest` |
| *username* _(rabbitmq-username)_ | The username used to authenticate to the broker | string | false |  |
| *virtual-host* _(rabbitmq-virtual-host)_ | The virtual host to use when connecting to the broker | string | false | `/` |
