/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.reactive.messaging.providers.extension;

import io.smallrye.mutiny.Multi;
import io.smallrye.mutiny.Uni;
import io.smallrye.reactive.messaging.ChannelRegistry;
import io.smallrye.reactive.messaging.MessageConverter;
import io.smallrye.reactive.messaging.MutinyEmitter;
import io.smallrye.reactive.messaging.annotations.Emitter;
import io.smallrye.reactive.messaging.providers.helpers.ConverterUtils;
import io.smallrye.reactive.messaging.providers.helpers.MultiUtils;
import io.smallrye.reactive.messaging.providers.helpers.TypeUtils;
import io.smallrye.reactive.messaging.providers.i18n.ProviderExceptions;
import jakarta.enterprise.context.ApplicationScoped;
import jakarta.enterprise.inject.Instance;
import jakarta.enterprise.inject.Produces;
import jakarta.enterprise.inject.Typed;
import jakarta.enterprise.inject.spi.InjectionPoint;
import jakarta.inject.Inject;
import java.lang.annotation.Annotation;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.List;
import java.util.concurrent.Flow;
import java.util.stream.Collectors;
import mutiny.zero.flow.adapters.AdaptersToReactiveStreams;
import org.eclipse.microprofile.reactive.messaging.Channel;
import org.eclipse.microprofile.reactive.messaging.Message;
import org.eclipse.microprofile.reactive.streams.operators.PublisherBuilder;
import org.eclipse.microprofile.reactive.streams.operators.ReactiveStreams;
import org.reactivestreams.Publisher;

@ApplicationScoped
public class ChannelProducer {
    @Inject
    ChannelRegistry channelRegistry;
    @Inject
    Instance<MessageConverter> converters;

    @Produces
    @Typed(value={Flow.Publisher.class, Multi.class})
    @Channel(value="")
    <T> Multi<T> produceMulti(InjectionPoint injectionPoint) {
        Type first = this.getFirstParameter(injectionPoint.getType());
        if (TypeUtils.isAssignable(first, Message.class)) {
            Type payloadType = this.getPayloadParameterFromMessageType(first);
            if (payloadType == null) {
                return (Multi)ChannelProducer.cast(this.getPublisher(injectionPoint));
            }
            return (Multi)ChannelProducer.cast(ConverterUtils.convert(this.getPublisher(injectionPoint), this.converters, this.getRawTypeIfParameterized(payloadType)));
        }
        return (Multi)ChannelProducer.cast(ConverterUtils.convert(this.getPublisher(injectionPoint), this.converters, this.getRawTypeIfParameterized(first)).onItem().call(m -> Uni.createFrom().completionStage(m.ack())).onItem().transform(Message::getPayload).broadcast().toAllSubscribers());
    }

    @Produces
    @Typed(value={Publisher.class})
    @Channel(value="")
    <T> Publisher<T> producePublisher(InjectionPoint injectionPoint) {
        return AdaptersToReactiveStreams.publisher(this.produceMulti(injectionPoint));
    }

    @Produces
    @Deprecated
    @Typed(value={Flow.Publisher.class, Multi.class})
    @io.smallrye.reactive.messaging.annotations.Channel(value="")
    <T> Multi<T> produceMultiWithLegacyChannelAnnotation(InjectionPoint injectionPoint) {
        return this.produceMulti(injectionPoint);
    }

    @Produces
    @Deprecated
    @Typed(value={Publisher.class})
    @io.smallrye.reactive.messaging.annotations.Channel(value="")
    <T> Publisher<T> producePublisherWithLegacyChannelAnnotation(InjectionPoint injectionPoint) {
        return this.producePublisher(injectionPoint);
    }

    @Produces
    @Channel(value="")
    <T> PublisherBuilder<T> producePublisherBuilder(InjectionPoint injectionPoint) {
        return ReactiveStreams.fromPublisher(this.producePublisher(injectionPoint));
    }

    @Produces
    @io.smallrye.reactive.messaging.annotations.Channel(value="")
    <T> PublisherBuilder<T> producePublisherBuilderWithLegacyChannelAnnotation(InjectionPoint injectionPoint) {
        return this.producePublisherBuilder(injectionPoint);
    }

    @Produces
    @Channel(value="")
    <T> org.eclipse.microprofile.reactive.messaging.Emitter<T> produceEmitter(InjectionPoint injectionPoint) {
        this.verify(injectionPoint);
        return (org.eclipse.microprofile.reactive.messaging.Emitter)this.getEmitter(injectionPoint);
    }

    @Produces
    @Channel(value="")
    <T> MutinyEmitter<T> produceMutinyEmitter(InjectionPoint injectionPoint) {
        this.verify(injectionPoint);
        return (MutinyEmitter)this.getEmitter(injectionPoint);
    }

    @Produces
    @io.smallrye.reactive.messaging.annotations.Channel(value="")
    <T> Emitter<T> produceEmitterLegacy(InjectionPoint injectionPoint) {
        return (Emitter)this.getEmitter(injectionPoint);
    }

    private Multi<? extends Message<?>> getPublisher(InjectionPoint injectionPoint) {
        String name = ChannelProducer.getChannelName(injectionPoint);
        return Multi.createFrom().deferred(() -> {
            List list = this.channelRegistry.getPublishers(name);
            if (list.isEmpty()) {
                throw ProviderExceptions.ex.illegalStateForStream(name, this.channelRegistry.getIncomingNames());
            }
            if (list.size() == 1) {
                return MultiUtils.publisher((Flow.Publisher)list.get(0));
            }
            return Multi.createBy().merging().streams((Iterable)list.stream().map(p -> p).collect(Collectors.toList()));
        });
    }

    private <T> T getEmitter(InjectionPoint injectionPoint) {
        String name = ChannelProducer.getChannelName(injectionPoint);
        Object emitter = this.channelRegistry.getEmitter(name, (Class)this.getRawTypeIfParameterized(injectionPoint.getType()));
        if (emitter == null) {
            throw ProviderExceptions.ex.incomingNotFoundForEmitter(name);
        }
        return (T)emitter;
    }

    private void verify(InjectionPoint injectionPoint) {
        Type type = injectionPoint.getType();
        if (type instanceof ParameterizedType && ((ParameterizedType)type).getActualTypeArguments().length > 0) {
            Type[] arguments = ((ParameterizedType)type).getActualTypeArguments();
            if (arguments[0] instanceof Class && arguments[0].equals(Message.class) || arguments[0] instanceof ParameterizedType && ((ParameterizedType)arguments[0]).getRawType().equals(Message.class)) {
                throw ProviderExceptions.ex.invalidEmitterOfMessage(injectionPoint);
            }
        } else {
            throw ProviderExceptions.ex.invalidRawEmitter(injectionPoint);
        }
    }

    private Type getFirstParameter(Type type) {
        if (type instanceof ParameterizedType) {
            return ((ParameterizedType)type).getActualTypeArguments()[0];
        }
        return null;
    }

    private Type getPayloadParameterFromMessageType(Type type) {
        Type[] actualTypeArguments;
        if (type instanceof ParameterizedType && (actualTypeArguments = ((ParameterizedType)type).getActualTypeArguments()).length == 1) {
            return actualTypeArguments[0];
        }
        return null;
    }

    private Type getRawTypeIfParameterized(Type type) {
        if (type instanceof ParameterizedType) {
            return ((ParameterizedType)type).getRawType();
        }
        return type;
    }

    public static String getChannelName(InjectionPoint injectionPoint) {
        for (Annotation qualifier : injectionPoint.getQualifiers()) {
            if (qualifier.annotationType().equals(Channel.class)) {
                return ((Channel)qualifier).value();
            }
            if (!qualifier.annotationType().equals(io.smallrye.reactive.messaging.annotations.Channel.class)) continue;
            return ((io.smallrye.reactive.messaging.annotations.Channel)qualifier).value();
        }
        throw ProviderExceptions.ex.emitterWithoutChannelAnnotation(injectionPoint);
    }

    static Channel getChannelQualifier(InjectionPoint injectionPoint) {
        for (final Annotation qualifier : injectionPoint.getQualifiers()) {
            if (qualifier.annotationType().equals(Channel.class)) {
                return (Channel)qualifier;
            }
            if (!qualifier.annotationType().equals(io.smallrye.reactive.messaging.annotations.Channel.class)) continue;
            return new Channel(){

                public Class<? extends Annotation> annotationType() {
                    return Channel.class;
                }

                public String value() {
                    return ((io.smallrye.reactive.messaging.annotations.Channel)qualifier).value();
                }
            };
        }
        return null;
    }

    private static <T> T cast(Object obj) {
        return (T)obj;
    }
}

