package io.vertx.mutiny.ext.web.api.service;

import java.util.Map;
import java.util.stream.Collectors;
import io.smallrye.mutiny.Multi;
import io.smallrye.mutiny.Uni;
import java.util.function.Consumer;
import io.smallrye.mutiny.vertx.TypeArg;
import io.vertx.codegen.annotations.Fluent;
import io.smallrye.common.annotation.CheckReturnValue;
import io.vertx.core.eventbus.DeliveryOptions;
import io.vertx.core.json.JsonObject;
import io.vertx.core.Handler;
import java.util.function.Function;

/**
 * Handler that proxy the request to an event bus endpoint, waits for the reply and then writes the HTTP response. <br/>
 *
 * The HTTP request is sent encapsulated into a {@link io.vertx.ext.web.api.service.ServiceRequest} object through the event bus. The expected reply is a {@link io.vertx.ext.web.api.service.ServiceResponse} <br/>
 *
 * This handler requires a {@link io.vertx.mutiny.ext.web.validation.ValidationHandler} that process request parameters, so they can be encapsulated by this handler inside the {@link io.vertx.ext.web.api.service.ServiceRequest}
 *
 * <p/>
 * NOTE: This class has been automatically generated from the {@link io.vertx.ext.web.api.service.RouteToEBServiceHandler original} non Mutiny-ified interface using Vert.x codegen.
 */

@io.smallrye.mutiny.vertx.MutinyGen(io.vertx.ext.web.api.service.RouteToEBServiceHandler.class)
public class RouteToEBServiceHandler implements io.vertx.core.Handler<io.vertx.mutiny.ext.web.RoutingContext>, java.util.function.Consumer<io.vertx.mutiny.ext.web.RoutingContext> {

  public static final io.smallrye.mutiny.vertx.TypeArg<RouteToEBServiceHandler> __TYPE_ARG = new io.smallrye.mutiny.vertx.TypeArg<>(    obj -> new RouteToEBServiceHandler((io.vertx.ext.web.api.service.RouteToEBServiceHandler) obj),
    RouteToEBServiceHandler::getDelegate
  );

  private final io.vertx.ext.web.api.service.RouteToEBServiceHandler delegate;
  
  public RouteToEBServiceHandler(io.vertx.ext.web.api.service.RouteToEBServiceHandler delegate) {
    this.delegate = delegate;
  }

  public RouteToEBServiceHandler(Object delegate) {
    this.delegate = (io.vertx.ext.web.api.service.RouteToEBServiceHandler)delegate;
  }

  /**
   * Empty constructor used by CDI, do not use this constructor directly.
   **/
  RouteToEBServiceHandler() {
    this.delegate = null;
  }

  public io.vertx.ext.web.api.service.RouteToEBServiceHandler getDelegate() {
    return delegate;
  }

  @Override
  public String toString() {
    return delegate.toString();
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    RouteToEBServiceHandler that = (RouteToEBServiceHandler) o;
    return delegate.equals(that.delegate);
  }
  
  @Override
  public int hashCode() {
    return delegate.hashCode();
  }

  public void handle(io.vertx.mutiny.ext.web.RoutingContext arg0) { 
    delegate.handle(arg0.getDelegate());
  }

  /**
   * @param extraPayloadMapper mapper
   * @return 
   */
  @Fluent
  public io.vertx.mutiny.ext.web.api.service.RouteToEBServiceHandler extraPayloadMapper(Function<io.vertx.mutiny.ext.web.RoutingContext, JsonObject> extraPayloadMapper) { 
    delegate.extraPayloadMapper(new java.util.function.Function<io.vertx.ext.web.RoutingContext,io.vertx.core.json.JsonObject>() {
      public JsonObject apply(io.vertx.ext.web.RoutingContext arg) {
        JsonObject ret = extraPayloadMapper.apply(io.vertx.mutiny.ext.web.RoutingContext.newInstance((io.vertx.ext.web.RoutingContext)arg));
        return ret;
      }
    });
    return this;
  }

  /**
   * @param eventBus Vert.x event bus instance
   * @param address Event bus endpoint address
   * @param actionName action name of the endpoint. This will be configured as  header named <code>action</code>
   * @return 
   */
  public static io.vertx.mutiny.ext.web.api.service.RouteToEBServiceHandler build(io.vertx.mutiny.core.eventbus.EventBus eventBus, String address, String actionName) { 
    io.vertx.mutiny.ext.web.api.service.RouteToEBServiceHandler ret = io.vertx.mutiny.ext.web.api.service.RouteToEBServiceHandler.newInstance((io.vertx.ext.web.api.service.RouteToEBServiceHandler)io.vertx.ext.web.api.service.RouteToEBServiceHandler.build(eventBus.getDelegate(), address, actionName));
    return ret;
  }

  /**
   * @param eventBus Vert.x event bus instance
   * @param address Event bus endpoint address
   * @param actionName action name of the endpoint. This will be configured as  header named <code>action</code>
   * @param deliveryOptions delivery options that will be always sent with the request
   * @return 
   */
  public static io.vertx.mutiny.ext.web.api.service.RouteToEBServiceHandler build(io.vertx.mutiny.core.eventbus.EventBus eventBus, String address, String actionName, io.vertx.core.eventbus.DeliveryOptions deliveryOptions) { 
    io.vertx.mutiny.ext.web.api.service.RouteToEBServiceHandler ret = io.vertx.mutiny.ext.web.api.service.RouteToEBServiceHandler.newInstance((io.vertx.ext.web.api.service.RouteToEBServiceHandler)io.vertx.ext.web.api.service.RouteToEBServiceHandler.build(eventBus.getDelegate(), address, actionName, deliveryOptions));
    return ret;
  }

  public void accept(io.vertx.mutiny.ext.web.RoutingContext item) {
    handle(item);
  }
  public static  RouteToEBServiceHandler newInstance(io.vertx.ext.web.api.service.RouteToEBServiceHandler arg) {
    return arg != null ? new RouteToEBServiceHandler(arg) : null;
  }

}
