package io.vertx.mutiny.oracleclient;

import java.util.Map;
import java.util.stream.Collectors;
import io.smallrye.mutiny.Multi;
import io.smallrye.mutiny.Uni;
import java.util.function.Consumer;
import io.smallrye.mutiny.vertx.TypeArg;
import io.vertx.codegen.annotations.Fluent;
import io.smallrye.common.annotation.CheckReturnValue;
import io.vertx.oracleclient.OracleConnectOptions;
import io.vertx.core.Handler;
import java.util.function.Supplier;
import io.vertx.core.Future;
import java.util.function.Function;
import io.vertx.sqlclient.PoolOptions;

/**
 * Represents a pool of connection to interact with an Oracle database.
 *
 * <p/>
 * NOTE: This class has been automatically generated from the {@link io.vertx.oracleclient.OraclePool original} non Mutiny-ified interface using Vert.x codegen.
 */

@io.smallrye.mutiny.vertx.MutinyGen(io.vertx.oracleclient.OraclePool.class)
public class OraclePool extends io.vertx.mutiny.sqlclient.Pool {

  public static final io.smallrye.mutiny.vertx.TypeArg<OraclePool> __TYPE_ARG = new io.smallrye.mutiny.vertx.TypeArg<>(    obj -> new OraclePool((io.vertx.oracleclient.OraclePool) obj),
    OraclePool::getDelegate
  );

  private final io.vertx.oracleclient.OraclePool delegate;
  
  public OraclePool(io.vertx.oracleclient.OraclePool delegate) {
    super(delegate);
    this.delegate = delegate;
  }

  public OraclePool(Object delegate) {
    super((io.vertx.oracleclient.OraclePool)delegate);
    this.delegate = (io.vertx.oracleclient.OraclePool)delegate;
  }

  /**
   * Empty constructor used by CDI, do not use this constructor directly.
   **/
  OraclePool() {
    super(null);
    this.delegate = null;
  }

  public io.vertx.oracleclient.OraclePool getDelegate() {
    return delegate;
  }

  @Override
  public String toString() {
    return delegate.toString();
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    OraclePool that = (OraclePool) o;
    return delegate.equals(that.delegate);
  }
  
  @Override
  public int hashCode() {
    return delegate.hashCode();
  }

  public static io.vertx.mutiny.oracleclient.OraclePool pool(io.vertx.oracleclient.OracleConnectOptions connectOptions, io.vertx.sqlclient.PoolOptions poolOptions) { 
    io.vertx.mutiny.oracleclient.OraclePool ret = io.vertx.mutiny.oracleclient.OraclePool.newInstance((io.vertx.oracleclient.OraclePool)io.vertx.oracleclient.OraclePool.pool(connectOptions, poolOptions));
    return ret;
  }

  /**
   * @param vertx 
   * @param connectOptions 
   * @param poolOptions 
   * @return 
   */
  public static io.vertx.mutiny.oracleclient.OraclePool pool(io.vertx.mutiny.core.Vertx vertx, io.vertx.oracleclient.OracleConnectOptions connectOptions, io.vertx.sqlclient.PoolOptions poolOptions) { 
    io.vertx.mutiny.oracleclient.OraclePool ret = io.vertx.mutiny.oracleclient.OraclePool.newInstance((io.vertx.oracleclient.OraclePool)io.vertx.oracleclient.OraclePool.pool(vertx.getDelegate(), connectOptions, poolOptions));
    return ret;
  }

  /**
   * @param connectionUri 
   * @param poolOptions 
   * @return 
   */
  public static io.vertx.mutiny.oracleclient.OraclePool pool(String connectionUri, io.vertx.sqlclient.PoolOptions poolOptions) { 
    io.vertx.mutiny.oracleclient.OraclePool ret = io.vertx.mutiny.oracleclient.OraclePool.newInstance((io.vertx.oracleclient.OraclePool)io.vertx.oracleclient.OraclePool.pool(connectionUri, poolOptions));
    return ret;
  }

  /**
   * @param vertx 
   * @param connectionUri 
   * @param poolOptions 
   * @return 
   */
  public static io.vertx.mutiny.oracleclient.OraclePool pool(io.vertx.mutiny.core.Vertx vertx, String connectionUri, io.vertx.sqlclient.PoolOptions poolOptions) { 
    io.vertx.mutiny.oracleclient.OraclePool ret = io.vertx.mutiny.oracleclient.OraclePool.newInstance((io.vertx.oracleclient.OraclePool)io.vertx.oracleclient.OraclePool.pool(vertx.getDelegate(), connectionUri, poolOptions));
    return ret;
  }

  @Fluent
  private io.vertx.mutiny.oracleclient.OraclePool __connectHandler(Handler<io.vertx.mutiny.sqlclient.SqlConnection> handler) { 
    delegate.connectHandler(new io.smallrye.mutiny.vertx.DelegatingHandler<>(handler, event -> io.vertx.mutiny.sqlclient.SqlConnection.newInstance((io.vertx.sqlclient.SqlConnection)event)));
    return this;
  }

  public io.vertx.mutiny.oracleclient.OraclePool connectHandler(java.util.function.Consumer<io.vertx.mutiny.sqlclient.SqlConnection> handler) {
    return __connectHandler(handler != null ? new io.smallrye.mutiny.vertx.DelegatingConsumerHandler(handler) : null);
  }

  @Fluent
  public io.vertx.mutiny.oracleclient.OraclePool connectionProvider(Function<io.vertx.mutiny.core.Context, io.smallrye.mutiny.Uni<io.vertx.mutiny.sqlclient.SqlConnection>> provider) { 
    delegate.connectionProvider(new java.util.function.Function<io.vertx.core.Context,io.vertx.core.Future<io.vertx.sqlclient.SqlConnection>>() {
      public io.vertx.core.Future<io.vertx.sqlclient.SqlConnection> apply(io.vertx.core.Context arg) {
            return io.smallrye.mutiny.vertx.UniHelper.toFuture(
                 provider.apply(io.vertx.mutiny.core.Context.newInstance((io.vertx.core.Context)arg)).map(x -> x.getDelegate())
            );
         }
     });
    return this;
  }

  /**
   * @param databases the databases supplier
   * @param poolOptions the options for creating the pool
   * @return the connection pool
   */
  public static io.vertx.mutiny.oracleclient.OraclePool pool(java.util.function.Supplier<io.smallrye.mutiny.Uni<io.vertx.oracleclient.OracleConnectOptions>> databases, io.vertx.sqlclient.PoolOptions poolOptions) { 
    io.vertx.mutiny.oracleclient.OraclePool ret = io.vertx.mutiny.oracleclient.OraclePool.newInstance((io.vertx.oracleclient.OraclePool)io.vertx.oracleclient.OraclePool.pool(() -> io.smallrye.mutiny.vertx.UniHelper.toFuture(databases.get()), poolOptions));
    return ret;
  }

  /**
   * @param vertx 
   * @param databases 
   * @param poolOptions 
   * @return 
   */
  public static io.vertx.mutiny.oracleclient.OraclePool pool(io.vertx.mutiny.core.Vertx vertx, java.util.function.Supplier<io.smallrye.mutiny.Uni<io.vertx.oracleclient.OracleConnectOptions>> databases, io.vertx.sqlclient.PoolOptions poolOptions) { 
    io.vertx.mutiny.oracleclient.OraclePool ret = io.vertx.mutiny.oracleclient.OraclePool.newInstance((io.vertx.oracleclient.OraclePool)io.vertx.oracleclient.OraclePool.pool(vertx.getDelegate(), () -> io.smallrye.mutiny.vertx.UniHelper.toFuture(databases.get()), poolOptions));
    return ret;
  }

  public static  OraclePool newInstance(io.vertx.oracleclient.OraclePool arg) {
    return arg != null ? new OraclePool(arg) : null;
  }

}
