package io.vertx.mutiny.oracleclient;

import java.util.Map;
import java.util.stream.Collectors;
import io.smallrye.mutiny.Multi;
import io.smallrye.mutiny.Uni;
import java.util.function.Consumer;
import io.smallrye.mutiny.vertx.TypeArg;
import io.vertx.codegen.annotations.Fluent;
import io.smallrye.common.annotation.CheckReturnValue;
import io.vertx.oracleclient.OracleConnectOptions;
import io.vertx.core.AsyncResult;
import io.vertx.core.Handler;
import io.vertx.core.Future;

/**
 * A connection to Oracle Database.
 *
 * <p/>
 * NOTE: This class has been automatically generated from the {@link io.vertx.oracleclient.OracleConnection original} non Mutiny-ified interface using Vert.x codegen.
 */

@io.smallrye.mutiny.vertx.MutinyGen(io.vertx.oracleclient.OracleConnection.class)
public class OracleConnection extends io.vertx.mutiny.sqlclient.SqlConnection {

  public static final io.smallrye.mutiny.vertx.TypeArg<OracleConnection> __TYPE_ARG = new io.smallrye.mutiny.vertx.TypeArg<>(    obj -> new OracleConnection((io.vertx.oracleclient.OracleConnection) obj),
    OracleConnection::getDelegate
  );

  private final io.vertx.oracleclient.OracleConnection delegate;
  
  public OracleConnection(io.vertx.oracleclient.OracleConnection delegate) {
    super(delegate);
    this.delegate = delegate;
  }

  public OracleConnection(Object delegate) {
    super((io.vertx.oracleclient.OracleConnection)delegate);
    this.delegate = (io.vertx.oracleclient.OracleConnection)delegate;
  }

  /**
   * Empty constructor used by CDI, do not use this constructor directly.
   **/
  OracleConnection() {
    super(null);
    this.delegate = null;
  }

  public io.vertx.oracleclient.OracleConnection getDelegate() {
    return delegate;
  }

  @Override
  public String toString() {
    return delegate.toString();
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    OracleConnection that = (OracleConnection) o;
    return delegate.equals(that.delegate);
  }
  
  @Override
  public int hashCode() {
    return delegate.hashCode();
  }

  /**
   * Create a connection to Oracle with the given <code>connectOptions</code>.
   * <p>
   * Unlike the <em>bare</em> Vert.x variant, this method returns a {@link io.smallrye.mutiny.Uni Uni}.
   * Don't forget to <em>subscribe</em> on it to trigger the operation.
   * @param vertx the vertx instance
   * @param connectOptions the options for the connection
   * @return the {@link io.smallrye.mutiny.Uni uni} firing the result of the operation when completed, or a failure if the operation failed.
   */
  @CheckReturnValue
  public static io.smallrye.mutiny.Uni<io.vertx.mutiny.oracleclient.OracleConnection> connect(io.vertx.mutiny.core.Vertx vertx, io.vertx.oracleclient.OracleConnectOptions connectOptions) { 
    return io.smallrye.mutiny.vertx.AsyncResultUni.toUni(handler -> {
        io.vertx.oracleclient.OracleConnection.connect(vertx.getDelegate(), connectOptions, new io.smallrye.mutiny.vertx.DelegatingHandler<>(handler, ar -> ar.map(event -> io.vertx.mutiny.oracleclient.OracleConnection.newInstance((io.vertx.oracleclient.OracleConnection)event))));
    });
  }

  /**
   * Blocking variant of {@link io.vertx.mutiny.oracleclient.OracleConnection#connect(io.vertx.mutiny.core.Vertx,OracleConnectOptions)}.
   * <p>
   * This method waits for the completion of the underlying asynchronous operation.
   * If the operation completes successfully, the result is returned, otherwise the failure is thrown (potentially wrapped in a RuntimeException).
   * @param vertx the vertx instance
   * @param connectOptions the options for the connection
   * @return the OracleConnection instance produced by the operation.
   */
  public static io.vertx.mutiny.oracleclient.OracleConnection connectAndAwait(io.vertx.mutiny.core.Vertx vertx, io.vertx.oracleclient.OracleConnectOptions connectOptions) { 
    return (io.vertx.mutiny.oracleclient.OracleConnection) connect(vertx, connectOptions).await().indefinitely();
  }

  /**
   * Variant of {@link io.vertx.mutiny.oracleclient.OracleConnection#connect(io.vertx.mutiny.core.Vertx,OracleConnectOptions)} that ignores the result of the operation.
   * <p>
   * This method subscribes on the result of {@link io.vertx.mutiny.oracleclient.OracleConnection#connect(io.vertx.mutiny.core.Vertx,OracleConnectOptions)}, but discards the outcome (item or failure).
   * This method is useful to trigger the asynchronous operation from {@link io.vertx.mutiny.oracleclient.OracleConnection#connect(io.vertx.mutiny.core.Vertx,OracleConnectOptions)} but you don't need to compose it with other operations.
   * @param vertx the vertx instance
   * @param connectOptions the options for the connection
   */
  public static void connectAndForget(io.vertx.mutiny.core.Vertx vertx, io.vertx.oracleclient.OracleConnectOptions connectOptions) { 
    connect(vertx, connectOptions).subscribe().with(io.smallrye.mutiny.vertx.UniHelper.NOOP);
  }

  /**
   * Like {@link io.vertx.mutiny.oracleclient.OracleConnection#connect} with options built from <code>connectionUri</code>.
   * <p>
   * Unlike the <em>bare</em> Vert.x variant, this method returns a {@link io.smallrye.mutiny.Uni Uni}.
   * Don't forget to <em>subscribe</em> on it to trigger the operation.
   * @param vertx 
   * @param connectionUri 
   * @return the {@link io.smallrye.mutiny.Uni uni} firing the result of the operation when completed, or a failure if the operation failed.
   */
  @CheckReturnValue
  public static io.smallrye.mutiny.Uni<io.vertx.mutiny.oracleclient.OracleConnection> connect(io.vertx.mutiny.core.Vertx vertx, String connectionUri) { 
    return io.smallrye.mutiny.vertx.AsyncResultUni.toUni(handler -> {
        io.vertx.oracleclient.OracleConnection.connect(vertx.getDelegate(), connectionUri, new io.smallrye.mutiny.vertx.DelegatingHandler<>(handler, ar -> ar.map(event -> io.vertx.mutiny.oracleclient.OracleConnection.newInstance((io.vertx.oracleclient.OracleConnection)event))));
    });
  }

  /**
   * Blocking variant of {@link io.vertx.mutiny.oracleclient.OracleConnection#connect(io.vertx.mutiny.core.Vertx,String)}.
   * <p>
   * This method waits for the completion of the underlying asynchronous operation.
   * If the operation completes successfully, the result is returned, otherwise the failure is thrown (potentially wrapped in a RuntimeException).
   * @param vertx 
   * @param connectionUri 
   * @return the OracleConnection instance produced by the operation.
   */
  public static io.vertx.mutiny.oracleclient.OracleConnection connectAndAwait(io.vertx.mutiny.core.Vertx vertx, String connectionUri) { 
    return (io.vertx.mutiny.oracleclient.OracleConnection) connect(vertx, connectionUri).await().indefinitely();
  }

  /**
   * Variant of {@link io.vertx.mutiny.oracleclient.OracleConnection#connect(io.vertx.mutiny.core.Vertx,String)} that ignores the result of the operation.
   * <p>
   * This method subscribes on the result of {@link io.vertx.mutiny.oracleclient.OracleConnection#connect(io.vertx.mutiny.core.Vertx,String)}, but discards the outcome (item or failure).
   * This method is useful to trigger the asynchronous operation from {@link io.vertx.mutiny.oracleclient.OracleConnection#connect(io.vertx.mutiny.core.Vertx,String)} but you don't need to compose it with other operations.
   * @param vertx 
   * @param connectionUri 
   */
  public static void connectAndForget(io.vertx.mutiny.core.Vertx vertx, String connectionUri) { 
    connect(vertx, connectionUri).subscribe().with(io.smallrye.mutiny.vertx.UniHelper.NOOP);
  }

  /**
   * 
   * <p>
   * Unlike the <em>bare</em> Vert.x variant, this method returns a {@link io.smallrye.mutiny.Uni Uni}.
   * Don't forget to <em>subscribe</em> on it to trigger the operation.
   * @param s 
   * @return the {@link io.smallrye.mutiny.Uni uni} firing the result of the operation when completed, or a failure if the operation failed.
   */
  @CheckReturnValue
  public io.smallrye.mutiny.Uni<io.vertx.mutiny.sqlclient.PreparedStatement> prepare(String s) { 
    return io.smallrye.mutiny.vertx.AsyncResultUni.toUni(handler -> {
        delegate.prepare(s, new io.smallrye.mutiny.vertx.DelegatingHandler<>(handler, ar -> ar.map(event -> io.vertx.mutiny.sqlclient.PreparedStatement.newInstance((io.vertx.sqlclient.PreparedStatement)event))));
    });
  }

  /**
   * Blocking variant of {@link io.vertx.mutiny.sqlclient.SqlConnection#prepare(String)}.
   * <p>
   * This method waits for the completion of the underlying asynchronous operation.
   * If the operation completes successfully, the result is returned, otherwise the failure is thrown (potentially wrapped in a RuntimeException).
   * @param s 
   * @return the PreparedStatement instance produced by the operation.
   */
  public io.vertx.mutiny.sqlclient.PreparedStatement prepareAndAwait(String s) { 
    return (io.vertx.mutiny.sqlclient.PreparedStatement) prepare(s).await().indefinitely();
  }

  /**
   * Variant of {@link io.vertx.mutiny.sqlclient.SqlConnection#prepare(String)} that ignores the result of the operation.
   * <p>
   * This method subscribes on the result of {@link io.vertx.mutiny.sqlclient.SqlConnection#prepare(String)}, but discards the outcome (item or failure).
   * This method is useful to trigger the asynchronous operation from {@link io.vertx.mutiny.sqlclient.SqlConnection#prepare(String)} but you don't need to compose it with other operations.
   * @param s 
   * @return the instance of OracleConnection to chain method calls.
   */
  @Fluent
  public io.vertx.mutiny.oracleclient.OracleConnection prepareAndForget(String s) { 
    prepare(s).subscribe().with(io.smallrye.mutiny.vertx.UniHelper.NOOP);
    return this;
  }

  /**
   * @param handler 
   * @return the instance of OracleConnection to chain method calls.
   */
  @Fluent
  private io.vertx.mutiny.oracleclient.OracleConnection __exceptionHandler(Handler<java.lang.Throwable> handler) { 
    delegate.exceptionHandler(handler);
    return this;
  }

  /**
   * @param handler 
   * @return 
   */
  public io.vertx.mutiny.oracleclient.OracleConnection exceptionHandler(java.util.function.Consumer<java.lang.Throwable> handler) {
    return __exceptionHandler(handler != null ? new io.smallrye.mutiny.vertx.DelegatingConsumerHandler(handler) : null);
  }

  /**
   * @param handler 
   * @return the instance of OracleConnection to chain method calls.
   */
  @Fluent
  private io.vertx.mutiny.oracleclient.OracleConnection __closeHandler(Handler<Void> handler) { 
    delegate.closeHandler(handler);
    return this;
  }

  /**
   * @param handler 
   * @return 
   */
  public io.vertx.mutiny.oracleclient.OracleConnection closeHandler(java.lang.Runnable handler) {
    return __closeHandler(ignored -> handler.run()
);
  }

  /**
   * @param sqlConnection the connection to cast
   * @return a {@link io.vertx.mutiny.oracleclient.OracleConnection instance}
   */
  public static io.vertx.mutiny.oracleclient.OracleConnection cast(io.vertx.mutiny.sqlclient.SqlConnection sqlConnection) { 
    io.vertx.mutiny.oracleclient.OracleConnection ret = io.vertx.mutiny.oracleclient.OracleConnection.newInstance((io.vertx.oracleclient.OracleConnection)io.vertx.oracleclient.OracleConnection.cast(sqlConnection.getDelegate()));
    return ret;
  }

  public static  OracleConnection newInstance(io.vertx.oracleclient.OracleConnection arg) {
    return arg != null ? new OracleConnection(arg) : null;
  }

}
