package io.vertx.mutiny.ext.mongo;

import java.util.Map;
import java.util.stream.Collectors;
import io.smallrye.mutiny.Multi;
import io.smallrye.mutiny.Uni;
import java.util.function.Consumer;
import io.smallrye.mutiny.vertx.TypeArg;
import io.vertx.codegen.annotations.Fluent;
import io.smallrye.common.annotation.CheckReturnValue;
import io.vertx.core.Future;
import io.vertx.ext.mongo.GridFsDownloadOptions;
import java.util.List;
import io.vertx.ext.mongo.GridFsUploadOptions;
import io.vertx.core.json.JsonObject;
import io.vertx.core.AsyncResult;
import io.vertx.core.Handler;

@io.smallrye.mutiny.vertx.MutinyGen(io.vertx.ext.mongo.MongoGridFsClient.class)
public class MongoGridFsClient {

  public static final io.smallrye.mutiny.vertx.TypeArg<MongoGridFsClient> __TYPE_ARG = new io.smallrye.mutiny.vertx.TypeArg<>(    obj -> new MongoGridFsClient((io.vertx.ext.mongo.MongoGridFsClient) obj),
    MongoGridFsClient::getDelegate
  );

  private final io.vertx.ext.mongo.MongoGridFsClient delegate;
  
  public MongoGridFsClient(io.vertx.ext.mongo.MongoGridFsClient delegate) {
    this.delegate = delegate;
  }

  public MongoGridFsClient(Object delegate) {
    this.delegate = (io.vertx.ext.mongo.MongoGridFsClient)delegate;
  }

  /**
   * Empty constructor used by CDI, do not use this constructor directly.
   **/
  MongoGridFsClient() {
    this.delegate = null;
  }

  public io.vertx.ext.mongo.MongoGridFsClient getDelegate() {
    return delegate;
  }

  static final io.smallrye.mutiny.vertx.TypeArg<io.vertx.mutiny.core.buffer.Buffer> TYPE_ARG_2 = new TypeArg<io.vertx.mutiny.core.buffer.Buffer>(o1 -> io.vertx.mutiny.core.buffer.Buffer.newInstance((io.vertx.core.buffer.Buffer)o1), o1 -> o1.getDelegate());
  static final io.smallrye.mutiny.vertx.TypeArg<io.vertx.mutiny.core.buffer.Buffer> TYPE_ARG_0 = new TypeArg<io.vertx.mutiny.core.buffer.Buffer>(o1 -> io.vertx.mutiny.core.buffer.Buffer.newInstance((io.vertx.core.buffer.Buffer)o1), o1 -> o1.getDelegate());
  static final io.smallrye.mutiny.vertx.TypeArg<io.vertx.mutiny.core.buffer.Buffer> TYPE_ARG_1 = new TypeArg<io.vertx.mutiny.core.buffer.Buffer>(o1 -> io.vertx.mutiny.core.buffer.Buffer.newInstance((io.vertx.core.buffer.Buffer)o1), o1 -> o1.getDelegate());
  @Override
  public String toString() {
    return delegate.toString();
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    MongoGridFsClient that = (MongoGridFsClient) o;
    return delegate.equals(that.delegate);
  }
  
  @Override
  public int hashCode() {
    return delegate.hashCode();
  }

  /**
   * Deletes a file by it's ID
   * <p>
   * Unlike the <em>bare</em> Vert.x variant, this method returns a {@link io.smallrye.mutiny.Uni Uni}.
   * Don't forget to <em>subscribe</em> on it to trigger the operation.
   * @param id the identifier of the file
   * @return the {@link io.smallrye.mutiny.Uni uni} firing the result of the operation when completed, or a failure if the operation failed.
   */
  @CheckReturnValue
  public io.smallrye.mutiny.Uni<Void> delete(String id) { 
    return io.smallrye.mutiny.vertx.AsyncResultUni.toUni(resultHandler -> {
        delegate.delete(id, resultHandler);
    });
  }

  /**
   * Blocking variant of {@link io.vertx.mutiny.ext.mongo.MongoGridFsClient#delete(String)}.
   * <p>
   * This method waits for the completion of the underlying asynchronous operation.
   * If the operation completes successfully, the result is returned, otherwise the failure is thrown (potentially wrapped in a RuntimeException).
   * @param id the identifier of the file
   * @return the Void instance produced by the operation.
   */
  public Void deleteAndAwait(String id) { 
    return (Void) delete(id).await().indefinitely();
  }

  /**
   * Variant of {@link io.vertx.mutiny.ext.mongo.MongoGridFsClient#delete(String)} that ignores the result of the operation.
   * <p>
   * This method subscribes on the result of {@link io.vertx.mutiny.ext.mongo.MongoGridFsClient#delete(String)}, but discards the outcome (item or failure).
   * This method is useful to trigger the asynchronous operation from {@link io.vertx.mutiny.ext.mongo.MongoGridFsClient#delete(String)} but you don't need to compose it with other operations.
   * @param id the identifier of the file
   * @return the instance of MongoGridFsClient to chain method calls.
   */
  @Fluent
  public io.vertx.mutiny.ext.mongo.MongoGridFsClient deleteAndForget(String id) { 
    delete(id).subscribe().with(io.smallrye.mutiny.vertx.UniHelper.NOOP);
    return this;
  }

  /**
   * @param fileName 
   * @return 
   */
  public io.vertx.mutiny.core.streams.ReadStream<io.vertx.mutiny.core.buffer.Buffer> readByFileName(String fileName) { 
    io.vertx.mutiny.core.streams.ReadStream<io.vertx.mutiny.core.buffer.Buffer> ret = io.vertx.mutiny.core.streams.ReadStream.newInstance((io.vertx.core.streams.ReadStream)delegate.readByFileName(fileName), TYPE_ARG_0);
    return ret;
  }

  /**
   * @param fileName 
   * @param options 
   * @return 
   */
  public io.vertx.mutiny.core.streams.ReadStream<io.vertx.mutiny.core.buffer.Buffer> readByFileNameWithOptions(String fileName, io.vertx.ext.mongo.GridFsDownloadOptions options) { 
    io.vertx.mutiny.core.streams.ReadStream<io.vertx.mutiny.core.buffer.Buffer> ret = io.vertx.mutiny.core.streams.ReadStream.newInstance((io.vertx.core.streams.ReadStream)delegate.readByFileNameWithOptions(fileName, options), TYPE_ARG_1);
    return ret;
  }

  /**
   * @param id 
   * @return 
   */
  public io.vertx.mutiny.core.streams.ReadStream<io.vertx.mutiny.core.buffer.Buffer> readById(String id) { 
    io.vertx.mutiny.core.streams.ReadStream<io.vertx.mutiny.core.buffer.Buffer> ret = io.vertx.mutiny.core.streams.ReadStream.newInstance((io.vertx.core.streams.ReadStream)delegate.readById(id), TYPE_ARG_2);
    return ret;
  }

  @CheckReturnValue
  public io.smallrye.mutiny.Uni<Long> downloadByFileName(io.vertx.mutiny.core.streams.WriteStream<io.vertx.mutiny.core.buffer.Buffer> stream, String fileName) { 
    return io.smallrye.mutiny.vertx.AsyncResultUni.toUni(resultHandler -> {
        delegate.downloadByFileName(stream.getDelegate(), fileName, resultHandler);
    });
  }

  public Long downloadByFileNameAndAwait(io.vertx.mutiny.core.streams.WriteStream<io.vertx.mutiny.core.buffer.Buffer> stream, String fileName) { 
    return (Long) downloadByFileName(stream, fileName).await().indefinitely();
  }

  @Fluent
  public io.vertx.mutiny.ext.mongo.MongoGridFsClient downloadByFileNameAndForget(io.vertx.mutiny.core.streams.WriteStream<io.vertx.mutiny.core.buffer.Buffer> stream, String fileName) { 
    downloadByFileName(stream, fileName).subscribe().with(io.smallrye.mutiny.vertx.UniHelper.NOOP);
    return this;
  }

  @CheckReturnValue
  public io.smallrye.mutiny.Uni<Long> downloadByFileNameWithOptions(io.vertx.mutiny.core.streams.WriteStream<io.vertx.mutiny.core.buffer.Buffer> stream, String fileName, io.vertx.ext.mongo.GridFsDownloadOptions options) { 
    return io.smallrye.mutiny.vertx.AsyncResultUni.toUni(resultHandler -> {
        delegate.downloadByFileNameWithOptions(stream.getDelegate(), fileName, options, resultHandler);
    });
  }

  public Long downloadByFileNameWithOptionsAndAwait(io.vertx.mutiny.core.streams.WriteStream<io.vertx.mutiny.core.buffer.Buffer> stream, String fileName, io.vertx.ext.mongo.GridFsDownloadOptions options) { 
    return (Long) downloadByFileNameWithOptions(stream, fileName, options).await().indefinitely();
  }

  @Fluent
  public io.vertx.mutiny.ext.mongo.MongoGridFsClient downloadByFileNameWithOptionsAndForget(io.vertx.mutiny.core.streams.WriteStream<io.vertx.mutiny.core.buffer.Buffer> stream, String fileName, io.vertx.ext.mongo.GridFsDownloadOptions options) { 
    downloadByFileNameWithOptions(stream, fileName, options).subscribe().with(io.smallrye.mutiny.vertx.UniHelper.NOOP);
    return this;
  }

  @CheckReturnValue
  public io.smallrye.mutiny.Uni<Long> downloadById(io.vertx.mutiny.core.streams.WriteStream<io.vertx.mutiny.core.buffer.Buffer> stream, String id) { 
    return io.smallrye.mutiny.vertx.AsyncResultUni.toUni(resultHandler -> {
        delegate.downloadById(stream.getDelegate(), id, resultHandler);
    });
  }

  public Long downloadByIdAndAwait(io.vertx.mutiny.core.streams.WriteStream<io.vertx.mutiny.core.buffer.Buffer> stream, String id) { 
    return (Long) downloadById(stream, id).await().indefinitely();
  }

  @Fluent
  public io.vertx.mutiny.ext.mongo.MongoGridFsClient downloadByIdAndForget(io.vertx.mutiny.core.streams.WriteStream<io.vertx.mutiny.core.buffer.Buffer> stream, String id) { 
    downloadById(stream, id).subscribe().with(io.smallrye.mutiny.vertx.UniHelper.NOOP);
    return this;
  }

  /**
   * Downloads a file.
   * <p>
   * Unlike the <em>bare</em> Vert.x variant, this method returns a {@link io.smallrye.mutiny.Uni Uni}.
   * Don't forget to <em>subscribe</em> on it to trigger the operation.
   * @param fileName the name of the file to download
   * @return the {@link io.smallrye.mutiny.Uni uni} firing the result of the operation when completed, or a failure if the operation failed.
   */
  @CheckReturnValue
  public io.smallrye.mutiny.Uni<Long> downloadFile(String fileName) { 
    return io.smallrye.mutiny.vertx.AsyncResultUni.toUni(resultHandler -> {
        delegate.downloadFile(fileName, resultHandler);
    });
  }

  /**
   * Blocking variant of {@link io.vertx.mutiny.ext.mongo.MongoGridFsClient#downloadFile(String)}.
   * <p>
   * This method waits for the completion of the underlying asynchronous operation.
   * If the operation completes successfully, the result is returned, otherwise the failure is thrown (potentially wrapped in a RuntimeException).
   * @param fileName the name of the file to download
   * @return the Long instance produced by the operation.
   */
  public Long downloadFileAndAwait(String fileName) { 
    return (Long) downloadFile(fileName).await().indefinitely();
  }

  /**
   * Variant of {@link io.vertx.mutiny.ext.mongo.MongoGridFsClient#downloadFile(String)} that ignores the result of the operation.
   * <p>
   * This method subscribes on the result of {@link io.vertx.mutiny.ext.mongo.MongoGridFsClient#downloadFile(String)}, but discards the outcome (item or failure).
   * This method is useful to trigger the asynchronous operation from {@link io.vertx.mutiny.ext.mongo.MongoGridFsClient#downloadFile(String)} but you don't need to compose it with other operations.
   * @param fileName the name of the file to download
   * @return the instance of MongoGridFsClient to chain method calls.
   */
  @Fluent
  public io.vertx.mutiny.ext.mongo.MongoGridFsClient downloadFileAndForget(String fileName) { 
    downloadFile(fileName).subscribe().with(io.smallrye.mutiny.vertx.UniHelper.NOOP);
    return this;
  }

  /**
   * Downloads a file and gives it a new name.
   * <p>
   * Unlike the <em>bare</em> Vert.x variant, this method returns a {@link io.smallrye.mutiny.Uni Uni}.
   * Don't forget to <em>subscribe</em> on it to trigger the operation.
   * @param fileName the name of the file to download
   * @param newFileName the name the file should be saved as
   * @return the {@link io.smallrye.mutiny.Uni uni} firing the result of the operation when completed, or a failure if the operation failed.
   */
  @CheckReturnValue
  public io.smallrye.mutiny.Uni<Long> downloadFileAs(String fileName, String newFileName) { 
    return io.smallrye.mutiny.vertx.AsyncResultUni.toUni(resultHandler -> {
        delegate.downloadFileAs(fileName, newFileName, resultHandler);
    });
  }

  /**
   * Blocking variant of {@link io.vertx.mutiny.ext.mongo.MongoGridFsClient#downloadFileAs(String,String)}.
   * <p>
   * This method waits for the completion of the underlying asynchronous operation.
   * If the operation completes successfully, the result is returned, otherwise the failure is thrown (potentially wrapped in a RuntimeException).
   * @param fileName the name of the file to download
   * @param newFileName the name the file should be saved as
   * @return the Long instance produced by the operation.
   */
  public Long downloadFileAsAndAwait(String fileName, String newFileName) { 
    return (Long) downloadFileAs(fileName, newFileName).await().indefinitely();
  }

  /**
   * Variant of {@link io.vertx.mutiny.ext.mongo.MongoGridFsClient#downloadFileAs(String,String)} that ignores the result of the operation.
   * <p>
   * This method subscribes on the result of {@link io.vertx.mutiny.ext.mongo.MongoGridFsClient#downloadFileAs(String,String)}, but discards the outcome (item or failure).
   * This method is useful to trigger the asynchronous operation from {@link io.vertx.mutiny.ext.mongo.MongoGridFsClient#downloadFileAs(String,String)} but you don't need to compose it with other operations.
   * @param fileName the name of the file to download
   * @param newFileName the name the file should be saved as
   * @return the instance of MongoGridFsClient to chain method calls.
   */
  @Fluent
  public io.vertx.mutiny.ext.mongo.MongoGridFsClient downloadFileAsAndForget(String fileName, String newFileName) { 
    downloadFileAs(fileName, newFileName).subscribe().with(io.smallrye.mutiny.vertx.UniHelper.NOOP);
    return this;
  }

  /**
   * Downloads a file using the ID generated by GridFs.
   * <p>
   * Unlike the <em>bare</em> Vert.x variant, this method returns a {@link io.smallrye.mutiny.Uni Uni}.
   * Don't forget to <em>subscribe</em> on it to trigger the operation.
   * @param id the GridFs Object ID of the file to download
   * @param fileName 
   * @return the {@link io.smallrye.mutiny.Uni uni} firing the result of the operation when completed, or a failure if the operation failed.
   */
  @CheckReturnValue
  public io.smallrye.mutiny.Uni<Long> downloadFileByID(String id, String fileName) { 
    return io.smallrye.mutiny.vertx.AsyncResultUni.toUni(resultHandler -> {
        delegate.downloadFileByID(id, fileName, resultHandler);
    });
  }

  /**
   * Blocking variant of {@link io.vertx.mutiny.ext.mongo.MongoGridFsClient#downloadFileByID(String,String)}.
   * <p>
   * This method waits for the completion of the underlying asynchronous operation.
   * If the operation completes successfully, the result is returned, otherwise the failure is thrown (potentially wrapped in a RuntimeException).
   * @param id the GridFs Object ID of the file to download
   * @param fileName 
   * @return the Long instance produced by the operation.
   */
  public Long downloadFileByIDAndAwait(String id, String fileName) { 
    return (Long) downloadFileByID(id, fileName).await().indefinitely();
  }

  /**
   * Variant of {@link io.vertx.mutiny.ext.mongo.MongoGridFsClient#downloadFileByID(String,String)} that ignores the result of the operation.
   * <p>
   * This method subscribes on the result of {@link io.vertx.mutiny.ext.mongo.MongoGridFsClient#downloadFileByID(String,String)}, but discards the outcome (item or failure).
   * This method is useful to trigger the asynchronous operation from {@link io.vertx.mutiny.ext.mongo.MongoGridFsClient#downloadFileByID(String,String)} but you don't need to compose it with other operations.
   * @param id the GridFs Object ID of the file to download
   * @param fileName 
   * @return the instance of MongoGridFsClient to chain method calls.
   */
  @Fluent
  public io.vertx.mutiny.ext.mongo.MongoGridFsClient downloadFileByIDAndForget(String id, String fileName) { 
    downloadFileByID(id, fileName).subscribe().with(io.smallrye.mutiny.vertx.UniHelper.NOOP);
    return this;
  }

  /**
   * Drops the entire file bucket with all of its contents
   * <p>
   * Unlike the <em>bare</em> Vert.x variant, this method returns a {@link io.smallrye.mutiny.Uni Uni}.
   * Don't forget to <em>subscribe</em> on it to trigger the operation.
   * @return the {@link io.smallrye.mutiny.Uni uni} firing the result of the operation when completed, or a failure if the operation failed.
   */
  @CheckReturnValue
  public io.smallrye.mutiny.Uni<Void> drop() { 
    return io.smallrye.mutiny.vertx.AsyncResultUni.toUni(resultHandler -> {
        delegate.drop(resultHandler);
    });
  }

  /**
   * Blocking variant of {@link io.vertx.mutiny.ext.mongo.MongoGridFsClient#drop}.
   * <p>
   * This method waits for the completion of the underlying asynchronous operation.
   * If the operation completes successfully, the result is returned, otherwise the failure is thrown (potentially wrapped in a RuntimeException).
   * @return the Void instance produced by the operation.
   */
  public Void dropAndAwait() { 
    return (Void) drop().await().indefinitely();
  }

  /**
   * Variant of {@link io.vertx.mutiny.ext.mongo.MongoGridFsClient#drop} that ignores the result of the operation.
   * <p>
   * This method subscribes on the result of {@link io.vertx.mutiny.ext.mongo.MongoGridFsClient#drop}, but discards the outcome (item or failure).
   * This method is useful to trigger the asynchronous operation from {@link io.vertx.mutiny.ext.mongo.MongoGridFsClient#drop} but you don't need to compose it with other operations.
   * @return the instance of MongoGridFsClient to chain method calls.
   */
  @Fluent
  public io.vertx.mutiny.ext.mongo.MongoGridFsClient dropAndForget() { 
    drop().subscribe().with(io.smallrye.mutiny.vertx.UniHelper.NOOP);
    return this;
  }

  /**
   * Finds all file ids in the bucket
   * <p>
   * Unlike the <em>bare</em> Vert.x variant, this method returns a {@link io.smallrye.mutiny.Uni Uni}.
   * Don't forget to <em>subscribe</em> on it to trigger the operation.
   * @return the {@link io.smallrye.mutiny.Uni uni} firing the result of the operation when completed, or a failure if the operation failed.
   */
  @CheckReturnValue
  public io.smallrye.mutiny.Uni<List<String>> findAllIds() { 
    return io.smallrye.mutiny.vertx.AsyncResultUni.toUni(resultHandler -> {
        delegate.findAllIds(resultHandler);
    });
  }

  /**
   * Blocking variant of {@link io.vertx.mutiny.ext.mongo.MongoGridFsClient#findAllIds}.
   * <p>
   * This method waits for the completion of the underlying asynchronous operation.
   * If the operation completes successfully, the result is returned, otherwise the failure is thrown (potentially wrapped in a RuntimeException).
   * @return the List<String> instance produced by the operation.
   */
  public List<String> findAllIdsAndAwait() { 
    return (List<String>) findAllIds().await().indefinitely();
  }

  /**
   * Variant of {@link io.vertx.mutiny.ext.mongo.MongoGridFsClient#findAllIds} that ignores the result of the operation.
   * <p>
   * This method subscribes on the result of {@link io.vertx.mutiny.ext.mongo.MongoGridFsClient#findAllIds}, but discards the outcome (item or failure).
   * This method is useful to trigger the asynchronous operation from {@link io.vertx.mutiny.ext.mongo.MongoGridFsClient#findAllIds} but you don't need to compose it with other operations.
   * @return the instance of MongoGridFsClient to chain method calls.
   */
  @Fluent
  public io.vertx.mutiny.ext.mongo.MongoGridFsClient findAllIdsAndForget() { 
    findAllIds().subscribe().with(io.smallrye.mutiny.vertx.UniHelper.NOOP);
    return this;
  }

  /**
   * Finds all file ids that match a query.
   * <p>
   * Unlike the <em>bare</em> Vert.x variant, this method returns a {@link io.smallrye.mutiny.Uni Uni}.
   * Don't forget to <em>subscribe</em> on it to trigger the operation.
   * @param query a bson query expressed as json that will be used to match files
   * @return the {@link io.smallrye.mutiny.Uni uni} firing the result of the operation when completed, or a failure if the operation failed.
   */
  @CheckReturnValue
  public io.smallrye.mutiny.Uni<List<String>> findIds(JsonObject query) { 
    return io.smallrye.mutiny.vertx.AsyncResultUni.toUni(resultHandler -> {
        delegate.findIds(query, resultHandler);
    });
  }

  /**
   * Blocking variant of {@link io.vertx.mutiny.ext.mongo.MongoGridFsClient#findIds(JsonObject)}.
   * <p>
   * This method waits for the completion of the underlying asynchronous operation.
   * If the operation completes successfully, the result is returned, otherwise the failure is thrown (potentially wrapped in a RuntimeException).
   * @param query a bson query expressed as json that will be used to match files
   * @return the List<String> instance produced by the operation.
   */
  public List<String> findIdsAndAwait(JsonObject query) { 
    return (List<String>) findIds(query).await().indefinitely();
  }

  /**
   * Variant of {@link io.vertx.mutiny.ext.mongo.MongoGridFsClient#findIds(JsonObject)} that ignores the result of the operation.
   * <p>
   * This method subscribes on the result of {@link io.vertx.mutiny.ext.mongo.MongoGridFsClient#findIds(JsonObject)}, but discards the outcome (item or failure).
   * This method is useful to trigger the asynchronous operation from {@link io.vertx.mutiny.ext.mongo.MongoGridFsClient#findIds(JsonObject)} but you don't need to compose it with other operations.
   * @param query a bson query expressed as json that will be used to match files
   * @return the instance of MongoGridFsClient to chain method calls.
   */
  @Fluent
  public io.vertx.mutiny.ext.mongo.MongoGridFsClient findIdsAndForget(JsonObject query) { 
    findIds(query).subscribe().with(io.smallrye.mutiny.vertx.UniHelper.NOOP);
    return this;
  }

  @CheckReturnValue
  public io.smallrye.mutiny.Uni<String> uploadByFileName(io.vertx.mutiny.core.streams.ReadStream<io.vertx.mutiny.core.buffer.Buffer> stream, String fileName) { 
    return io.smallrye.mutiny.vertx.AsyncResultUni.toUni(resultHandler -> {
        delegate.uploadByFileName(stream.getDelegate(), fileName, resultHandler);
    });
  }

  public String uploadByFileNameAndAwait(io.vertx.mutiny.core.streams.ReadStream<io.vertx.mutiny.core.buffer.Buffer> stream, String fileName) { 
    return (String) uploadByFileName(stream, fileName).await().indefinitely();
  }

  @Fluent
  public io.vertx.mutiny.ext.mongo.MongoGridFsClient uploadByFileNameAndForget(io.vertx.mutiny.core.streams.ReadStream<io.vertx.mutiny.core.buffer.Buffer> stream, String fileName) { 
    uploadByFileName(stream, fileName).subscribe().with(io.smallrye.mutiny.vertx.UniHelper.NOOP);
    return this;
  }

  @CheckReturnValue
  public io.smallrye.mutiny.Uni<String> uploadByFileName(java.util.concurrent.Flow.Publisher<io.vertx.mutiny.core.buffer.Buffer> stream, String fileName) { 
    return io.smallrye.mutiny.vertx.AsyncResultUni.toUni(resultHandler -> {
        delegate.uploadByFileName(io.smallrye.mutiny.vertx.ReadStreamSubscriber.asReadStream(stream,obj -> (io.vertx.core.buffer.Buffer) obj.getDelegate()).resume(), fileName, resultHandler);
    });
  }

  public String uploadByFileNameAndAwait(java.util.concurrent.Flow.Publisher<io.vertx.mutiny.core.buffer.Buffer> stream, String fileName) { 
    return (String) uploadByFileName(stream, fileName).await().indefinitely();
  }

  @Fluent
  public io.vertx.mutiny.ext.mongo.MongoGridFsClient uploadByFileNameAndForget(java.util.concurrent.Flow.Publisher<io.vertx.mutiny.core.buffer.Buffer> stream, String fileName) { 
    uploadByFileName(stream, fileName).subscribe().with(io.smallrye.mutiny.vertx.UniHelper.NOOP);
    return this;
  }

  @CheckReturnValue
  public io.smallrye.mutiny.Uni<String> uploadByFileNameWithOptions(io.vertx.mutiny.core.streams.ReadStream<io.vertx.mutiny.core.buffer.Buffer> stream, String fileName, io.vertx.ext.mongo.GridFsUploadOptions options) { 
    return io.smallrye.mutiny.vertx.AsyncResultUni.toUni(resultHandler -> {
        delegate.uploadByFileNameWithOptions(stream.getDelegate(), fileName, options, resultHandler);
    });
  }

  public String uploadByFileNameWithOptionsAndAwait(io.vertx.mutiny.core.streams.ReadStream<io.vertx.mutiny.core.buffer.Buffer> stream, String fileName, io.vertx.ext.mongo.GridFsUploadOptions options) { 
    return (String) uploadByFileNameWithOptions(stream, fileName, options).await().indefinitely();
  }

  @Fluent
  public io.vertx.mutiny.ext.mongo.MongoGridFsClient uploadByFileNameWithOptionsAndForget(io.vertx.mutiny.core.streams.ReadStream<io.vertx.mutiny.core.buffer.Buffer> stream, String fileName, io.vertx.ext.mongo.GridFsUploadOptions options) { 
    uploadByFileNameWithOptions(stream, fileName, options).subscribe().with(io.smallrye.mutiny.vertx.UniHelper.NOOP);
    return this;
  }

  @CheckReturnValue
  public io.smallrye.mutiny.Uni<String> uploadByFileNameWithOptions(java.util.concurrent.Flow.Publisher<io.vertx.mutiny.core.buffer.Buffer> stream, String fileName, io.vertx.ext.mongo.GridFsUploadOptions options) { 
    return io.smallrye.mutiny.vertx.AsyncResultUni.toUni(resultHandler -> {
        delegate.uploadByFileNameWithOptions(io.smallrye.mutiny.vertx.ReadStreamSubscriber.asReadStream(stream,obj -> (io.vertx.core.buffer.Buffer) obj.getDelegate()).resume(), fileName, options, resultHandler);
    });
  }

  public String uploadByFileNameWithOptionsAndAwait(java.util.concurrent.Flow.Publisher<io.vertx.mutiny.core.buffer.Buffer> stream, String fileName, io.vertx.ext.mongo.GridFsUploadOptions options) { 
    return (String) uploadByFileNameWithOptions(stream, fileName, options).await().indefinitely();
  }

  @Fluent
  public io.vertx.mutiny.ext.mongo.MongoGridFsClient uploadByFileNameWithOptionsAndForget(java.util.concurrent.Flow.Publisher<io.vertx.mutiny.core.buffer.Buffer> stream, String fileName, io.vertx.ext.mongo.GridFsUploadOptions options) { 
    uploadByFileNameWithOptions(stream, fileName, options).subscribe().with(io.smallrye.mutiny.vertx.UniHelper.NOOP);
    return this;
  }

  /**
   * Upload a file to gridfs
   * <p>
   * Unlike the <em>bare</em> Vert.x variant, this method returns a {@link io.smallrye.mutiny.Uni Uni}.
   * Don't forget to <em>subscribe</em> on it to trigger the operation.
   * @param fileName the name of the file to store in gridfs
   * @return the {@link io.smallrye.mutiny.Uni uni} firing the result of the operation when completed, or a failure if the operation failed.
   */
  @CheckReturnValue
  public io.smallrye.mutiny.Uni<String> uploadFile(String fileName) { 
    return io.smallrye.mutiny.vertx.AsyncResultUni.toUni(resultHandler -> {
        delegate.uploadFile(fileName, resultHandler);
    });
  }

  /**
   * Blocking variant of {@link io.vertx.mutiny.ext.mongo.MongoGridFsClient#uploadFile(String)}.
   * <p>
   * This method waits for the completion of the underlying asynchronous operation.
   * If the operation completes successfully, the result is returned, otherwise the failure is thrown (potentially wrapped in a RuntimeException).
   * @param fileName the name of the file to store in gridfs
   * @return the String instance produced by the operation.
   */
  public String uploadFileAndAwait(String fileName) { 
    return (String) uploadFile(fileName).await().indefinitely();
  }

  /**
   * Variant of {@link io.vertx.mutiny.ext.mongo.MongoGridFsClient#uploadFile(String)} that ignores the result of the operation.
   * <p>
   * This method subscribes on the result of {@link io.vertx.mutiny.ext.mongo.MongoGridFsClient#uploadFile(String)}, but discards the outcome (item or failure).
   * This method is useful to trigger the asynchronous operation from {@link io.vertx.mutiny.ext.mongo.MongoGridFsClient#uploadFile(String)} but you don't need to compose it with other operations.
   * @param fileName the name of the file to store in gridfs
   * @return the instance of MongoGridFsClient to chain method calls.
   */
  @Fluent
  public io.vertx.mutiny.ext.mongo.MongoGridFsClient uploadFileAndForget(String fileName) { 
    uploadFile(fileName).subscribe().with(io.smallrye.mutiny.vertx.UniHelper.NOOP);
    return this;
  }

  /**
   * Upload a file to gridfs with options
   * <p>
   * Unlike the <em>bare</em> Vert.x variant, this method returns a {@link io.smallrye.mutiny.Uni Uni}.
   * Don't forget to <em>subscribe</em> on it to trigger the operation.
   * @param fileName the name of the file to store in gridfs
   * @param options {@link io.vertx.ext.mongo.GridFsUploadOptions} for specifying metadata and chunk size
   * @return the {@link io.smallrye.mutiny.Uni uni} firing the result of the operation when completed, or a failure if the operation failed.
   */
  @CheckReturnValue
  public io.smallrye.mutiny.Uni<String> uploadFileWithOptions(String fileName, io.vertx.ext.mongo.GridFsUploadOptions options) { 
    return io.smallrye.mutiny.vertx.AsyncResultUni.toUni(resultHandler -> {
        delegate.uploadFileWithOptions(fileName, options, resultHandler);
    });
  }

  /**
   * Blocking variant of {@link io.vertx.mutiny.ext.mongo.MongoGridFsClient#uploadFileWithOptions(String,GridFsUploadOptions)}.
   * <p>
   * This method waits for the completion of the underlying asynchronous operation.
   * If the operation completes successfully, the result is returned, otherwise the failure is thrown (potentially wrapped in a RuntimeException).
   * @param fileName the name of the file to store in gridfs
   * @param options {@link io.vertx.ext.mongo.GridFsUploadOptions} for specifying metadata and chunk size
   * @return the String instance produced by the operation.
   */
  public String uploadFileWithOptionsAndAwait(String fileName, io.vertx.ext.mongo.GridFsUploadOptions options) { 
    return (String) uploadFileWithOptions(fileName, options).await().indefinitely();
  }

  /**
   * Variant of {@link io.vertx.mutiny.ext.mongo.MongoGridFsClient#uploadFileWithOptions(String,GridFsUploadOptions)} that ignores the result of the operation.
   * <p>
   * This method subscribes on the result of {@link io.vertx.mutiny.ext.mongo.MongoGridFsClient#uploadFileWithOptions(String,GridFsUploadOptions)}, but discards the outcome (item or failure).
   * This method is useful to trigger the asynchronous operation from {@link io.vertx.mutiny.ext.mongo.MongoGridFsClient#uploadFileWithOptions(String,GridFsUploadOptions)} but you don't need to compose it with other operations.
   * @param fileName the name of the file to store in gridfs
   * @param options {@link io.vertx.ext.mongo.GridFsUploadOptions} for specifying metadata and chunk size
   * @return the instance of MongoGridFsClient to chain method calls.
   */
  @Fluent
  public io.vertx.mutiny.ext.mongo.MongoGridFsClient uploadFileWithOptionsAndForget(String fileName, io.vertx.ext.mongo.GridFsUploadOptions options) { 
    uploadFileWithOptions(fileName, options).subscribe().with(io.smallrye.mutiny.vertx.UniHelper.NOOP);
    return this;
  }

  /**
   */
  public void close() { 
    delegate.close();
  }

  public static  MongoGridFsClient newInstance(io.vertx.ext.mongo.MongoGridFsClient arg) {
    return arg != null ? new MongoGridFsClient(arg) : null;
  }

}
