package io.vertx.mutiny.ext.mongo;

import java.util.Map;
import java.util.stream.Collectors;
import io.smallrye.mutiny.Multi;
import io.smallrye.mutiny.Uni;
import java.util.function.Consumer;
import io.smallrye.mutiny.vertx.TypeArg;
import io.vertx.codegen.annotations.Fluent;
import io.smallrye.common.annotation.CheckReturnValue;
import io.vertx.ext.mongo.MongoClientDeleteResult;
import com.mongodb.client.model.changestream.ChangeStreamDocument;
import io.vertx.ext.mongo.CountOptions;
import io.vertx.ext.mongo.BulkWriteOptions;
import io.vertx.core.json.JsonObject;
import io.vertx.core.AsyncResult;
import io.vertx.ext.mongo.CreateCollectionOptions;
import io.vertx.ext.mongo.DistinctOptions;
import io.vertx.ext.mongo.AggregateOptions;
import io.vertx.ext.mongo.WriteOption;
import io.vertx.ext.mongo.BulkOperation;
import io.vertx.ext.mongo.MongoClientBulkWriteResult;
import io.vertx.core.Future;
import io.vertx.ext.mongo.IndexModel;
import io.vertx.core.json.JsonArray;
import java.util.List;
import io.vertx.ext.mongo.IndexOptions;
import io.vertx.ext.mongo.FindOptions;
import io.vertx.core.Handler;
import io.vertx.ext.mongo.MongoClientUpdateResult;
import io.vertx.ext.mongo.UpdateOptions;

/**
 * A Vert.x service used to interact with MongoDB server instances.
 * <p>
 * Some of the operations might change <i>_id</i> field of passed  document.
 *
 * <p/>
 * NOTE: This class has been automatically generated from the {@link io.vertx.ext.mongo.MongoClient original} non Mutiny-ified interface using Vert.x codegen.
 */

@io.smallrye.mutiny.vertx.MutinyGen(io.vertx.ext.mongo.MongoClient.class)
public class MongoClient {

  public static final io.smallrye.mutiny.vertx.TypeArg<MongoClient> __TYPE_ARG = new io.smallrye.mutiny.vertx.TypeArg<>(    obj -> new MongoClient((io.vertx.ext.mongo.MongoClient) obj),
    MongoClient::getDelegate
  );

  private final io.vertx.ext.mongo.MongoClient delegate;
  
  public MongoClient(io.vertx.ext.mongo.MongoClient delegate) {
    this.delegate = delegate;
  }

  public MongoClient(Object delegate) {
    this.delegate = (io.vertx.ext.mongo.MongoClient)delegate;
  }

  /**
   * Empty constructor used by CDI, do not use this constructor directly.
   **/
  MongoClient() {
    this.delegate = null;
  }

  public io.vertx.ext.mongo.MongoClient getDelegate() {
    return delegate;
  }

  @Override
  public String toString() {
    return delegate.toString();
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    MongoClient that = (MongoClient) o;
    return delegate.equals(that.delegate);
  }
  
  @Override
  public int hashCode() {
    return delegate.hashCode();
  }

  /**
   * @param vertx the Vert.x instance
   * @param config the configuration
   * @return the client
   */
  public static io.vertx.mutiny.ext.mongo.MongoClient create(io.vertx.mutiny.core.Vertx vertx, JsonObject config) { 
    io.vertx.mutiny.ext.mongo.MongoClient ret = io.vertx.mutiny.ext.mongo.MongoClient.newInstance((io.vertx.ext.mongo.MongoClient)io.vertx.ext.mongo.MongoClient.create(vertx.getDelegate(), config));
    return ret;
  }

  /**
   * @param vertx the Vert.x instance
   * @param config the configuration
   * @param dataSourceName the data source name
   * @return the client
   */
  public static io.vertx.mutiny.ext.mongo.MongoClient createShared(io.vertx.mutiny.core.Vertx vertx, JsonObject config, String dataSourceName) { 
    io.vertx.mutiny.ext.mongo.MongoClient ret = io.vertx.mutiny.ext.mongo.MongoClient.newInstance((io.vertx.ext.mongo.MongoClient)io.vertx.ext.mongo.MongoClient.createShared(vertx.getDelegate(), config, dataSourceName));
    return ret;
  }

  /**
   * @param vertx the Vert.x instance
   * @param config the configuration
   * @return the client
   */
  public static io.vertx.mutiny.ext.mongo.MongoClient createShared(io.vertx.mutiny.core.Vertx vertx, JsonObject config) { 
    io.vertx.mutiny.ext.mongo.MongoClient ret = io.vertx.mutiny.ext.mongo.MongoClient.newInstance((io.vertx.ext.mongo.MongoClient)io.vertx.ext.mongo.MongoClient.createShared(vertx.getDelegate(), config));
    return ret;
  }

  /**
   * Save a document in the specified collection
   * <p>
   * This operation might change <i>_id</i> field of <i>document</i> parameter
   * <p>
   * Unlike the <em>bare</em> Vert.x variant, this method returns a {@link io.smallrye.mutiny.Uni Uni}.
   * Don't forget to <em>subscribe</em> on it to trigger the operation.
   * @param collection the collection
   * @param document the document
   * @return the {@link io.smallrye.mutiny.Uni uni} firing the result of the operation when completed, or a failure if the operation failed.
   */
  @CheckReturnValue
  public io.smallrye.mutiny.Uni<String> save(String collection, JsonObject document) { 
    return io.smallrye.mutiny.vertx.AsyncResultUni.toUni(resultHandler -> {
        delegate.save(collection, document, resultHandler);
    });
  }

  /**
   * Blocking variant of {@link io.vertx.mutiny.ext.mongo.MongoClient#save(String,JsonObject)}.
   * <p>
   * This method waits for the completion of the underlying asynchronous operation.
   * If the operation completes successfully, the result is returned, otherwise the failure is thrown (potentially wrapped in a RuntimeException).
   * @param collection the collection
   * @param document the document
   * @return the String instance produced by the operation.
   */
  public String saveAndAwait(String collection, JsonObject document) { 
    return (String) save(collection, document).await().indefinitely();
  }

  /**
   * Variant of {@link io.vertx.mutiny.ext.mongo.MongoClient#save(String,JsonObject)} that ignores the result of the operation.
   * <p>
   * This method subscribes on the result of {@link io.vertx.mutiny.ext.mongo.MongoClient#save(String,JsonObject)}, but discards the outcome (item or failure).
   * This method is useful to trigger the asynchronous operation from {@link io.vertx.mutiny.ext.mongo.MongoClient#save(String,JsonObject)} but you don't need to compose it with other operations.
   * @param collection the collection
   * @param document the document
   * @return the instance of MongoClient to chain method calls.
   */
  @Fluent
  public io.vertx.mutiny.ext.mongo.MongoClient saveAndForget(String collection, JsonObject document) { 
    save(collection, document).subscribe().with(io.smallrye.mutiny.vertx.UniHelper.NOOP);
    return this;
  }

  /**
   * Save a document in the specified collection with the specified write option
   * <p>
   * This operation might change <i>_id</i> field of <i>document</i> parameter
   * <p>
   * Unlike the <em>bare</em> Vert.x variant, this method returns a {@link io.smallrye.mutiny.Uni Uni}.
   * Don't forget to <em>subscribe</em> on it to trigger the operation.
   * @param collection the collection
   * @param document the document
   * @param writeOption the write option to use
   * @return the {@link io.smallrye.mutiny.Uni uni} firing the result of the operation when completed, or a failure if the operation failed.
   */
  @CheckReturnValue
  public io.smallrye.mutiny.Uni<String> saveWithOptions(String collection, JsonObject document, io.vertx.ext.mongo.WriteOption writeOption) { 
    return io.smallrye.mutiny.vertx.AsyncResultUni.toUni(resultHandler -> {
        delegate.saveWithOptions(collection, document, writeOption, resultHandler);
    });
  }

  /**
   * Blocking variant of {@link io.vertx.mutiny.ext.mongo.MongoClient#saveWithOptions(String,JsonObject,WriteOption)}.
   * <p>
   * This method waits for the completion of the underlying asynchronous operation.
   * If the operation completes successfully, the result is returned, otherwise the failure is thrown (potentially wrapped in a RuntimeException).
   * @param collection the collection
   * @param document the document
   * @param writeOption the write option to use
   * @return the String instance produced by the operation.
   */
  public String saveWithOptionsAndAwait(String collection, JsonObject document, io.vertx.ext.mongo.WriteOption writeOption) { 
    return (String) saveWithOptions(collection, document, writeOption).await().indefinitely();
  }

  /**
   * Variant of {@link io.vertx.mutiny.ext.mongo.MongoClient#saveWithOptions(String,JsonObject,WriteOption)} that ignores the result of the operation.
   * <p>
   * This method subscribes on the result of {@link io.vertx.mutiny.ext.mongo.MongoClient#saveWithOptions(String,JsonObject,WriteOption)}, but discards the outcome (item or failure).
   * This method is useful to trigger the asynchronous operation from {@link io.vertx.mutiny.ext.mongo.MongoClient#saveWithOptions(String,JsonObject,WriteOption)} but you don't need to compose it with other operations.
   * @param collection the collection
   * @param document the document
   * @param writeOption the write option to use
   * @return the instance of MongoClient to chain method calls.
   */
  @Fluent
  public io.vertx.mutiny.ext.mongo.MongoClient saveWithOptionsAndForget(String collection, JsonObject document, io.vertx.ext.mongo.WriteOption writeOption) { 
    saveWithOptions(collection, document, writeOption).subscribe().with(io.smallrye.mutiny.vertx.UniHelper.NOOP);
    return this;
  }

  /**
   * Insert a document in the specified collection
   * <p>
   * This operation might change <i>_id</i> field of <i>document</i> parameter
   * <p>
   * Unlike the <em>bare</em> Vert.x variant, this method returns a {@link io.smallrye.mutiny.Uni Uni}.
   * Don't forget to <em>subscribe</em> on it to trigger the operation.
   * @param collection the collection
   * @param document the document
   * @return the {@link io.smallrye.mutiny.Uni uni} firing the result of the operation when completed, or a failure if the operation failed.
   */
  @CheckReturnValue
  public io.smallrye.mutiny.Uni<String> insert(String collection, JsonObject document) { 
    return io.smallrye.mutiny.vertx.AsyncResultUni.toUni(resultHandler -> {
        delegate.insert(collection, document, resultHandler);
    });
  }

  /**
   * Blocking variant of {@link io.vertx.mutiny.ext.mongo.MongoClient#insert(String,JsonObject)}.
   * <p>
   * This method waits for the completion of the underlying asynchronous operation.
   * If the operation completes successfully, the result is returned, otherwise the failure is thrown (potentially wrapped in a RuntimeException).
   * @param collection the collection
   * @param document the document
   * @return the String instance produced by the operation.
   */
  public String insertAndAwait(String collection, JsonObject document) { 
    return (String) insert(collection, document).await().indefinitely();
  }

  /**
   * Variant of {@link io.vertx.mutiny.ext.mongo.MongoClient#insert(String,JsonObject)} that ignores the result of the operation.
   * <p>
   * This method subscribes on the result of {@link io.vertx.mutiny.ext.mongo.MongoClient#insert(String,JsonObject)}, but discards the outcome (item or failure).
   * This method is useful to trigger the asynchronous operation from {@link io.vertx.mutiny.ext.mongo.MongoClient#insert(String,JsonObject)} but you don't need to compose it with other operations.
   * @param collection the collection
   * @param document the document
   * @return the instance of MongoClient to chain method calls.
   */
  @Fluent
  public io.vertx.mutiny.ext.mongo.MongoClient insertAndForget(String collection, JsonObject document) { 
    insert(collection, document).subscribe().with(io.smallrye.mutiny.vertx.UniHelper.NOOP);
    return this;
  }

  /**
   * Insert a document in the specified collection with the specified write option
   * <p>
   * This operation might change <i>_id</i> field of <i>document</i> parameter
   * <p>
   * Unlike the <em>bare</em> Vert.x variant, this method returns a {@link io.smallrye.mutiny.Uni Uni}.
   * Don't forget to <em>subscribe</em> on it to trigger the operation.
   * @param collection the collection
   * @param document the document
   * @param writeOption the write option to use
   * @return the {@link io.smallrye.mutiny.Uni uni} firing the result of the operation when completed, or a failure if the operation failed.
   */
  @CheckReturnValue
  public io.smallrye.mutiny.Uni<String> insertWithOptions(String collection, JsonObject document, io.vertx.ext.mongo.WriteOption writeOption) { 
    return io.smallrye.mutiny.vertx.AsyncResultUni.toUni(resultHandler -> {
        delegate.insertWithOptions(collection, document, writeOption, resultHandler);
    });
  }

  /**
   * Blocking variant of {@link io.vertx.mutiny.ext.mongo.MongoClient#insertWithOptions(String,JsonObject,WriteOption)}.
   * <p>
   * This method waits for the completion of the underlying asynchronous operation.
   * If the operation completes successfully, the result is returned, otherwise the failure is thrown (potentially wrapped in a RuntimeException).
   * @param collection the collection
   * @param document the document
   * @param writeOption the write option to use
   * @return the String instance produced by the operation.
   */
  public String insertWithOptionsAndAwait(String collection, JsonObject document, io.vertx.ext.mongo.WriteOption writeOption) { 
    return (String) insertWithOptions(collection, document, writeOption).await().indefinitely();
  }

  /**
   * Variant of {@link io.vertx.mutiny.ext.mongo.MongoClient#insertWithOptions(String,JsonObject,WriteOption)} that ignores the result of the operation.
   * <p>
   * This method subscribes on the result of {@link io.vertx.mutiny.ext.mongo.MongoClient#insertWithOptions(String,JsonObject,WriteOption)}, but discards the outcome (item or failure).
   * This method is useful to trigger the asynchronous operation from {@link io.vertx.mutiny.ext.mongo.MongoClient#insertWithOptions(String,JsonObject,WriteOption)} but you don't need to compose it with other operations.
   * @param collection the collection
   * @param document the document
   * @param writeOption the write option to use
   * @return the instance of MongoClient to chain method calls.
   */
  @Fluent
  public io.vertx.mutiny.ext.mongo.MongoClient insertWithOptionsAndForget(String collection, JsonObject document, io.vertx.ext.mongo.WriteOption writeOption) { 
    insertWithOptions(collection, document, writeOption).subscribe().with(io.smallrye.mutiny.vertx.UniHelper.NOOP);
    return this;
  }

  /**
   * Update matching documents in the specified collection and return the handler with <code>MongoClientUpdateResult</code> result
   * <p>
   * Unlike the <em>bare</em> Vert.x variant, this method returns a {@link io.smallrye.mutiny.Uni Uni}.
   * Don't forget to <em>subscribe</em> on it to trigger the operation.
   * @param collection the collection
   * @param query query used to match the documents
   * @param update used to describe how the documents will be updated
   * @return the {@link io.smallrye.mutiny.Uni uni} firing the result of the operation when completed, or a failure if the operation failed.
   */
  @CheckReturnValue
  public io.smallrye.mutiny.Uni<io.vertx.ext.mongo.MongoClientUpdateResult> updateCollection(String collection, JsonObject query, JsonObject update) { 
    return io.smallrye.mutiny.vertx.AsyncResultUni.toUni(resultHandler -> {
        delegate.updateCollection(collection, query, update, resultHandler);
    });
  }

  /**
   * Blocking variant of {@link io.vertx.mutiny.ext.mongo.MongoClient#updateCollection(String,JsonObject,JsonObject)}.
   * <p>
   * This method waits for the completion of the underlying asynchronous operation.
   * If the operation completes successfully, the result is returned, otherwise the failure is thrown (potentially wrapped in a RuntimeException).
   * @param collection the collection
   * @param query query used to match the documents
   * @param update used to describe how the documents will be updated
   * @return the MongoClientUpdateResult instance produced by the operation.
   */
  public io.vertx.ext.mongo.MongoClientUpdateResult updateCollectionAndAwait(String collection, JsonObject query, JsonObject update) { 
    return (io.vertx.ext.mongo.MongoClientUpdateResult) updateCollection(collection, query, update).await().indefinitely();
  }

  /**
   * Variant of {@link io.vertx.mutiny.ext.mongo.MongoClient#updateCollection(String,JsonObject,JsonObject)} that ignores the result of the operation.
   * <p>
   * This method subscribes on the result of {@link io.vertx.mutiny.ext.mongo.MongoClient#updateCollection(String,JsonObject,JsonObject)}, but discards the outcome (item or failure).
   * This method is useful to trigger the asynchronous operation from {@link io.vertx.mutiny.ext.mongo.MongoClient#updateCollection(String,JsonObject,JsonObject)} but you don't need to compose it with other operations.
   * @param collection the collection
   * @param query query used to match the documents
   * @param update used to describe how the documents will be updated
   * @return the instance of MongoClient to chain method calls.
   */
  @Fluent
  public io.vertx.mutiny.ext.mongo.MongoClient updateCollectionAndForget(String collection, JsonObject query, JsonObject update) { 
    updateCollection(collection, query, update).subscribe().with(io.smallrye.mutiny.vertx.UniHelper.NOOP);
    return this;
  }

  /**
   * Use an aggregation pipeline to update documents in the specified collection and return the handler with <code>MongoClientUpdateResult</code> result
   * <p>
   * Unlike the <em>bare</em> Vert.x variant, this method returns a {@link io.smallrye.mutiny.Uni Uni}.
   * Don't forget to <em>subscribe</em> on it to trigger the operation.
   * @param collection the collection
   * @param query query used to match the documents
   * @param update used to describe how the documents will be updated
   * @return the {@link io.smallrye.mutiny.Uni uni} firing the result of the operation when completed, or a failure if the operation failed.
   */
  @CheckReturnValue
  public io.smallrye.mutiny.Uni<io.vertx.ext.mongo.MongoClientUpdateResult> updateCollection(String collection, JsonObject query, JsonArray update) { 
    return io.smallrye.mutiny.vertx.AsyncResultUni.toUni(resultHandler -> {
        delegate.updateCollection(collection, query, update, resultHandler);
    });
  }

  /**
   * Blocking variant of {@link io.vertx.mutiny.ext.mongo.MongoClient#updateCollection(String,JsonObject,JsonArray)}.
   * <p>
   * This method waits for the completion of the underlying asynchronous operation.
   * If the operation completes successfully, the result is returned, otherwise the failure is thrown (potentially wrapped in a RuntimeException).
   * @param collection the collection
   * @param query query used to match the documents
   * @param update used to describe how the documents will be updated
   * @return the MongoClientUpdateResult instance produced by the operation.
   */
  public io.vertx.ext.mongo.MongoClientUpdateResult updateCollectionAndAwait(String collection, JsonObject query, JsonArray update) { 
    return (io.vertx.ext.mongo.MongoClientUpdateResult) updateCollection(collection, query, update).await().indefinitely();
  }

  /**
   * Variant of {@link io.vertx.mutiny.ext.mongo.MongoClient#updateCollection(String,JsonObject,JsonArray)} that ignores the result of the operation.
   * <p>
   * This method subscribes on the result of {@link io.vertx.mutiny.ext.mongo.MongoClient#updateCollection(String,JsonObject,JsonArray)}, but discards the outcome (item or failure).
   * This method is useful to trigger the asynchronous operation from {@link io.vertx.mutiny.ext.mongo.MongoClient#updateCollection(String,JsonObject,JsonArray)} but you don't need to compose it with other operations.
   * @param collection the collection
   * @param query query used to match the documents
   * @param update used to describe how the documents will be updated
   * @return the instance of MongoClient to chain method calls.
   */
  @Fluent
  public io.vertx.mutiny.ext.mongo.MongoClient updateCollectionAndForget(String collection, JsonObject query, JsonArray update) { 
    updateCollection(collection, query, update).subscribe().with(io.smallrye.mutiny.vertx.UniHelper.NOOP);
    return this;
  }

  /**
   * Update matching documents in the specified collection, specifying options and return the handler with <code>MongoClientUpdateResult</code> result
   * <p>
   * Unlike the <em>bare</em> Vert.x variant, this method returns a {@link io.smallrye.mutiny.Uni Uni}.
   * Don't forget to <em>subscribe</em> on it to trigger the operation.
   * @param collection the collection
   * @param query query used to match the documents
   * @param update used to describe how the documents will be updated
   * @param options options to configure the update
   * @return the {@link io.smallrye.mutiny.Uni uni} firing the result of the operation when completed, or a failure if the operation failed.
   */
  @CheckReturnValue
  public io.smallrye.mutiny.Uni<io.vertx.ext.mongo.MongoClientUpdateResult> updateCollectionWithOptions(String collection, JsonObject query, JsonObject update, io.vertx.ext.mongo.UpdateOptions options) { 
    return io.smallrye.mutiny.vertx.AsyncResultUni.toUni(resultHandler -> {
        delegate.updateCollectionWithOptions(collection, query, update, options, resultHandler);
    });
  }

  /**
   * Blocking variant of {@link io.vertx.mutiny.ext.mongo.MongoClient#updateCollectionWithOptions(String,JsonObject,JsonObject,UpdateOptions)}.
   * <p>
   * This method waits for the completion of the underlying asynchronous operation.
   * If the operation completes successfully, the result is returned, otherwise the failure is thrown (potentially wrapped in a RuntimeException).
   * @param collection the collection
   * @param query query used to match the documents
   * @param update used to describe how the documents will be updated
   * @param options options to configure the update
   * @return the MongoClientUpdateResult instance produced by the operation.
   */
  public io.vertx.ext.mongo.MongoClientUpdateResult updateCollectionWithOptionsAndAwait(String collection, JsonObject query, JsonObject update, io.vertx.ext.mongo.UpdateOptions options) { 
    return (io.vertx.ext.mongo.MongoClientUpdateResult) updateCollectionWithOptions(collection, query, update, options).await().indefinitely();
  }

  /**
   * Variant of {@link io.vertx.mutiny.ext.mongo.MongoClient#updateCollectionWithOptions(String,JsonObject,JsonObject,UpdateOptions)} that ignores the result of the operation.
   * <p>
   * This method subscribes on the result of {@link io.vertx.mutiny.ext.mongo.MongoClient#updateCollectionWithOptions(String,JsonObject,JsonObject,UpdateOptions)}, but discards the outcome (item or failure).
   * This method is useful to trigger the asynchronous operation from {@link io.vertx.mutiny.ext.mongo.MongoClient#updateCollectionWithOptions(String,JsonObject,JsonObject,UpdateOptions)} but you don't need to compose it with other operations.
   * @param collection the collection
   * @param query query used to match the documents
   * @param update used to describe how the documents will be updated
   * @param options options to configure the update
   * @return the instance of MongoClient to chain method calls.
   */
  @Fluent
  public io.vertx.mutiny.ext.mongo.MongoClient updateCollectionWithOptionsAndForget(String collection, JsonObject query, JsonObject update, io.vertx.ext.mongo.UpdateOptions options) { 
    updateCollectionWithOptions(collection, query, update, options).subscribe().with(io.smallrye.mutiny.vertx.UniHelper.NOOP);
    return this;
  }

  /**
   * Use an aggregation pipeline to update documents in the specified collection, specifying options and return the handler with <code>MongoClientUpdateResult</code> result
   * <p>
   * Unlike the <em>bare</em> Vert.x variant, this method returns a {@link io.smallrye.mutiny.Uni Uni}.
   * Don't forget to <em>subscribe</em> on it to trigger the operation.
   * @param collection the collection
   * @param query query used to match the documents
   * @param update aggregation pipeline used to describe how documents will be updated
   * @param options options to configure the update
   * @return the {@link io.smallrye.mutiny.Uni uni} firing the result of the operation when completed, or a failure if the operation failed.
   */
  @CheckReturnValue
  public io.smallrye.mutiny.Uni<io.vertx.ext.mongo.MongoClientUpdateResult> updateCollectionWithOptions(String collection, JsonObject query, JsonArray update, io.vertx.ext.mongo.UpdateOptions options) { 
    return io.smallrye.mutiny.vertx.AsyncResultUni.toUni(resultHandler -> {
        delegate.updateCollectionWithOptions(collection, query, update, options, resultHandler);
    });
  }

  /**
   * Blocking variant of {@link io.vertx.mutiny.ext.mongo.MongoClient#updateCollectionWithOptions(String,JsonObject,JsonArray,UpdateOptions)}.
   * <p>
   * This method waits for the completion of the underlying asynchronous operation.
   * If the operation completes successfully, the result is returned, otherwise the failure is thrown (potentially wrapped in a RuntimeException).
   * @param collection the collection
   * @param query query used to match the documents
   * @param update aggregation pipeline used to describe how documents will be updated
   * @param options options to configure the update
   * @return the MongoClientUpdateResult instance produced by the operation.
   */
  public io.vertx.ext.mongo.MongoClientUpdateResult updateCollectionWithOptionsAndAwait(String collection, JsonObject query, JsonArray update, io.vertx.ext.mongo.UpdateOptions options) { 
    return (io.vertx.ext.mongo.MongoClientUpdateResult) updateCollectionWithOptions(collection, query, update, options).await().indefinitely();
  }

  /**
   * Variant of {@link io.vertx.mutiny.ext.mongo.MongoClient#updateCollectionWithOptions(String,JsonObject,JsonArray,UpdateOptions)} that ignores the result of the operation.
   * <p>
   * This method subscribes on the result of {@link io.vertx.mutiny.ext.mongo.MongoClient#updateCollectionWithOptions(String,JsonObject,JsonArray,UpdateOptions)}, but discards the outcome (item or failure).
   * This method is useful to trigger the asynchronous operation from {@link io.vertx.mutiny.ext.mongo.MongoClient#updateCollectionWithOptions(String,JsonObject,JsonArray,UpdateOptions)} but you don't need to compose it with other operations.
   * @param collection the collection
   * @param query query used to match the documents
   * @param update aggregation pipeline used to describe how documents will be updated
   * @param options options to configure the update
   * @return the instance of MongoClient to chain method calls.
   */
  @Fluent
  public io.vertx.mutiny.ext.mongo.MongoClient updateCollectionWithOptionsAndForget(String collection, JsonObject query, JsonArray update, io.vertx.ext.mongo.UpdateOptions options) { 
    updateCollectionWithOptions(collection, query, update, options).subscribe().with(io.smallrye.mutiny.vertx.UniHelper.NOOP);
    return this;
  }

  /**
   * Replace matching documents in the specified collection and return the handler with <code>MongoClientUpdateResult</code> result
   * <p>
   * Unlike the <em>bare</em> Vert.x variant, this method returns a {@link io.smallrye.mutiny.Uni Uni}.
   * Don't forget to <em>subscribe</em> on it to trigger the operation.
   * @param collection the collection
   * @param query query used to match the documents
   * @param replace all matching documents will be replaced with this
   * @return the {@link io.smallrye.mutiny.Uni uni} firing the result of the operation when completed, or a failure if the operation failed.
   */
  @CheckReturnValue
  public io.smallrye.mutiny.Uni<io.vertx.ext.mongo.MongoClientUpdateResult> replaceDocuments(String collection, JsonObject query, JsonObject replace) { 
    return io.smallrye.mutiny.vertx.AsyncResultUni.toUni(resultHandler -> {
        delegate.replaceDocuments(collection, query, replace, resultHandler);
    });
  }

  /**
   * Blocking variant of {@link io.vertx.mutiny.ext.mongo.MongoClient#replaceDocuments(String,JsonObject,JsonObject)}.
   * <p>
   * This method waits for the completion of the underlying asynchronous operation.
   * If the operation completes successfully, the result is returned, otherwise the failure is thrown (potentially wrapped in a RuntimeException).
   * @param collection the collection
   * @param query query used to match the documents
   * @param replace all matching documents will be replaced with this
   * @return the MongoClientUpdateResult instance produced by the operation.
   */
  public io.vertx.ext.mongo.MongoClientUpdateResult replaceDocumentsAndAwait(String collection, JsonObject query, JsonObject replace) { 
    return (io.vertx.ext.mongo.MongoClientUpdateResult) replaceDocuments(collection, query, replace).await().indefinitely();
  }

  /**
   * Variant of {@link io.vertx.mutiny.ext.mongo.MongoClient#replaceDocuments(String,JsonObject,JsonObject)} that ignores the result of the operation.
   * <p>
   * This method subscribes on the result of {@link io.vertx.mutiny.ext.mongo.MongoClient#replaceDocuments(String,JsonObject,JsonObject)}, but discards the outcome (item or failure).
   * This method is useful to trigger the asynchronous operation from {@link io.vertx.mutiny.ext.mongo.MongoClient#replaceDocuments(String,JsonObject,JsonObject)} but you don't need to compose it with other operations.
   * @param collection the collection
   * @param query query used to match the documents
   * @param replace all matching documents will be replaced with this
   * @return the instance of MongoClient to chain method calls.
   */
  @Fluent
  public io.vertx.mutiny.ext.mongo.MongoClient replaceDocumentsAndForget(String collection, JsonObject query, JsonObject replace) { 
    replaceDocuments(collection, query, replace).subscribe().with(io.smallrye.mutiny.vertx.UniHelper.NOOP);
    return this;
  }

  /**
   * Replace matching documents in the specified collection, specifying options and return the handler with <code>MongoClientUpdateResult</code> result
   * <p>
   * Unlike the <em>bare</em> Vert.x variant, this method returns a {@link io.smallrye.mutiny.Uni Uni}.
   * Don't forget to <em>subscribe</em> on it to trigger the operation.
   * @param collection the collection
   * @param query query used to match the documents
   * @param replace all matching documents will be replaced with this
   * @param options options to configure the replace
   * @return the {@link io.smallrye.mutiny.Uni uni} firing the result of the operation when completed, or a failure if the operation failed.
   */
  @CheckReturnValue
  public io.smallrye.mutiny.Uni<io.vertx.ext.mongo.MongoClientUpdateResult> replaceDocumentsWithOptions(String collection, JsonObject query, JsonObject replace, io.vertx.ext.mongo.UpdateOptions options) { 
    return io.smallrye.mutiny.vertx.AsyncResultUni.toUni(resultHandler -> {
        delegate.replaceDocumentsWithOptions(collection, query, replace, options, resultHandler);
    });
  }

  /**
   * Blocking variant of {@link io.vertx.mutiny.ext.mongo.MongoClient#replaceDocumentsWithOptions(String,JsonObject,JsonObject,UpdateOptions)}.
   * <p>
   * This method waits for the completion of the underlying asynchronous operation.
   * If the operation completes successfully, the result is returned, otherwise the failure is thrown (potentially wrapped in a RuntimeException).
   * @param collection the collection
   * @param query query used to match the documents
   * @param replace all matching documents will be replaced with this
   * @param options options to configure the replace
   * @return the MongoClientUpdateResult instance produced by the operation.
   */
  public io.vertx.ext.mongo.MongoClientUpdateResult replaceDocumentsWithOptionsAndAwait(String collection, JsonObject query, JsonObject replace, io.vertx.ext.mongo.UpdateOptions options) { 
    return (io.vertx.ext.mongo.MongoClientUpdateResult) replaceDocumentsWithOptions(collection, query, replace, options).await().indefinitely();
  }

  /**
   * Variant of {@link io.vertx.mutiny.ext.mongo.MongoClient#replaceDocumentsWithOptions(String,JsonObject,JsonObject,UpdateOptions)} that ignores the result of the operation.
   * <p>
   * This method subscribes on the result of {@link io.vertx.mutiny.ext.mongo.MongoClient#replaceDocumentsWithOptions(String,JsonObject,JsonObject,UpdateOptions)}, but discards the outcome (item or failure).
   * This method is useful to trigger the asynchronous operation from {@link io.vertx.mutiny.ext.mongo.MongoClient#replaceDocumentsWithOptions(String,JsonObject,JsonObject,UpdateOptions)} but you don't need to compose it with other operations.
   * @param collection the collection
   * @param query query used to match the documents
   * @param replace all matching documents will be replaced with this
   * @param options options to configure the replace
   * @return the instance of MongoClient to chain method calls.
   */
  @Fluent
  public io.vertx.mutiny.ext.mongo.MongoClient replaceDocumentsWithOptionsAndForget(String collection, JsonObject query, JsonObject replace, io.vertx.ext.mongo.UpdateOptions options) { 
    replaceDocumentsWithOptions(collection, query, replace, options).subscribe().with(io.smallrye.mutiny.vertx.UniHelper.NOOP);
    return this;
  }

  /**
   * Execute a bulk operation. Can insert, update, replace, and/or delete multiple documents with one request.
   * <p>
   * Unlike the <em>bare</em> Vert.x variant, this method returns a {@link io.smallrye.mutiny.Uni Uni}.
   * Don't forget to <em>subscribe</em> on it to trigger the operation.
   * @param collection the collection
   * @param operations the operations to execute
   * @return the {@link io.smallrye.mutiny.Uni uni} firing the result of the operation when completed, or a failure if the operation failed.
   */
  @CheckReturnValue
  public io.smallrye.mutiny.Uni<io.vertx.ext.mongo.MongoClientBulkWriteResult> bulkWrite(String collection, List<io.vertx.ext.mongo.BulkOperation> operations) { 
    return io.smallrye.mutiny.vertx.AsyncResultUni.toUni(resultHandler -> {
        delegate.bulkWrite(collection, operations, resultHandler);
    });
  }

  /**
   * Blocking variant of {@link io.vertx.mutiny.ext.mongo.MongoClient#bulkWrite(String,List)}.
   * <p>
   * This method waits for the completion of the underlying asynchronous operation.
   * If the operation completes successfully, the result is returned, otherwise the failure is thrown (potentially wrapped in a RuntimeException).
   * @param collection the collection
   * @param operations the operations to execute
   * @return the MongoClientBulkWriteResult instance produced by the operation.
   */
  public io.vertx.ext.mongo.MongoClientBulkWriteResult bulkWriteAndAwait(String collection, List<io.vertx.ext.mongo.BulkOperation> operations) { 
    return (io.vertx.ext.mongo.MongoClientBulkWriteResult) bulkWrite(collection, operations).await().indefinitely();
  }

  /**
   * Variant of {@link io.vertx.mutiny.ext.mongo.MongoClient#bulkWrite(String,List)} that ignores the result of the operation.
   * <p>
   * This method subscribes on the result of {@link io.vertx.mutiny.ext.mongo.MongoClient#bulkWrite(String,List)}, but discards the outcome (item or failure).
   * This method is useful to trigger the asynchronous operation from {@link io.vertx.mutiny.ext.mongo.MongoClient#bulkWrite(String,List)} but you don't need to compose it with other operations.
   * @param collection the collection
   * @param operations the operations to execute
   * @return the instance of MongoClient to chain method calls.
   */
  @Fluent
  public io.vertx.mutiny.ext.mongo.MongoClient bulkWriteAndForget(String collection, List<io.vertx.ext.mongo.BulkOperation> operations) { 
    bulkWrite(collection, operations).subscribe().with(io.smallrye.mutiny.vertx.UniHelper.NOOP);
    return this;
  }

  /**
   * Execute a bulk operation with the specified write options. Can insert, update, replace, and/or delete multiple
   * documents with one request.
   * <p>
   * Unlike the <em>bare</em> Vert.x variant, this method returns a {@link io.smallrye.mutiny.Uni Uni}.
   * Don't forget to <em>subscribe</em> on it to trigger the operation.
   * @param collection the collection
   * @param operations the operations to execute
   * @param bulkWriteOptions the write options
   * @return the {@link io.smallrye.mutiny.Uni uni} firing the result of the operation when completed, or a failure if the operation failed.
   */
  @CheckReturnValue
  public io.smallrye.mutiny.Uni<io.vertx.ext.mongo.MongoClientBulkWriteResult> bulkWriteWithOptions(String collection, List<io.vertx.ext.mongo.BulkOperation> operations, io.vertx.ext.mongo.BulkWriteOptions bulkWriteOptions) { 
    return io.smallrye.mutiny.vertx.AsyncResultUni.toUni(resultHandler -> {
        delegate.bulkWriteWithOptions(collection, operations, bulkWriteOptions, resultHandler);
    });
  }

  /**
   * Blocking variant of {@link io.vertx.mutiny.ext.mongo.MongoClient#bulkWriteWithOptions(String,List,BulkWriteOptions)}.
   * <p>
   * This method waits for the completion of the underlying asynchronous operation.
   * If the operation completes successfully, the result is returned, otherwise the failure is thrown (potentially wrapped in a RuntimeException).
   * @param collection the collection
   * @param operations the operations to execute
   * @param bulkWriteOptions the write options
   * @return the MongoClientBulkWriteResult instance produced by the operation.
   */
  public io.vertx.ext.mongo.MongoClientBulkWriteResult bulkWriteWithOptionsAndAwait(String collection, List<io.vertx.ext.mongo.BulkOperation> operations, io.vertx.ext.mongo.BulkWriteOptions bulkWriteOptions) { 
    return (io.vertx.ext.mongo.MongoClientBulkWriteResult) bulkWriteWithOptions(collection, operations, bulkWriteOptions).await().indefinitely();
  }

  /**
   * Variant of {@link io.vertx.mutiny.ext.mongo.MongoClient#bulkWriteWithOptions(String,List,BulkWriteOptions)} that ignores the result of the operation.
   * <p>
   * This method subscribes on the result of {@link io.vertx.mutiny.ext.mongo.MongoClient#bulkWriteWithOptions(String,List,BulkWriteOptions)}, but discards the outcome (item or failure).
   * This method is useful to trigger the asynchronous operation from {@link io.vertx.mutiny.ext.mongo.MongoClient#bulkWriteWithOptions(String,List,BulkWriteOptions)} but you don't need to compose it with other operations.
   * @param collection the collection
   * @param operations the operations to execute
   * @param bulkWriteOptions the write options
   * @return the instance of MongoClient to chain method calls.
   */
  @Fluent
  public io.vertx.mutiny.ext.mongo.MongoClient bulkWriteWithOptionsAndForget(String collection, List<io.vertx.ext.mongo.BulkOperation> operations, io.vertx.ext.mongo.BulkWriteOptions bulkWriteOptions) { 
    bulkWriteWithOptions(collection, operations, bulkWriteOptions).subscribe().with(io.smallrye.mutiny.vertx.UniHelper.NOOP);
    return this;
  }

  /**
   * Find matching documents in the specified collection
   * <p>
   * Unlike the <em>bare</em> Vert.x variant, this method returns a {@link io.smallrye.mutiny.Uni Uni}.
   * Don't forget to <em>subscribe</em> on it to trigger the operation.
   * @param collection the collection
   * @param query query used to match documents
   * @return the {@link io.smallrye.mutiny.Uni uni} firing the result of the operation when completed, or a failure if the operation failed.
   */
  @CheckReturnValue
  public io.smallrye.mutiny.Uni<List<JsonObject>> find(String collection, JsonObject query) { 
    return io.smallrye.mutiny.vertx.AsyncResultUni.toUni(resultHandler -> {
        delegate.find(collection, query, resultHandler);
    });
  }

  /**
   * Blocking variant of {@link io.vertx.mutiny.ext.mongo.MongoClient#find(String,JsonObject)}.
   * <p>
   * This method waits for the completion of the underlying asynchronous operation.
   * If the operation completes successfully, the result is returned, otherwise the failure is thrown (potentially wrapped in a RuntimeException).
   * @param collection the collection
   * @param query query used to match documents
   * @return the List<JsonObject> instance produced by the operation.
   */
  public List<JsonObject> findAndAwait(String collection, JsonObject query) { 
    return (List<JsonObject>) find(collection, query).await().indefinitely();
  }

  /**
   * Variant of {@link io.vertx.mutiny.ext.mongo.MongoClient#find(String,JsonObject)} that ignores the result of the operation.
   * <p>
   * This method subscribes on the result of {@link io.vertx.mutiny.ext.mongo.MongoClient#find(String,JsonObject)}, but discards the outcome (item or failure).
   * This method is useful to trigger the asynchronous operation from {@link io.vertx.mutiny.ext.mongo.MongoClient#find(String,JsonObject)} but you don't need to compose it with other operations.
   * @param collection the collection
   * @param query query used to match documents
   * @return the instance of MongoClient to chain method calls.
   */
  @Fluent
  public io.vertx.mutiny.ext.mongo.MongoClient findAndForget(String collection, JsonObject query) { 
    find(collection, query).subscribe().with(io.smallrye.mutiny.vertx.UniHelper.NOOP);
    return this;
  }

  /**
   * @param collection the collection
   * @param query query used to match documents
   * @return a  emitting found documents
   */
  public io.vertx.mutiny.core.streams.ReadStream<JsonObject> findBatch(String collection, JsonObject query) { 
    io.vertx.mutiny.core.streams.ReadStream<JsonObject> ret = io.vertx.mutiny.core.streams.ReadStream.newInstance((io.vertx.core.streams.ReadStream)delegate.findBatch(collection, query), TypeArg.unknown());
    return ret;
  }

  /**
   * Find matching documents in the specified collection, specifying options
   * <p>
   * Unlike the <em>bare</em> Vert.x variant, this method returns a {@link io.smallrye.mutiny.Uni Uni}.
   * Don't forget to <em>subscribe</em> on it to trigger the operation.
   * @param collection the collection
   * @param query query used to match documents
   * @param options options to configure the find
   * @return the {@link io.smallrye.mutiny.Uni uni} firing the result of the operation when completed, or a failure if the operation failed.
   */
  @CheckReturnValue
  public io.smallrye.mutiny.Uni<List<JsonObject>> findWithOptions(String collection, JsonObject query, io.vertx.ext.mongo.FindOptions options) { 
    return io.smallrye.mutiny.vertx.AsyncResultUni.toUni(resultHandler -> {
        delegate.findWithOptions(collection, query, options, resultHandler);
    });
  }

  /**
   * Blocking variant of {@link io.vertx.mutiny.ext.mongo.MongoClient#findWithOptions(String,JsonObject,FindOptions)}.
   * <p>
   * This method waits for the completion of the underlying asynchronous operation.
   * If the operation completes successfully, the result is returned, otherwise the failure is thrown (potentially wrapped in a RuntimeException).
   * @param collection the collection
   * @param query query used to match documents
   * @param options options to configure the find
   * @return the List<JsonObject> instance produced by the operation.
   */
  public List<JsonObject> findWithOptionsAndAwait(String collection, JsonObject query, io.vertx.ext.mongo.FindOptions options) { 
    return (List<JsonObject>) findWithOptions(collection, query, options).await().indefinitely();
  }

  /**
   * Variant of {@link io.vertx.mutiny.ext.mongo.MongoClient#findWithOptions(String,JsonObject,FindOptions)} that ignores the result of the operation.
   * <p>
   * This method subscribes on the result of {@link io.vertx.mutiny.ext.mongo.MongoClient#findWithOptions(String,JsonObject,FindOptions)}, but discards the outcome (item or failure).
   * This method is useful to trigger the asynchronous operation from {@link io.vertx.mutiny.ext.mongo.MongoClient#findWithOptions(String,JsonObject,FindOptions)} but you don't need to compose it with other operations.
   * @param collection the collection
   * @param query query used to match documents
   * @param options options to configure the find
   * @return the instance of MongoClient to chain method calls.
   */
  @Fluent
  public io.vertx.mutiny.ext.mongo.MongoClient findWithOptionsAndForget(String collection, JsonObject query, io.vertx.ext.mongo.FindOptions options) { 
    findWithOptions(collection, query, options).subscribe().with(io.smallrye.mutiny.vertx.UniHelper.NOOP);
    return this;
  }

  /**
   * @param collection the collection
   * @param query query used to match documents
   * @param options options to configure the find
   * @return a  emitting found documents
   */
  public io.vertx.mutiny.core.streams.ReadStream<JsonObject> findBatchWithOptions(String collection, JsonObject query, io.vertx.ext.mongo.FindOptions options) { 
    io.vertx.mutiny.core.streams.ReadStream<JsonObject> ret = io.vertx.mutiny.core.streams.ReadStream.newInstance((io.vertx.core.streams.ReadStream)delegate.findBatchWithOptions(collection, query, options), TypeArg.unknown());
    return ret;
  }

  /**
   * Find a single matching document in the specified collection
   * <p>
   * This operation might change <i>_id</i> field of <i>query</i> parameter
   * <p>
   * Unlike the <em>bare</em> Vert.x variant, this method returns a {@link io.smallrye.mutiny.Uni Uni}.
   * Don't forget to <em>subscribe</em> on it to trigger the operation.
   * @param collection the collection
   * @param query the query used to match the document
   * @param fields the fields
   * @return the {@link io.smallrye.mutiny.Uni uni} firing the result of the operation when completed, or a failure if the operation failed.
   */
  @CheckReturnValue
  public io.smallrye.mutiny.Uni<JsonObject> findOne(String collection, JsonObject query, JsonObject fields) { 
    return io.smallrye.mutiny.vertx.AsyncResultUni.toUni(resultHandler -> {
        delegate.findOne(collection, query, fields, resultHandler);
    });
  }

  /**
   * Blocking variant of {@link io.vertx.mutiny.ext.mongo.MongoClient#findOne(String,JsonObject,JsonObject)}.
   * <p>
   * This method waits for the completion of the underlying asynchronous operation.
   * If the operation completes successfully, the result is returned, otherwise the failure is thrown (potentially wrapped in a RuntimeException).
   * @param collection the collection
   * @param query the query used to match the document
   * @param fields the fields
   * @return the JsonObject instance produced by the operation.
   */
  public JsonObject findOneAndAwait(String collection, JsonObject query, JsonObject fields) { 
    return (JsonObject) findOne(collection, query, fields).await().indefinitely();
  }

  /**
   * Variant of {@link io.vertx.mutiny.ext.mongo.MongoClient#findOne(String,JsonObject,JsonObject)} that ignores the result of the operation.
   * <p>
   * This method subscribes on the result of {@link io.vertx.mutiny.ext.mongo.MongoClient#findOne(String,JsonObject,JsonObject)}, but discards the outcome (item or failure).
   * This method is useful to trigger the asynchronous operation from {@link io.vertx.mutiny.ext.mongo.MongoClient#findOne(String,JsonObject,JsonObject)} but you don't need to compose it with other operations.
   * @param collection the collection
   * @param query the query used to match the document
   * @param fields the fields
   * @return the instance of MongoClient to chain method calls.
   */
  @Fluent
  public io.vertx.mutiny.ext.mongo.MongoClient findOneAndForget(String collection, JsonObject query, JsonObject fields) { 
    findOne(collection, query, fields).subscribe().with(io.smallrye.mutiny.vertx.UniHelper.NOOP);
    return this;
  }

  /**
   * Find a single matching document in the specified collection and update it.
   * <p>
   * This operation might change <i>_id</i> field of <i>query</i> parameter
   * <p>
   * Unlike the <em>bare</em> Vert.x variant, this method returns a {@link io.smallrye.mutiny.Uni Uni}.
   * Don't forget to <em>subscribe</em> on it to trigger the operation.
   * @param collection the collection
   * @param query the query used to match the document
   * @param update used to describe how the documents will be updated
   * @return the {@link io.smallrye.mutiny.Uni uni} firing the result of the operation when completed, or a failure if the operation failed.
   */
  @CheckReturnValue
  public io.smallrye.mutiny.Uni<JsonObject> findOneAndUpdate(String collection, JsonObject query, JsonObject update) { 
    return io.smallrye.mutiny.vertx.AsyncResultUni.toUni(resultHandler -> {
        delegate.findOneAndUpdate(collection, query, update, resultHandler);
    });
  }

  /**
   * Blocking variant of {@link io.vertx.mutiny.ext.mongo.MongoClient#findOneAndUpdate(String,JsonObject,JsonObject)}.
   * <p>
   * This method waits for the completion of the underlying asynchronous operation.
   * If the operation completes successfully, the result is returned, otherwise the failure is thrown (potentially wrapped in a RuntimeException).
   * @param collection the collection
   * @param query the query used to match the document
   * @param update used to describe how the documents will be updated
   * @return the JsonObject instance produced by the operation.
   */
  public JsonObject findOneAndUpdateAndAwait(String collection, JsonObject query, JsonObject update) { 
    return (JsonObject) findOneAndUpdate(collection, query, update).await().indefinitely();
  }

  /**
   * Variant of {@link io.vertx.mutiny.ext.mongo.MongoClient#findOneAndUpdate(String,JsonObject,JsonObject)} that ignores the result of the operation.
   * <p>
   * This method subscribes on the result of {@link io.vertx.mutiny.ext.mongo.MongoClient#findOneAndUpdate(String,JsonObject,JsonObject)}, but discards the outcome (item or failure).
   * This method is useful to trigger the asynchronous operation from {@link io.vertx.mutiny.ext.mongo.MongoClient#findOneAndUpdate(String,JsonObject,JsonObject)} but you don't need to compose it with other operations.
   * @param collection the collection
   * @param query the query used to match the document
   * @param update used to describe how the documents will be updated
   * @return the instance of MongoClient to chain method calls.
   */
  @Fluent
  public io.vertx.mutiny.ext.mongo.MongoClient findOneAndUpdateAndForget(String collection, JsonObject query, JsonObject update) { 
    findOneAndUpdate(collection, query, update).subscribe().with(io.smallrye.mutiny.vertx.UniHelper.NOOP);
    return this;
  }

  /**
   * Find a single matching document in the specified collection and update it.
   * <p>
   * This operation might change <i>_id</i> field of <i>query</i> parameter
   * <p>
   * Unlike the <em>bare</em> Vert.x variant, this method returns a {@link io.smallrye.mutiny.Uni Uni}.
   * Don't forget to <em>subscribe</em> on it to trigger the operation.
   * @param collection the collection
   * @param query the query used to match the document
   * @param update used to describe how the documents will be updated
   * @param findOptions options to configure the find
   * @param updateOptions options to configure the update
   * @return the {@link io.smallrye.mutiny.Uni uni} firing the result of the operation when completed, or a failure if the operation failed.
   */
  @CheckReturnValue
  public io.smallrye.mutiny.Uni<JsonObject> findOneAndUpdateWithOptions(String collection, JsonObject query, JsonObject update, io.vertx.ext.mongo.FindOptions findOptions, io.vertx.ext.mongo.UpdateOptions updateOptions) { 
    return io.smallrye.mutiny.vertx.AsyncResultUni.toUni(resultHandler -> {
        delegate.findOneAndUpdateWithOptions(collection, query, update, findOptions, updateOptions, resultHandler);
    });
  }

  /**
   * Blocking variant of {@link io.vertx.mutiny.ext.mongo.MongoClient#findOneAndUpdateWithOptions(String,JsonObject,JsonObject,FindOptions,UpdateOptions)}.
   * <p>
   * This method waits for the completion of the underlying asynchronous operation.
   * If the operation completes successfully, the result is returned, otherwise the failure is thrown (potentially wrapped in a RuntimeException).
   * @param collection the collection
   * @param query the query used to match the document
   * @param update used to describe how the documents will be updated
   * @param findOptions options to configure the find
   * @param updateOptions options to configure the update
   * @return the JsonObject instance produced by the operation.
   */
  public JsonObject findOneAndUpdateWithOptionsAndAwait(String collection, JsonObject query, JsonObject update, io.vertx.ext.mongo.FindOptions findOptions, io.vertx.ext.mongo.UpdateOptions updateOptions) { 
    return (JsonObject) findOneAndUpdateWithOptions(collection, query, update, findOptions, updateOptions).await().indefinitely();
  }

  /**
   * Variant of {@link io.vertx.mutiny.ext.mongo.MongoClient#findOneAndUpdateWithOptions(String,JsonObject,JsonObject,FindOptions,UpdateOptions)} that ignores the result of the operation.
   * <p>
   * This method subscribes on the result of {@link io.vertx.mutiny.ext.mongo.MongoClient#findOneAndUpdateWithOptions(String,JsonObject,JsonObject,FindOptions,UpdateOptions)}, but discards the outcome (item or failure).
   * This method is useful to trigger the asynchronous operation from {@link io.vertx.mutiny.ext.mongo.MongoClient#findOneAndUpdateWithOptions(String,JsonObject,JsonObject,FindOptions,UpdateOptions)} but you don't need to compose it with other operations.
   * @param collection the collection
   * @param query the query used to match the document
   * @param update used to describe how the documents will be updated
   * @param findOptions options to configure the find
   * @param updateOptions options to configure the update
   * @return the instance of MongoClient to chain method calls.
   */
  @Fluent
  public io.vertx.mutiny.ext.mongo.MongoClient findOneAndUpdateWithOptionsAndForget(String collection, JsonObject query, JsonObject update, io.vertx.ext.mongo.FindOptions findOptions, io.vertx.ext.mongo.UpdateOptions updateOptions) { 
    findOneAndUpdateWithOptions(collection, query, update, findOptions, updateOptions).subscribe().with(io.smallrye.mutiny.vertx.UniHelper.NOOP);
    return this;
  }

  /**
   * Find a single matching document in the specified collection and replace it.
   * <p>
   * This operation might change <i>_id</i> field of <i>query</i> parameter
   * <p>
   * Unlike the <em>bare</em> Vert.x variant, this method returns a {@link io.smallrye.mutiny.Uni Uni}.
   * Don't forget to <em>subscribe</em> on it to trigger the operation.
   * @param collection the collection
   * @param query the query used to match the document
   * @param replace the replacement document
   * @return the {@link io.smallrye.mutiny.Uni uni} firing the result of the operation when completed, or a failure if the operation failed.
   */
  @CheckReturnValue
  public io.smallrye.mutiny.Uni<JsonObject> findOneAndReplace(String collection, JsonObject query, JsonObject replace) { 
    return io.smallrye.mutiny.vertx.AsyncResultUni.toUni(resultHandler -> {
        delegate.findOneAndReplace(collection, query, replace, resultHandler);
    });
  }

  /**
   * Blocking variant of {@link io.vertx.mutiny.ext.mongo.MongoClient#findOneAndReplace(String,JsonObject,JsonObject)}.
   * <p>
   * This method waits for the completion of the underlying asynchronous operation.
   * If the operation completes successfully, the result is returned, otherwise the failure is thrown (potentially wrapped in a RuntimeException).
   * @param collection the collection
   * @param query the query used to match the document
   * @param replace the replacement document
   * @return the JsonObject instance produced by the operation.
   */
  public JsonObject findOneAndReplaceAndAwait(String collection, JsonObject query, JsonObject replace) { 
    return (JsonObject) findOneAndReplace(collection, query, replace).await().indefinitely();
  }

  /**
   * Variant of {@link io.vertx.mutiny.ext.mongo.MongoClient#findOneAndReplace(String,JsonObject,JsonObject)} that ignores the result of the operation.
   * <p>
   * This method subscribes on the result of {@link io.vertx.mutiny.ext.mongo.MongoClient#findOneAndReplace(String,JsonObject,JsonObject)}, but discards the outcome (item or failure).
   * This method is useful to trigger the asynchronous operation from {@link io.vertx.mutiny.ext.mongo.MongoClient#findOneAndReplace(String,JsonObject,JsonObject)} but you don't need to compose it with other operations.
   * @param collection the collection
   * @param query the query used to match the document
   * @param replace the replacement document
   * @return the instance of MongoClient to chain method calls.
   */
  @Fluent
  public io.vertx.mutiny.ext.mongo.MongoClient findOneAndReplaceAndForget(String collection, JsonObject query, JsonObject replace) { 
    findOneAndReplace(collection, query, replace).subscribe().with(io.smallrye.mutiny.vertx.UniHelper.NOOP);
    return this;
  }

  /**
   * Find a single matching document in the specified collection and replace it.
   * <p>
   * This operation might change <i>_id</i> field of <i>query</i> parameter
   * <p>
   * Unlike the <em>bare</em> Vert.x variant, this method returns a {@link io.smallrye.mutiny.Uni Uni}.
   * Don't forget to <em>subscribe</em> on it to trigger the operation.
   * @param collection the collection
   * @param query the query used to match the document
   * @param replace the replacement document
   * @param findOptions options to configure the find
   * @param updateOptions options to configure the update
   * @return the {@link io.smallrye.mutiny.Uni uni} firing the result of the operation when completed, or a failure if the operation failed.
   */
  @CheckReturnValue
  public io.smallrye.mutiny.Uni<JsonObject> findOneAndReplaceWithOptions(String collection, JsonObject query, JsonObject replace, io.vertx.ext.mongo.FindOptions findOptions, io.vertx.ext.mongo.UpdateOptions updateOptions) { 
    return io.smallrye.mutiny.vertx.AsyncResultUni.toUni(resultHandler -> {
        delegate.findOneAndReplaceWithOptions(collection, query, replace, findOptions, updateOptions, resultHandler);
    });
  }

  /**
   * Blocking variant of {@link io.vertx.mutiny.ext.mongo.MongoClient#findOneAndReplaceWithOptions(String,JsonObject,JsonObject,FindOptions,UpdateOptions)}.
   * <p>
   * This method waits for the completion of the underlying asynchronous operation.
   * If the operation completes successfully, the result is returned, otherwise the failure is thrown (potentially wrapped in a RuntimeException).
   * @param collection the collection
   * @param query the query used to match the document
   * @param replace the replacement document
   * @param findOptions options to configure the find
   * @param updateOptions options to configure the update
   * @return the JsonObject instance produced by the operation.
   */
  public JsonObject findOneAndReplaceWithOptionsAndAwait(String collection, JsonObject query, JsonObject replace, io.vertx.ext.mongo.FindOptions findOptions, io.vertx.ext.mongo.UpdateOptions updateOptions) { 
    return (JsonObject) findOneAndReplaceWithOptions(collection, query, replace, findOptions, updateOptions).await().indefinitely();
  }

  /**
   * Variant of {@link io.vertx.mutiny.ext.mongo.MongoClient#findOneAndReplaceWithOptions(String,JsonObject,JsonObject,FindOptions,UpdateOptions)} that ignores the result of the operation.
   * <p>
   * This method subscribes on the result of {@link io.vertx.mutiny.ext.mongo.MongoClient#findOneAndReplaceWithOptions(String,JsonObject,JsonObject,FindOptions,UpdateOptions)}, but discards the outcome (item or failure).
   * This method is useful to trigger the asynchronous operation from {@link io.vertx.mutiny.ext.mongo.MongoClient#findOneAndReplaceWithOptions(String,JsonObject,JsonObject,FindOptions,UpdateOptions)} but you don't need to compose it with other operations.
   * @param collection the collection
   * @param query the query used to match the document
   * @param replace the replacement document
   * @param findOptions options to configure the find
   * @param updateOptions options to configure the update
   * @return the instance of MongoClient to chain method calls.
   */
  @Fluent
  public io.vertx.mutiny.ext.mongo.MongoClient findOneAndReplaceWithOptionsAndForget(String collection, JsonObject query, JsonObject replace, io.vertx.ext.mongo.FindOptions findOptions, io.vertx.ext.mongo.UpdateOptions updateOptions) { 
    findOneAndReplaceWithOptions(collection, query, replace, findOptions, updateOptions).subscribe().with(io.smallrye.mutiny.vertx.UniHelper.NOOP);
    return this;
  }

  /**
   * Find a single matching document in the specified collection and delete it.
   * <p>
   * This operation might change <i>_id</i> field of <i>query</i> parameter
   * <p>
   * Unlike the <em>bare</em> Vert.x variant, this method returns a {@link io.smallrye.mutiny.Uni Uni}.
   * Don't forget to <em>subscribe</em> on it to trigger the operation.
   * @param collection the collection
   * @param query the query used to match the document
   * @return the {@link io.smallrye.mutiny.Uni uni} firing the result of the operation when completed, or a failure if the operation failed.
   */
  @CheckReturnValue
  public io.smallrye.mutiny.Uni<JsonObject> findOneAndDelete(String collection, JsonObject query) { 
    return io.smallrye.mutiny.vertx.AsyncResultUni.toUni(resultHandler -> {
        delegate.findOneAndDelete(collection, query, resultHandler);
    });
  }

  /**
   * Blocking variant of {@link io.vertx.mutiny.ext.mongo.MongoClient#findOneAndDelete(String,JsonObject)}.
   * <p>
   * This method waits for the completion of the underlying asynchronous operation.
   * If the operation completes successfully, the result is returned, otherwise the failure is thrown (potentially wrapped in a RuntimeException).
   * @param collection the collection
   * @param query the query used to match the document
   * @return the JsonObject instance produced by the operation.
   */
  public JsonObject findOneAndDeleteAndAwait(String collection, JsonObject query) { 
    return (JsonObject) findOneAndDelete(collection, query).await().indefinitely();
  }

  /**
   * Variant of {@link io.vertx.mutiny.ext.mongo.MongoClient#findOneAndDelete(String,JsonObject)} that ignores the result of the operation.
   * <p>
   * This method subscribes on the result of {@link io.vertx.mutiny.ext.mongo.MongoClient#findOneAndDelete(String,JsonObject)}, but discards the outcome (item or failure).
   * This method is useful to trigger the asynchronous operation from {@link io.vertx.mutiny.ext.mongo.MongoClient#findOneAndDelete(String,JsonObject)} but you don't need to compose it with other operations.
   * @param collection the collection
   * @param query the query used to match the document
   * @return the instance of MongoClient to chain method calls.
   */
  @Fluent
  public io.vertx.mutiny.ext.mongo.MongoClient findOneAndDeleteAndForget(String collection, JsonObject query) { 
    findOneAndDelete(collection, query).subscribe().with(io.smallrye.mutiny.vertx.UniHelper.NOOP);
    return this;
  }

  /**
   * Find a single matching document in the specified collection and delete it.
   * <p>
   * This operation might change <i>_id</i> field of <i>query</i> parameter
   * <p>
   * Unlike the <em>bare</em> Vert.x variant, this method returns a {@link io.smallrye.mutiny.Uni Uni}.
   * Don't forget to <em>subscribe</em> on it to trigger the operation.
   * @param collection the collection
   * @param query the query used to match the document
   * @param findOptions options to configure the find
   * @return the {@link io.smallrye.mutiny.Uni uni} firing the result of the operation when completed, or a failure if the operation failed.
   */
  @CheckReturnValue
  public io.smallrye.mutiny.Uni<JsonObject> findOneAndDeleteWithOptions(String collection, JsonObject query, io.vertx.ext.mongo.FindOptions findOptions) { 
    return io.smallrye.mutiny.vertx.AsyncResultUni.toUni(resultHandler -> {
        delegate.findOneAndDeleteWithOptions(collection, query, findOptions, resultHandler);
    });
  }

  /**
   * Blocking variant of {@link io.vertx.mutiny.ext.mongo.MongoClient#findOneAndDeleteWithOptions(String,JsonObject,FindOptions)}.
   * <p>
   * This method waits for the completion of the underlying asynchronous operation.
   * If the operation completes successfully, the result is returned, otherwise the failure is thrown (potentially wrapped in a RuntimeException).
   * @param collection the collection
   * @param query the query used to match the document
   * @param findOptions options to configure the find
   * @return the JsonObject instance produced by the operation.
   */
  public JsonObject findOneAndDeleteWithOptionsAndAwait(String collection, JsonObject query, io.vertx.ext.mongo.FindOptions findOptions) { 
    return (JsonObject) findOneAndDeleteWithOptions(collection, query, findOptions).await().indefinitely();
  }

  /**
   * Variant of {@link io.vertx.mutiny.ext.mongo.MongoClient#findOneAndDeleteWithOptions(String,JsonObject,FindOptions)} that ignores the result of the operation.
   * <p>
   * This method subscribes on the result of {@link io.vertx.mutiny.ext.mongo.MongoClient#findOneAndDeleteWithOptions(String,JsonObject,FindOptions)}, but discards the outcome (item or failure).
   * This method is useful to trigger the asynchronous operation from {@link io.vertx.mutiny.ext.mongo.MongoClient#findOneAndDeleteWithOptions(String,JsonObject,FindOptions)} but you don't need to compose it with other operations.
   * @param collection the collection
   * @param query the query used to match the document
   * @param findOptions options to configure the find
   * @return the instance of MongoClient to chain method calls.
   */
  @Fluent
  public io.vertx.mutiny.ext.mongo.MongoClient findOneAndDeleteWithOptionsAndForget(String collection, JsonObject query, io.vertx.ext.mongo.FindOptions findOptions) { 
    findOneAndDeleteWithOptions(collection, query, findOptions).subscribe().with(io.smallrye.mutiny.vertx.UniHelper.NOOP);
    return this;
  }

  /**
   * Count matching documents in a collection.
   * <p>
   * Unlike the <em>bare</em> Vert.x variant, this method returns a {@link io.smallrye.mutiny.Uni Uni}.
   * Don't forget to <em>subscribe</em> on it to trigger the operation.
   * @param collection the collection
   * @param query query used to match documents
   * @return the {@link io.smallrye.mutiny.Uni uni} firing the result of the operation when completed, or a failure if the operation failed.
   */
  @CheckReturnValue
  public io.smallrye.mutiny.Uni<Long> count(String collection, JsonObject query) { 
    return io.smallrye.mutiny.vertx.AsyncResultUni.toUni(resultHandler -> {
        delegate.count(collection, query, resultHandler);
    });
  }

  /**
   * Blocking variant of {@link io.vertx.mutiny.ext.mongo.MongoClient#count(String,JsonObject)}.
   * <p>
   * This method waits for the completion of the underlying asynchronous operation.
   * If the operation completes successfully, the result is returned, otherwise the failure is thrown (potentially wrapped in a RuntimeException).
   * @param collection the collection
   * @param query query used to match documents
   * @return the Long instance produced by the operation.
   */
  public Long countAndAwait(String collection, JsonObject query) { 
    return (Long) count(collection, query).await().indefinitely();
  }

  /**
   * Variant of {@link io.vertx.mutiny.ext.mongo.MongoClient#count(String,JsonObject)} that ignores the result of the operation.
   * <p>
   * This method subscribes on the result of {@link io.vertx.mutiny.ext.mongo.MongoClient#count(String,JsonObject)}, but discards the outcome (item or failure).
   * This method is useful to trigger the asynchronous operation from {@link io.vertx.mutiny.ext.mongo.MongoClient#count(String,JsonObject)} but you don't need to compose it with other operations.
   * @param collection the collection
   * @param query query used to match documents
   * @return the instance of MongoClient to chain method calls.
   */
  @Fluent
  public io.vertx.mutiny.ext.mongo.MongoClient countAndForget(String collection, JsonObject query) { 
    count(collection, query).subscribe().with(io.smallrye.mutiny.vertx.UniHelper.NOOP);
    return this;
  }

  /**
   * Count matching documents in a collection.
   * <p>
   * Unlike the <em>bare</em> Vert.x variant, this method returns a {@link io.smallrye.mutiny.Uni Uni}.
   * Don't forget to <em>subscribe</em> on it to trigger the operation.
   * @param collection the collection
   * @param query query used to match documents
   * @param countOptions 
   * @return the {@link io.smallrye.mutiny.Uni uni} firing the result of the operation when completed, or a failure if the operation failed.
   */
  @CheckReturnValue
  public io.smallrye.mutiny.Uni<Long> countWithOptions(String collection, JsonObject query, io.vertx.ext.mongo.CountOptions countOptions) { 
    return io.smallrye.mutiny.vertx.AsyncResultUni.toUni(resultHandler -> {
        delegate.countWithOptions(collection, query, countOptions, resultHandler);
    });
  }

  /**
   * Blocking variant of {@link io.vertx.mutiny.ext.mongo.MongoClient#countWithOptions(String,JsonObject,CountOptions)}.
   * <p>
   * This method waits for the completion of the underlying asynchronous operation.
   * If the operation completes successfully, the result is returned, otherwise the failure is thrown (potentially wrapped in a RuntimeException).
   * @param collection the collection
   * @param query query used to match documents
   * @param countOptions 
   * @return the Long instance produced by the operation.
   */
  public Long countWithOptionsAndAwait(String collection, JsonObject query, io.vertx.ext.mongo.CountOptions countOptions) { 
    return (Long) countWithOptions(collection, query, countOptions).await().indefinitely();
  }

  /**
   * Variant of {@link io.vertx.mutiny.ext.mongo.MongoClient#countWithOptions(String,JsonObject,CountOptions)} that ignores the result of the operation.
   * <p>
   * This method subscribes on the result of {@link io.vertx.mutiny.ext.mongo.MongoClient#countWithOptions(String,JsonObject,CountOptions)}, but discards the outcome (item or failure).
   * This method is useful to trigger the asynchronous operation from {@link io.vertx.mutiny.ext.mongo.MongoClient#countWithOptions(String,JsonObject,CountOptions)} but you don't need to compose it with other operations.
   * @param collection the collection
   * @param query query used to match documents
   * @param countOptions 
   * @return the instance of MongoClient to chain method calls.
   */
  @Fluent
  public io.vertx.mutiny.ext.mongo.MongoClient countWithOptionsAndForget(String collection, JsonObject query, io.vertx.ext.mongo.CountOptions countOptions) { 
    countWithOptions(collection, query, countOptions).subscribe().with(io.smallrye.mutiny.vertx.UniHelper.NOOP);
    return this;
  }

  /**
   * Remove matching documents from a collection and return the handler with <code>MongoClientDeleteResult</code> result
   * <p>
   * Unlike the <em>bare</em> Vert.x variant, this method returns a {@link io.smallrye.mutiny.Uni Uni}.
   * Don't forget to <em>subscribe</em> on it to trigger the operation.
   * @param collection the collection
   * @param query query used to match documents
   * @return the {@link io.smallrye.mutiny.Uni uni} firing the result of the operation when completed, or a failure if the operation failed.
   */
  @CheckReturnValue
  public io.smallrye.mutiny.Uni<io.vertx.ext.mongo.MongoClientDeleteResult> removeDocuments(String collection, JsonObject query) { 
    return io.smallrye.mutiny.vertx.AsyncResultUni.toUni(resultHandler -> {
        delegate.removeDocuments(collection, query, resultHandler);
    });
  }

  /**
   * Blocking variant of {@link io.vertx.mutiny.ext.mongo.MongoClient#removeDocuments(String,JsonObject)}.
   * <p>
   * This method waits for the completion of the underlying asynchronous operation.
   * If the operation completes successfully, the result is returned, otherwise the failure is thrown (potentially wrapped in a RuntimeException).
   * @param collection the collection
   * @param query query used to match documents
   * @return the MongoClientDeleteResult instance produced by the operation.
   */
  public io.vertx.ext.mongo.MongoClientDeleteResult removeDocumentsAndAwait(String collection, JsonObject query) { 
    return (io.vertx.ext.mongo.MongoClientDeleteResult) removeDocuments(collection, query).await().indefinitely();
  }

  /**
   * Variant of {@link io.vertx.mutiny.ext.mongo.MongoClient#removeDocuments(String,JsonObject)} that ignores the result of the operation.
   * <p>
   * This method subscribes on the result of {@link io.vertx.mutiny.ext.mongo.MongoClient#removeDocuments(String,JsonObject)}, but discards the outcome (item or failure).
   * This method is useful to trigger the asynchronous operation from {@link io.vertx.mutiny.ext.mongo.MongoClient#removeDocuments(String,JsonObject)} but you don't need to compose it with other operations.
   * @param collection the collection
   * @param query query used to match documents
   * @return the instance of MongoClient to chain method calls.
   */
  @Fluent
  public io.vertx.mutiny.ext.mongo.MongoClient removeDocumentsAndForget(String collection, JsonObject query) { 
    removeDocuments(collection, query).subscribe().with(io.smallrye.mutiny.vertx.UniHelper.NOOP);
    return this;
  }

  /**
   * Remove matching documents from a collection with the specified write option and return the handler with <code>MongoClientDeleteResult</code> result
   * <p>
   * Unlike the <em>bare</em> Vert.x variant, this method returns a {@link io.smallrye.mutiny.Uni Uni}.
   * Don't forget to <em>subscribe</em> on it to trigger the operation.
   * @param collection the collection
   * @param query query used to match documents
   * @param writeOption the write option to use
   * @return the {@link io.smallrye.mutiny.Uni uni} firing the result of the operation when completed, or a failure if the operation failed.
   */
  @CheckReturnValue
  public io.smallrye.mutiny.Uni<io.vertx.ext.mongo.MongoClientDeleteResult> removeDocumentsWithOptions(String collection, JsonObject query, io.vertx.ext.mongo.WriteOption writeOption) { 
    return io.smallrye.mutiny.vertx.AsyncResultUni.toUni(resultHandler -> {
        delegate.removeDocumentsWithOptions(collection, query, writeOption, resultHandler);
    });
  }

  /**
   * Blocking variant of {@link io.vertx.mutiny.ext.mongo.MongoClient#removeDocumentsWithOptions(String,JsonObject,WriteOption)}.
   * <p>
   * This method waits for the completion of the underlying asynchronous operation.
   * If the operation completes successfully, the result is returned, otherwise the failure is thrown (potentially wrapped in a RuntimeException).
   * @param collection the collection
   * @param query query used to match documents
   * @param writeOption the write option to use
   * @return the MongoClientDeleteResult instance produced by the operation.
   */
  public io.vertx.ext.mongo.MongoClientDeleteResult removeDocumentsWithOptionsAndAwait(String collection, JsonObject query, io.vertx.ext.mongo.WriteOption writeOption) { 
    return (io.vertx.ext.mongo.MongoClientDeleteResult) removeDocumentsWithOptions(collection, query, writeOption).await().indefinitely();
  }

  /**
   * Variant of {@link io.vertx.mutiny.ext.mongo.MongoClient#removeDocumentsWithOptions(String,JsonObject,WriteOption)} that ignores the result of the operation.
   * <p>
   * This method subscribes on the result of {@link io.vertx.mutiny.ext.mongo.MongoClient#removeDocumentsWithOptions(String,JsonObject,WriteOption)}, but discards the outcome (item or failure).
   * This method is useful to trigger the asynchronous operation from {@link io.vertx.mutiny.ext.mongo.MongoClient#removeDocumentsWithOptions(String,JsonObject,WriteOption)} but you don't need to compose it with other operations.
   * @param collection the collection
   * @param query query used to match documents
   * @param writeOption the write option to use
   * @return the instance of MongoClient to chain method calls.
   */
  @Fluent
  public io.vertx.mutiny.ext.mongo.MongoClient removeDocumentsWithOptionsAndForget(String collection, JsonObject query, io.vertx.ext.mongo.WriteOption writeOption) { 
    removeDocumentsWithOptions(collection, query, writeOption).subscribe().with(io.smallrye.mutiny.vertx.UniHelper.NOOP);
    return this;
  }

  /**
   * Remove a single matching document from a collection and return the handler with <code>MongoClientDeleteResult</code> result
   * <p>
   * Unlike the <em>bare</em> Vert.x variant, this method returns a {@link io.smallrye.mutiny.Uni Uni}.
   * Don't forget to <em>subscribe</em> on it to trigger the operation.
   * @param collection the collection
   * @param query query used to match document
   * @return the {@link io.smallrye.mutiny.Uni uni} firing the result of the operation when completed, or a failure if the operation failed.
   */
  @CheckReturnValue
  public io.smallrye.mutiny.Uni<io.vertx.ext.mongo.MongoClientDeleteResult> removeDocument(String collection, JsonObject query) { 
    return io.smallrye.mutiny.vertx.AsyncResultUni.toUni(resultHandler -> {
        delegate.removeDocument(collection, query, resultHandler);
    });
  }

  /**
   * Blocking variant of {@link io.vertx.mutiny.ext.mongo.MongoClient#removeDocument(String,JsonObject)}.
   * <p>
   * This method waits for the completion of the underlying asynchronous operation.
   * If the operation completes successfully, the result is returned, otherwise the failure is thrown (potentially wrapped in a RuntimeException).
   * @param collection the collection
   * @param query query used to match document
   * @return the MongoClientDeleteResult instance produced by the operation.
   */
  public io.vertx.ext.mongo.MongoClientDeleteResult removeDocumentAndAwait(String collection, JsonObject query) { 
    return (io.vertx.ext.mongo.MongoClientDeleteResult) removeDocument(collection, query).await().indefinitely();
  }

  /**
   * Variant of {@link io.vertx.mutiny.ext.mongo.MongoClient#removeDocument(String,JsonObject)} that ignores the result of the operation.
   * <p>
   * This method subscribes on the result of {@link io.vertx.mutiny.ext.mongo.MongoClient#removeDocument(String,JsonObject)}, but discards the outcome (item or failure).
   * This method is useful to trigger the asynchronous operation from {@link io.vertx.mutiny.ext.mongo.MongoClient#removeDocument(String,JsonObject)} but you don't need to compose it with other operations.
   * @param collection the collection
   * @param query query used to match document
   * @return the instance of MongoClient to chain method calls.
   */
  @Fluent
  public io.vertx.mutiny.ext.mongo.MongoClient removeDocumentAndForget(String collection, JsonObject query) { 
    removeDocument(collection, query).subscribe().with(io.smallrye.mutiny.vertx.UniHelper.NOOP);
    return this;
  }

  /**
   * Remove a single matching document from a collection with the specified write option and return the handler with <code>MongoClientDeleteResult</code> result
   * <p>
   * Unlike the <em>bare</em> Vert.x variant, this method returns a {@link io.smallrye.mutiny.Uni Uni}.
   * Don't forget to <em>subscribe</em> on it to trigger the operation.
   * @param collection the collection
   * @param query query used to match document
   * @param writeOption the write option to use
   * @return the {@link io.smallrye.mutiny.Uni uni} firing the result of the operation when completed, or a failure if the operation failed.
   */
  @CheckReturnValue
  public io.smallrye.mutiny.Uni<io.vertx.ext.mongo.MongoClientDeleteResult> removeDocumentWithOptions(String collection, JsonObject query, io.vertx.ext.mongo.WriteOption writeOption) { 
    return io.smallrye.mutiny.vertx.AsyncResultUni.toUni(resultHandler -> {
        delegate.removeDocumentWithOptions(collection, query, writeOption, resultHandler);
    });
  }

  /**
   * Blocking variant of {@link io.vertx.mutiny.ext.mongo.MongoClient#removeDocumentWithOptions(String,JsonObject,WriteOption)}.
   * <p>
   * This method waits for the completion of the underlying asynchronous operation.
   * If the operation completes successfully, the result is returned, otherwise the failure is thrown (potentially wrapped in a RuntimeException).
   * @param collection the collection
   * @param query query used to match document
   * @param writeOption the write option to use
   * @return the MongoClientDeleteResult instance produced by the operation.
   */
  public io.vertx.ext.mongo.MongoClientDeleteResult removeDocumentWithOptionsAndAwait(String collection, JsonObject query, io.vertx.ext.mongo.WriteOption writeOption) { 
    return (io.vertx.ext.mongo.MongoClientDeleteResult) removeDocumentWithOptions(collection, query, writeOption).await().indefinitely();
  }

  /**
   * Variant of {@link io.vertx.mutiny.ext.mongo.MongoClient#removeDocumentWithOptions(String,JsonObject,WriteOption)} that ignores the result of the operation.
   * <p>
   * This method subscribes on the result of {@link io.vertx.mutiny.ext.mongo.MongoClient#removeDocumentWithOptions(String,JsonObject,WriteOption)}, but discards the outcome (item or failure).
   * This method is useful to trigger the asynchronous operation from {@link io.vertx.mutiny.ext.mongo.MongoClient#removeDocumentWithOptions(String,JsonObject,WriteOption)} but you don't need to compose it with other operations.
   * @param collection the collection
   * @param query query used to match document
   * @param writeOption the write option to use
   * @return the instance of MongoClient to chain method calls.
   */
  @Fluent
  public io.vertx.mutiny.ext.mongo.MongoClient removeDocumentWithOptionsAndForget(String collection, JsonObject query, io.vertx.ext.mongo.WriteOption writeOption) { 
    removeDocumentWithOptions(collection, query, writeOption).subscribe().with(io.smallrye.mutiny.vertx.UniHelper.NOOP);
    return this;
  }

  /**
   * Create a new collection
   * <p>
   * Unlike the <em>bare</em> Vert.x variant, this method returns a {@link io.smallrye.mutiny.Uni Uni}.
   * Don't forget to <em>subscribe</em> on it to trigger the operation.
   * @param collectionName the name of the collection
   * @return the {@link io.smallrye.mutiny.Uni uni} firing the result of the operation when completed, or a failure if the operation failed.
   */
  @CheckReturnValue
  public io.smallrye.mutiny.Uni<Void> createCollection(String collectionName) { 
    return io.smallrye.mutiny.vertx.AsyncResultUni.toUni(resultHandler -> {
        delegate.createCollection(collectionName, resultHandler);
    });
  }

  /**
   * Blocking variant of {@link io.vertx.mutiny.ext.mongo.MongoClient#createCollection(String)}.
   * <p>
   * This method waits for the completion of the underlying asynchronous operation.
   * If the operation completes successfully, the result is returned, otherwise the failure is thrown (potentially wrapped in a RuntimeException).
   * @param collectionName the name of the collection
   * @return the Void instance produced by the operation.
   */
  public Void createCollectionAndAwait(String collectionName) { 
    return (Void) createCollection(collectionName).await().indefinitely();
  }

  /**
   * Variant of {@link io.vertx.mutiny.ext.mongo.MongoClient#createCollection(String)} that ignores the result of the operation.
   * <p>
   * This method subscribes on the result of {@link io.vertx.mutiny.ext.mongo.MongoClient#createCollection(String)}, but discards the outcome (item or failure).
   * This method is useful to trigger the asynchronous operation from {@link io.vertx.mutiny.ext.mongo.MongoClient#createCollection(String)} but you don't need to compose it with other operations.
   * @param collectionName the name of the collection
   * @return the instance of MongoClient to chain method calls.
   */
  @Fluent
  public io.vertx.mutiny.ext.mongo.MongoClient createCollectionAndForget(String collectionName) { 
    createCollection(collectionName).subscribe().with(io.smallrye.mutiny.vertx.UniHelper.NOOP);
    return this;
  }

  /**
   * Create a new collection with options
   * <p>
   * Unlike the <em>bare</em> Vert.x variant, this method returns a {@link io.smallrye.mutiny.Uni Uni}.
   * Don't forget to <em>subscribe</em> on it to trigger the operation.
   * @param collectionName the name of the collection
   * @param collectionOptions options of the collection
   * @return the {@link io.smallrye.mutiny.Uni uni} firing the result of the operation when completed, or a failure if the operation failed.
   */
  @CheckReturnValue
  public io.smallrye.mutiny.Uni<Void> createCollectionWithOptions(String collectionName, io.vertx.ext.mongo.CreateCollectionOptions collectionOptions) { 
    return io.smallrye.mutiny.vertx.AsyncResultUni.toUni(resultHandler -> {
        delegate.createCollectionWithOptions(collectionName, collectionOptions, resultHandler);
    });
  }

  /**
   * Blocking variant of {@link io.vertx.mutiny.ext.mongo.MongoClient#createCollectionWithOptions(String,CreateCollectionOptions)}.
   * <p>
   * This method waits for the completion of the underlying asynchronous operation.
   * If the operation completes successfully, the result is returned, otherwise the failure is thrown (potentially wrapped in a RuntimeException).
   * @param collectionName the name of the collection
   * @param collectionOptions options of the collection
   * @return the Void instance produced by the operation.
   */
  public Void createCollectionWithOptionsAndAwait(String collectionName, io.vertx.ext.mongo.CreateCollectionOptions collectionOptions) { 
    return (Void) createCollectionWithOptions(collectionName, collectionOptions).await().indefinitely();
  }

  /**
   * Variant of {@link io.vertx.mutiny.ext.mongo.MongoClient#createCollectionWithOptions(String,CreateCollectionOptions)} that ignores the result of the operation.
   * <p>
   * This method subscribes on the result of {@link io.vertx.mutiny.ext.mongo.MongoClient#createCollectionWithOptions(String,CreateCollectionOptions)}, but discards the outcome (item or failure).
   * This method is useful to trigger the asynchronous operation from {@link io.vertx.mutiny.ext.mongo.MongoClient#createCollectionWithOptions(String,CreateCollectionOptions)} but you don't need to compose it with other operations.
   * @param collectionName the name of the collection
   * @param collectionOptions options of the collection
   * @return the instance of MongoClient to chain method calls.
   */
  @Fluent
  public io.vertx.mutiny.ext.mongo.MongoClient createCollectionWithOptionsAndForget(String collectionName, io.vertx.ext.mongo.CreateCollectionOptions collectionOptions) { 
    createCollectionWithOptions(collectionName, collectionOptions).subscribe().with(io.smallrye.mutiny.vertx.UniHelper.NOOP);
    return this;
  }

  /**
   * Get a list of all collections in the database.
   * <p>
   * Unlike the <em>bare</em> Vert.x variant, this method returns a {@link io.smallrye.mutiny.Uni Uni}.
   * Don't forget to <em>subscribe</em> on it to trigger the operation.
   * @return the {@link io.smallrye.mutiny.Uni uni} firing the result of the operation when completed, or a failure if the operation failed.
   */
  @CheckReturnValue
  public io.smallrye.mutiny.Uni<List<String>> getCollections() { 
    return io.smallrye.mutiny.vertx.AsyncResultUni.toUni(resultHandler -> {
        delegate.getCollections(resultHandler);
    });
  }

  /**
   * Blocking variant of {@link io.vertx.mutiny.ext.mongo.MongoClient#getCollections}.
   * <p>
   * This method waits for the completion of the underlying asynchronous operation.
   * If the operation completes successfully, the result is returned, otherwise the failure is thrown (potentially wrapped in a RuntimeException).
   * @return the List<String> instance produced by the operation.
   */
  public List<String> getCollectionsAndAwait() { 
    return (List<String>) getCollections().await().indefinitely();
  }

  /**
   * Variant of {@link io.vertx.mutiny.ext.mongo.MongoClient#getCollections} that ignores the result of the operation.
   * <p>
   * This method subscribes on the result of {@link io.vertx.mutiny.ext.mongo.MongoClient#getCollections}, but discards the outcome (item or failure).
   * This method is useful to trigger the asynchronous operation from {@link io.vertx.mutiny.ext.mongo.MongoClient#getCollections} but you don't need to compose it with other operations.
   * @return the instance of MongoClient to chain method calls.
   */
  @Fluent
  public io.vertx.mutiny.ext.mongo.MongoClient getCollectionsAndForget() { 
    getCollections().subscribe().with(io.smallrye.mutiny.vertx.UniHelper.NOOP);
    return this;
  }

  /**
   * Drop a collection
   * <p>
   * Unlike the <em>bare</em> Vert.x variant, this method returns a {@link io.smallrye.mutiny.Uni Uni}.
   * Don't forget to <em>subscribe</em> on it to trigger the operation.
   * @param collection the collection
   * @return the {@link io.smallrye.mutiny.Uni uni} firing the result of the operation when completed, or a failure if the operation failed.
   */
  @CheckReturnValue
  public io.smallrye.mutiny.Uni<Void> dropCollection(String collection) { 
    return io.smallrye.mutiny.vertx.AsyncResultUni.toUni(resultHandler -> {
        delegate.dropCollection(collection, resultHandler);
    });
  }

  /**
   * Blocking variant of {@link io.vertx.mutiny.ext.mongo.MongoClient#dropCollection(String)}.
   * <p>
   * This method waits for the completion of the underlying asynchronous operation.
   * If the operation completes successfully, the result is returned, otherwise the failure is thrown (potentially wrapped in a RuntimeException).
   * @param collection the collection
   * @return the Void instance produced by the operation.
   */
  public Void dropCollectionAndAwait(String collection) { 
    return (Void) dropCollection(collection).await().indefinitely();
  }

  /**
   * Variant of {@link io.vertx.mutiny.ext.mongo.MongoClient#dropCollection(String)} that ignores the result of the operation.
   * <p>
   * This method subscribes on the result of {@link io.vertx.mutiny.ext.mongo.MongoClient#dropCollection(String)}, but discards the outcome (item or failure).
   * This method is useful to trigger the asynchronous operation from {@link io.vertx.mutiny.ext.mongo.MongoClient#dropCollection(String)} but you don't need to compose it with other operations.
   * @param collection the collection
   * @return the instance of MongoClient to chain method calls.
   */
  @Fluent
  public io.vertx.mutiny.ext.mongo.MongoClient dropCollectionAndForget(String collection) { 
    dropCollection(collection).subscribe().with(io.smallrye.mutiny.vertx.UniHelper.NOOP);
    return this;
  }

  /**
   * Creates an index.
   * <p>
   * Unlike the <em>bare</em> Vert.x variant, this method returns a {@link io.smallrye.mutiny.Uni Uni}.
   * Don't forget to <em>subscribe</em> on it to trigger the operation.
   * @param collection the collection
   * @param key A document that contains the field and value pairs where the field is the index key and the value describes the type of index for that field. For an ascending index on a field, specify a value of 1; for descending index, specify a value of -1.
   * @return the {@link io.smallrye.mutiny.Uni uni} firing the result of the operation when completed, or a failure if the operation failed.
   */
  @CheckReturnValue
  public io.smallrye.mutiny.Uni<Void> createIndex(String collection, JsonObject key) { 
    return io.smallrye.mutiny.vertx.AsyncResultUni.toUni(resultHandler -> {
        delegate.createIndex(collection, key, resultHandler);
    });
  }

  /**
   * Blocking variant of {@link io.vertx.mutiny.ext.mongo.MongoClient#createIndex(String,JsonObject)}.
   * <p>
   * This method waits for the completion of the underlying asynchronous operation.
   * If the operation completes successfully, the result is returned, otherwise the failure is thrown (potentially wrapped in a RuntimeException).
   * @param collection the collection
   * @param key A document that contains the field and value pairs where the field is the index key and the value describes the type of index for that field. For an ascending index on a field, specify a value of 1; for descending index, specify a value of -1.
   * @return the Void instance produced by the operation.
   */
  public Void createIndexAndAwait(String collection, JsonObject key) { 
    return (Void) createIndex(collection, key).await().indefinitely();
  }

  /**
   * Variant of {@link io.vertx.mutiny.ext.mongo.MongoClient#createIndex(String,JsonObject)} that ignores the result of the operation.
   * <p>
   * This method subscribes on the result of {@link io.vertx.mutiny.ext.mongo.MongoClient#createIndex(String,JsonObject)}, but discards the outcome (item or failure).
   * This method is useful to trigger the asynchronous operation from {@link io.vertx.mutiny.ext.mongo.MongoClient#createIndex(String,JsonObject)} but you don't need to compose it with other operations.
   * @param collection the collection
   * @param key A document that contains the field and value pairs where the field is the index key and the value describes the type of index for that field. For an ascending index on a field, specify a value of 1; for descending index, specify a value of -1.
   * @return the instance of MongoClient to chain method calls.
   */
  @Fluent
  public io.vertx.mutiny.ext.mongo.MongoClient createIndexAndForget(String collection, JsonObject key) { 
    createIndex(collection, key).subscribe().with(io.smallrye.mutiny.vertx.UniHelper.NOOP);
    return this;
  }

  /**
   * Creates an index.
   * <p>
   * Unlike the <em>bare</em> Vert.x variant, this method returns a {@link io.smallrye.mutiny.Uni Uni}.
   * Don't forget to <em>subscribe</em> on it to trigger the operation.
   * @param collection the collection
   * @param key A document that contains the field and value pairs where the field is the index key and the value describes the type of index for that field. For an ascending index on a field, specify a value of 1; for descending index, specify a value of -1.
   * @param options the options for the index
   * @return the {@link io.smallrye.mutiny.Uni uni} firing the result of the operation when completed, or a failure if the operation failed.
   */
  @CheckReturnValue
  public io.smallrye.mutiny.Uni<Void> createIndexWithOptions(String collection, JsonObject key, io.vertx.ext.mongo.IndexOptions options) { 
    return io.smallrye.mutiny.vertx.AsyncResultUni.toUni(resultHandler -> {
        delegate.createIndexWithOptions(collection, key, options, resultHandler);
    });
  }

  /**
   * Blocking variant of {@link io.vertx.mutiny.ext.mongo.MongoClient#createIndexWithOptions(String,JsonObject,IndexOptions)}.
   * <p>
   * This method waits for the completion of the underlying asynchronous operation.
   * If the operation completes successfully, the result is returned, otherwise the failure is thrown (potentially wrapped in a RuntimeException).
   * @param collection the collection
   * @param key A document that contains the field and value pairs where the field is the index key and the value describes the type of index for that field. For an ascending index on a field, specify a value of 1; for descending index, specify a value of -1.
   * @param options the options for the index
   * @return the Void instance produced by the operation.
   */
  public Void createIndexWithOptionsAndAwait(String collection, JsonObject key, io.vertx.ext.mongo.IndexOptions options) { 
    return (Void) createIndexWithOptions(collection, key, options).await().indefinitely();
  }

  /**
   * Variant of {@link io.vertx.mutiny.ext.mongo.MongoClient#createIndexWithOptions(String,JsonObject,IndexOptions)} that ignores the result of the operation.
   * <p>
   * This method subscribes on the result of {@link io.vertx.mutiny.ext.mongo.MongoClient#createIndexWithOptions(String,JsonObject,IndexOptions)}, but discards the outcome (item or failure).
   * This method is useful to trigger the asynchronous operation from {@link io.vertx.mutiny.ext.mongo.MongoClient#createIndexWithOptions(String,JsonObject,IndexOptions)} but you don't need to compose it with other operations.
   * @param collection the collection
   * @param key A document that contains the field and value pairs where the field is the index key and the value describes the type of index for that field. For an ascending index on a field, specify a value of 1; for descending index, specify a value of -1.
   * @param options the options for the index
   * @return the instance of MongoClient to chain method calls.
   */
  @Fluent
  public io.vertx.mutiny.ext.mongo.MongoClient createIndexWithOptionsAndForget(String collection, JsonObject key, io.vertx.ext.mongo.IndexOptions options) { 
    createIndexWithOptions(collection, key, options).subscribe().with(io.smallrye.mutiny.vertx.UniHelper.NOOP);
    return this;
  }

  /**
   * creates an indexes
   * <p>
   * Unlike the <em>bare</em> Vert.x variant, this method returns a {@link io.smallrye.mutiny.Uni Uni}.
   * Don't forget to <em>subscribe</em> on it to trigger the operation.
   * @param collection the collection
   * @param indexes A model that contains pairs of document and indexOptions, document contains the field and value pairs where the field is the index key and the value describes the type of index for that field. For an ascending index on a field, specify a value of 1; for descending index, specify a value of -1.
   * @return the {@link io.smallrye.mutiny.Uni uni} firing the result of the operation when completed, or a failure if the operation failed.
   */
  @CheckReturnValue
  public io.smallrye.mutiny.Uni<Void> createIndexes(String collection, List<io.vertx.ext.mongo.IndexModel> indexes) { 
    return io.smallrye.mutiny.vertx.AsyncResultUni.toUni(resultHandler -> {
        delegate.createIndexes(collection, indexes, resultHandler);
    });
  }

  /**
   * Blocking variant of {@link io.vertx.mutiny.ext.mongo.MongoClient#createIndexes(String,List)}.
   * <p>
   * This method waits for the completion of the underlying asynchronous operation.
   * If the operation completes successfully, the result is returned, otherwise the failure is thrown (potentially wrapped in a RuntimeException).
   * @param collection the collection
   * @param indexes A model that contains pairs of document and indexOptions, document contains the field and value pairs where the field is the index key and the value describes the type of index for that field. For an ascending index on a field, specify a value of 1; for descending index, specify a value of -1.
   * @return the Void instance produced by the operation.
   */
  public Void createIndexesAndAwait(String collection, List<io.vertx.ext.mongo.IndexModel> indexes) { 
    return (Void) createIndexes(collection, indexes).await().indefinitely();
  }

  /**
   * Variant of {@link io.vertx.mutiny.ext.mongo.MongoClient#createIndexes(String,List)} that ignores the result of the operation.
   * <p>
   * This method subscribes on the result of {@link io.vertx.mutiny.ext.mongo.MongoClient#createIndexes(String,List)}, but discards the outcome (item or failure).
   * This method is useful to trigger the asynchronous operation from {@link io.vertx.mutiny.ext.mongo.MongoClient#createIndexes(String,List)} but you don't need to compose it with other operations.
   * @param collection the collection
   * @param indexes A model that contains pairs of document and indexOptions, document contains the field and value pairs where the field is the index key and the value describes the type of index for that field. For an ascending index on a field, specify a value of 1; for descending index, specify a value of -1.
   * @return the instance of MongoClient to chain method calls.
   */
  @Fluent
  public io.vertx.mutiny.ext.mongo.MongoClient createIndexesAndForget(String collection, List<io.vertx.ext.mongo.IndexModel> indexes) { 
    createIndexes(collection, indexes).subscribe().with(io.smallrye.mutiny.vertx.UniHelper.NOOP);
    return this;
  }

  /**
   * Get all the indexes in this collection.
   * <p>
   * Unlike the <em>bare</em> Vert.x variant, this method returns a {@link io.smallrye.mutiny.Uni Uni}.
   * Don't forget to <em>subscribe</em> on it to trigger the operation.
   * @param collection the collection
   * @return the {@link io.smallrye.mutiny.Uni uni} firing the result of the operation when completed, or a failure if the operation failed.
   */
  @CheckReturnValue
  public io.smallrye.mutiny.Uni<JsonArray> listIndexes(String collection) { 
    return io.smallrye.mutiny.vertx.AsyncResultUni.toUni(resultHandler -> {
        delegate.listIndexes(collection, resultHandler);
    });
  }

  /**
   * Blocking variant of {@link io.vertx.mutiny.ext.mongo.MongoClient#listIndexes(String)}.
   * <p>
   * This method waits for the completion of the underlying asynchronous operation.
   * If the operation completes successfully, the result is returned, otherwise the failure is thrown (potentially wrapped in a RuntimeException).
   * @param collection the collection
   * @return the JsonArray instance produced by the operation.
   */
  public JsonArray listIndexesAndAwait(String collection) { 
    return (JsonArray) listIndexes(collection).await().indefinitely();
  }

  /**
   * Variant of {@link io.vertx.mutiny.ext.mongo.MongoClient#listIndexes(String)} that ignores the result of the operation.
   * <p>
   * This method subscribes on the result of {@link io.vertx.mutiny.ext.mongo.MongoClient#listIndexes(String)}, but discards the outcome (item or failure).
   * This method is useful to trigger the asynchronous operation from {@link io.vertx.mutiny.ext.mongo.MongoClient#listIndexes(String)} but you don't need to compose it with other operations.
   * @param collection the collection
   * @return the instance of MongoClient to chain method calls.
   */
  @Fluent
  public io.vertx.mutiny.ext.mongo.MongoClient listIndexesAndForget(String collection) { 
    listIndexes(collection).subscribe().with(io.smallrye.mutiny.vertx.UniHelper.NOOP);
    return this;
  }

  /**
   * Drops the index given its name.
   * <p>
   * Unlike the <em>bare</em> Vert.x variant, this method returns a {@link io.smallrye.mutiny.Uni Uni}.
   * Don't forget to <em>subscribe</em> on it to trigger the operation.
   * @param collection the collection
   * @param indexName the name of the index to remove
   * @return the {@link io.smallrye.mutiny.Uni uni} firing the result of the operation when completed, or a failure if the operation failed.
   */
  @CheckReturnValue
  public io.smallrye.mutiny.Uni<Void> dropIndex(String collection, String indexName) { 
    return io.smallrye.mutiny.vertx.AsyncResultUni.toUni(resultHandler -> {
        delegate.dropIndex(collection, indexName, resultHandler);
    });
  }

  /**
   * Blocking variant of {@link io.vertx.mutiny.ext.mongo.MongoClient#dropIndex(String,String)}.
   * <p>
   * This method waits for the completion of the underlying asynchronous operation.
   * If the operation completes successfully, the result is returned, otherwise the failure is thrown (potentially wrapped in a RuntimeException).
   * @param collection the collection
   * @param indexName the name of the index to remove
   * @return the Void instance produced by the operation.
   */
  public Void dropIndexAndAwait(String collection, String indexName) { 
    return (Void) dropIndex(collection, indexName).await().indefinitely();
  }

  /**
   * Variant of {@link io.vertx.mutiny.ext.mongo.MongoClient#dropIndex(String,String)} that ignores the result of the operation.
   * <p>
   * This method subscribes on the result of {@link io.vertx.mutiny.ext.mongo.MongoClient#dropIndex(String,String)}, but discards the outcome (item or failure).
   * This method is useful to trigger the asynchronous operation from {@link io.vertx.mutiny.ext.mongo.MongoClient#dropIndex(String,String)} but you don't need to compose it with other operations.
   * @param collection the collection
   * @param indexName the name of the index to remove
   * @return the instance of MongoClient to chain method calls.
   */
  @Fluent
  public io.vertx.mutiny.ext.mongo.MongoClient dropIndexAndForget(String collection, String indexName) { 
    dropIndex(collection, indexName).subscribe().with(io.smallrye.mutiny.vertx.UniHelper.NOOP);
    return this;
  }

  /**
   * Run an arbitrary MongoDB command.
   * <p>
   * Unlike the <em>bare</em> Vert.x variant, this method returns a {@link io.smallrye.mutiny.Uni Uni}.
   * Don't forget to <em>subscribe</em> on it to trigger the operation.
   * @param commandName the name of the command
   * @param command the command
   * @return the {@link io.smallrye.mutiny.Uni uni} firing the result of the operation when completed, or a failure if the operation failed.
   */
  @CheckReturnValue
  public io.smallrye.mutiny.Uni<JsonObject> runCommand(String commandName, JsonObject command) { 
    return io.smallrye.mutiny.vertx.AsyncResultUni.toUni(resultHandler -> {
        delegate.runCommand(commandName, command, resultHandler);
    });
  }

  /**
   * Blocking variant of {@link io.vertx.mutiny.ext.mongo.MongoClient#runCommand(String,JsonObject)}.
   * <p>
   * This method waits for the completion of the underlying asynchronous operation.
   * If the operation completes successfully, the result is returned, otherwise the failure is thrown (potentially wrapped in a RuntimeException).
   * @param commandName the name of the command
   * @param command the command
   * @return the JsonObject instance produced by the operation.
   */
  public JsonObject runCommandAndAwait(String commandName, JsonObject command) { 
    return (JsonObject) runCommand(commandName, command).await().indefinitely();
  }

  /**
   * Variant of {@link io.vertx.mutiny.ext.mongo.MongoClient#runCommand(String,JsonObject)} that ignores the result of the operation.
   * <p>
   * This method subscribes on the result of {@link io.vertx.mutiny.ext.mongo.MongoClient#runCommand(String,JsonObject)}, but discards the outcome (item or failure).
   * This method is useful to trigger the asynchronous operation from {@link io.vertx.mutiny.ext.mongo.MongoClient#runCommand(String,JsonObject)} but you don't need to compose it with other operations.
   * @param commandName the name of the command
   * @param command the command
   * @return the instance of MongoClient to chain method calls.
   */
  @Fluent
  public io.vertx.mutiny.ext.mongo.MongoClient runCommandAndForget(String commandName, JsonObject command) { 
    runCommand(commandName, command).subscribe().with(io.smallrye.mutiny.vertx.UniHelper.NOOP);
    return this;
  }

  /**
   * Gets the distinct values of the specified field name.
   * Return a JsonArray containing distinct values (eg: [ 1 , 89 ])
   * <p>
   * Unlike the <em>bare</em> Vert.x variant, this method returns a {@link io.smallrye.mutiny.Uni Uni}.
   * Don't forget to <em>subscribe</em> on it to trigger the operation.
   * @param collection the collection
   * @param fieldName the field name
   * @param resultClassname 
   * @return the {@link io.smallrye.mutiny.Uni uni} firing the result of the operation when completed, or a failure if the operation failed.
   */
  @CheckReturnValue
  public io.smallrye.mutiny.Uni<JsonArray> distinct(String collection, String fieldName, String resultClassname) { 
    return io.smallrye.mutiny.vertx.AsyncResultUni.toUni(resultHandler -> {
        delegate.distinct(collection, fieldName, resultClassname, resultHandler);
    });
  }

  /**
   * Blocking variant of {@link io.vertx.mutiny.ext.mongo.MongoClient#distinct(String,String,String)}.
   * <p>
   * This method waits for the completion of the underlying asynchronous operation.
   * If the operation completes successfully, the result is returned, otherwise the failure is thrown (potentially wrapped in a RuntimeException).
   * @param collection the collection
   * @param fieldName the field name
   * @param resultClassname 
   * @return the JsonArray instance produced by the operation.
   */
  public JsonArray distinctAndAwait(String collection, String fieldName, String resultClassname) { 
    return (JsonArray) distinct(collection, fieldName, resultClassname).await().indefinitely();
  }

  /**
   * Variant of {@link io.vertx.mutiny.ext.mongo.MongoClient#distinct(String,String,String)} that ignores the result of the operation.
   * <p>
   * This method subscribes on the result of {@link io.vertx.mutiny.ext.mongo.MongoClient#distinct(String,String,String)}, but discards the outcome (item or failure).
   * This method is useful to trigger the asynchronous operation from {@link io.vertx.mutiny.ext.mongo.MongoClient#distinct(String,String,String)} but you don't need to compose it with other operations.
   * @param collection the collection
   * @param fieldName the field name
   * @param resultClassname 
   * @return the instance of MongoClient to chain method calls.
   */
  @Fluent
  public io.vertx.mutiny.ext.mongo.MongoClient distinctAndForget(String collection, String fieldName, String resultClassname) { 
    distinct(collection, fieldName, resultClassname).subscribe().with(io.smallrye.mutiny.vertx.UniHelper.NOOP);
    return this;
  }

  /**
   * Gets the distinct values of the specified field name.
   * Return a JsonArray containing distinct values (eg: [ 1 , 89 ])
   * <p>
   * Unlike the <em>bare</em> Vert.x variant, this method returns a {@link io.smallrye.mutiny.Uni Uni}.
   * Don't forget to <em>subscribe</em> on it to trigger the operation.
   * @param collection the collection
   * @param fieldName the field name
   * @param resultClassname 
   * @param distinctOptions options (e.g. collation)
   * @return the {@link io.smallrye.mutiny.Uni uni} firing the result of the operation when completed, or a failure if the operation failed.
   */
  @CheckReturnValue
  public io.smallrye.mutiny.Uni<JsonArray> distinct(String collection, String fieldName, String resultClassname, io.vertx.ext.mongo.DistinctOptions distinctOptions) { 
    return io.smallrye.mutiny.vertx.AsyncResultUni.toUni(resultHandler -> {
        delegate.distinct(collection, fieldName, resultClassname, distinctOptions, resultHandler);
    });
  }

  /**
   * Blocking variant of {@link io.vertx.mutiny.ext.mongo.MongoClient#distinct(String,String,String,DistinctOptions)}.
   * <p>
   * This method waits for the completion of the underlying asynchronous operation.
   * If the operation completes successfully, the result is returned, otherwise the failure is thrown (potentially wrapped in a RuntimeException).
   * @param collection the collection
   * @param fieldName the field name
   * @param resultClassname 
   * @param distinctOptions options (e.g. collation)
   * @return the JsonArray instance produced by the operation.
   */
  public JsonArray distinctAndAwait(String collection, String fieldName, String resultClassname, io.vertx.ext.mongo.DistinctOptions distinctOptions) { 
    return (JsonArray) distinct(collection, fieldName, resultClassname, distinctOptions).await().indefinitely();
  }

  /**
   * Variant of {@link io.vertx.mutiny.ext.mongo.MongoClient#distinct(String,String,String,DistinctOptions)} that ignores the result of the operation.
   * <p>
   * This method subscribes on the result of {@link io.vertx.mutiny.ext.mongo.MongoClient#distinct(String,String,String,DistinctOptions)}, but discards the outcome (item or failure).
   * This method is useful to trigger the asynchronous operation from {@link io.vertx.mutiny.ext.mongo.MongoClient#distinct(String,String,String,DistinctOptions)} but you don't need to compose it with other operations.
   * @param collection the collection
   * @param fieldName the field name
   * @param resultClassname 
   * @param distinctOptions options (e.g. collation)
   * @return the instance of MongoClient to chain method calls.
   */
  @Fluent
  public io.vertx.mutiny.ext.mongo.MongoClient distinctAndForget(String collection, String fieldName, String resultClassname, io.vertx.ext.mongo.DistinctOptions distinctOptions) { 
    distinct(collection, fieldName, resultClassname, distinctOptions).subscribe().with(io.smallrye.mutiny.vertx.UniHelper.NOOP);
    return this;
  }

  /**
   * Gets the distinct values of the specified field name filtered by specified query.
   * Return a JsonArray containing distinct values (eg: [ 1 , 89 ])
   * <p>
   * Unlike the <em>bare</em> Vert.x variant, this method returns a {@link io.smallrye.mutiny.Uni Uni}.
   * Don't forget to <em>subscribe</em> on it to trigger the operation.
   * @param collection the collection
   * @param fieldName the field name
   * @param resultClassname 
   * @param query the query
   * @return the {@link io.smallrye.mutiny.Uni uni} firing the result of the operation when completed, or a failure if the operation failed.
   */
  @CheckReturnValue
  public io.smallrye.mutiny.Uni<JsonArray> distinctWithQuery(String collection, String fieldName, String resultClassname, JsonObject query) { 
    return io.smallrye.mutiny.vertx.AsyncResultUni.toUni(resultHandler -> {
        delegate.distinctWithQuery(collection, fieldName, resultClassname, query, resultHandler);
    });
  }

  /**
   * Blocking variant of {@link io.vertx.mutiny.ext.mongo.MongoClient#distinctWithQuery(String,String,String,JsonObject)}.
   * <p>
   * This method waits for the completion of the underlying asynchronous operation.
   * If the operation completes successfully, the result is returned, otherwise the failure is thrown (potentially wrapped in a RuntimeException).
   * @param collection the collection
   * @param fieldName the field name
   * @param resultClassname 
   * @param query the query
   * @return the JsonArray instance produced by the operation.
   */
  public JsonArray distinctWithQueryAndAwait(String collection, String fieldName, String resultClassname, JsonObject query) { 
    return (JsonArray) distinctWithQuery(collection, fieldName, resultClassname, query).await().indefinitely();
  }

  /**
   * Variant of {@link io.vertx.mutiny.ext.mongo.MongoClient#distinctWithQuery(String,String,String,JsonObject)} that ignores the result of the operation.
   * <p>
   * This method subscribes on the result of {@link io.vertx.mutiny.ext.mongo.MongoClient#distinctWithQuery(String,String,String,JsonObject)}, but discards the outcome (item or failure).
   * This method is useful to trigger the asynchronous operation from {@link io.vertx.mutiny.ext.mongo.MongoClient#distinctWithQuery(String,String,String,JsonObject)} but you don't need to compose it with other operations.
   * @param collection the collection
   * @param fieldName the field name
   * @param resultClassname 
   * @param query the query
   * @return the instance of MongoClient to chain method calls.
   */
  @Fluent
  public io.vertx.mutiny.ext.mongo.MongoClient distinctWithQueryAndForget(String collection, String fieldName, String resultClassname, JsonObject query) { 
    distinctWithQuery(collection, fieldName, resultClassname, query).subscribe().with(io.smallrye.mutiny.vertx.UniHelper.NOOP);
    return this;
  }

  /**
   * Gets the distinct values of the specified field name filtered by specified query.
   * Return a JsonArray containing distinct values (eg: [ 1 , 89 ])
   * <p>
   * Unlike the <em>bare</em> Vert.x variant, this method returns a {@link io.smallrye.mutiny.Uni Uni}.
   * Don't forget to <em>subscribe</em> on it to trigger the operation.
   * @param collection the collection
   * @param fieldName the field name
   * @param resultClassname 
   * @param query the query
   * @param distinctOptions options (e.g. collation)
   * @return the {@link io.smallrye.mutiny.Uni uni} firing the result of the operation when completed, or a failure if the operation failed.
   */
  @CheckReturnValue
  public io.smallrye.mutiny.Uni<JsonArray> distinctWithQuery(String collection, String fieldName, String resultClassname, JsonObject query, io.vertx.ext.mongo.DistinctOptions distinctOptions) { 
    return io.smallrye.mutiny.vertx.AsyncResultUni.toUni(resultHandler -> {
        delegate.distinctWithQuery(collection, fieldName, resultClassname, query, distinctOptions, resultHandler);
    });
  }

  /**
   * Blocking variant of {@link io.vertx.mutiny.ext.mongo.MongoClient#distinctWithQuery(String,String,String,JsonObject,DistinctOptions)}.
   * <p>
   * This method waits for the completion of the underlying asynchronous operation.
   * If the operation completes successfully, the result is returned, otherwise the failure is thrown (potentially wrapped in a RuntimeException).
   * @param collection the collection
   * @param fieldName the field name
   * @param resultClassname 
   * @param query the query
   * @param distinctOptions options (e.g. collation)
   * @return the JsonArray instance produced by the operation.
   */
  public JsonArray distinctWithQueryAndAwait(String collection, String fieldName, String resultClassname, JsonObject query, io.vertx.ext.mongo.DistinctOptions distinctOptions) { 
    return (JsonArray) distinctWithQuery(collection, fieldName, resultClassname, query, distinctOptions).await().indefinitely();
  }

  /**
   * Variant of {@link io.vertx.mutiny.ext.mongo.MongoClient#distinctWithQuery(String,String,String,JsonObject,DistinctOptions)} that ignores the result of the operation.
   * <p>
   * This method subscribes on the result of {@link io.vertx.mutiny.ext.mongo.MongoClient#distinctWithQuery(String,String,String,JsonObject,DistinctOptions)}, but discards the outcome (item or failure).
   * This method is useful to trigger the asynchronous operation from {@link io.vertx.mutiny.ext.mongo.MongoClient#distinctWithQuery(String,String,String,JsonObject,DistinctOptions)} but you don't need to compose it with other operations.
   * @param collection the collection
   * @param fieldName the field name
   * @param resultClassname 
   * @param query the query
   * @param distinctOptions options (e.g. collation)
   * @return the instance of MongoClient to chain method calls.
   */
  @Fluent
  public io.vertx.mutiny.ext.mongo.MongoClient distinctWithQueryAndForget(String collection, String fieldName, String resultClassname, JsonObject query, io.vertx.ext.mongo.DistinctOptions distinctOptions) { 
    distinctWithQuery(collection, fieldName, resultClassname, query, distinctOptions).subscribe().with(io.smallrye.mutiny.vertx.UniHelper.NOOP);
    return this;
  }

  /**
   * @param collection the collection
   * @param fieldName the field name
   * @param resultClassname 
   * @return a  emitting json fragments
   */
  public io.vertx.mutiny.core.streams.ReadStream<JsonObject> distinctBatch(String collection, String fieldName, String resultClassname) { 
    io.vertx.mutiny.core.streams.ReadStream<JsonObject> ret = io.vertx.mutiny.core.streams.ReadStream.newInstance((io.vertx.core.streams.ReadStream)delegate.distinctBatch(collection, fieldName, resultClassname), TypeArg.unknown());
    return ret;
  }

  /**
   * @param collection the collection
   * @param fieldName the field name
   * @param resultClassname 
   * @param distinctOptions options (e.g. collation)
   * @return a  emitting json fragments
   */
  public io.vertx.mutiny.core.streams.ReadStream<JsonObject> distinctBatch(String collection, String fieldName, String resultClassname, io.vertx.ext.mongo.DistinctOptions distinctOptions) { 
    io.vertx.mutiny.core.streams.ReadStream<JsonObject> ret = io.vertx.mutiny.core.streams.ReadStream.newInstance((io.vertx.core.streams.ReadStream)delegate.distinctBatch(collection, fieldName, resultClassname, distinctOptions), TypeArg.unknown());
    return ret;
  }

  /**
   * @param collection the collection
   * @param fieldName the field name
   * @param resultClassname 
   * @param query the query
   * @return a  emitting json fragments
   */
  public io.vertx.mutiny.core.streams.ReadStream<JsonObject> distinctBatchWithQuery(String collection, String fieldName, String resultClassname, JsonObject query) { 
    io.vertx.mutiny.core.streams.ReadStream<JsonObject> ret = io.vertx.mutiny.core.streams.ReadStream.newInstance((io.vertx.core.streams.ReadStream)delegate.distinctBatchWithQuery(collection, fieldName, resultClassname, query), TypeArg.unknown());
    return ret;
  }

  /**
   * @param collection the collection
   * @param fieldName the field name
   * @param resultClassname 
   * @param query the query
   * @param distinctOptions options (e.g. collation)
   * @return a  emitting json fragments
   */
  public io.vertx.mutiny.core.streams.ReadStream<JsonObject> distinctBatchWithQuery(String collection, String fieldName, String resultClassname, JsonObject query, io.vertx.ext.mongo.DistinctOptions distinctOptions) { 
    io.vertx.mutiny.core.streams.ReadStream<JsonObject> ret = io.vertx.mutiny.core.streams.ReadStream.newInstance((io.vertx.core.streams.ReadStream)delegate.distinctBatchWithQuery(collection, fieldName, resultClassname, query, distinctOptions), TypeArg.unknown());
    return ret;
  }

  /**
   * @param collection the collection
   * @param fieldName the field name
   * @param resultClassname 
   * @param query the query
   * @param batchSize the number of documents to load in a batch
   * @return a  emitting json fragments
   */
  public io.vertx.mutiny.core.streams.ReadStream<JsonObject> distinctBatchWithQuery(String collection, String fieldName, String resultClassname, JsonObject query, int batchSize) { 
    io.vertx.mutiny.core.streams.ReadStream<JsonObject> ret = io.vertx.mutiny.core.streams.ReadStream.newInstance((io.vertx.core.streams.ReadStream)delegate.distinctBatchWithQuery(collection, fieldName, resultClassname, query, batchSize), TypeArg.unknown());
    return ret;
  }

  /**
   * @param collection the collection
   * @param fieldName the field name
   * @param resultClassname 
   * @param query the query
   * @param batchSize the number of documents to load in a batch
   * @param distinctOptions options (e.g. collation)
   * @return a  emitting json fragments
   */
  public io.vertx.mutiny.core.streams.ReadStream<JsonObject> distinctBatchWithQuery(String collection, String fieldName, String resultClassname, JsonObject query, int batchSize, io.vertx.ext.mongo.DistinctOptions distinctOptions) { 
    io.vertx.mutiny.core.streams.ReadStream<JsonObject> ret = io.vertx.mutiny.core.streams.ReadStream.newInstance((io.vertx.core.streams.ReadStream)delegate.distinctBatchWithQuery(collection, fieldName, resultClassname, query, batchSize, distinctOptions), TypeArg.unknown());
    return ret;
  }

  /**
   * @param collection the collection
   * @param pipeline aggregation pipeline to be executed
   * @return 
   */
  public io.vertx.mutiny.core.streams.ReadStream<JsonObject> aggregate(String collection, JsonArray pipeline) { 
    io.vertx.mutiny.core.streams.ReadStream<JsonObject> ret = io.vertx.mutiny.core.streams.ReadStream.newInstance((io.vertx.core.streams.ReadStream)delegate.aggregate(collection, pipeline), TypeArg.unknown());
    return ret;
  }

  /**
   * @param collection the collection
   * @param pipeline aggregation pipeline to be executed
   * @param options options to configure the aggregation command
   * @return 
   */
  public io.vertx.mutiny.core.streams.ReadStream<JsonObject> aggregateWithOptions(String collection, JsonArray pipeline, io.vertx.ext.mongo.AggregateOptions options) { 
    io.vertx.mutiny.core.streams.ReadStream<JsonObject> ret = io.vertx.mutiny.core.streams.ReadStream.newInstance((io.vertx.core.streams.ReadStream)delegate.aggregateWithOptions(collection, pipeline, options), TypeArg.unknown());
    return ret;
  }

  /**
   * Creates a {@link io.vertx.mutiny.ext.mongo.MongoGridFsClient} used to interact with Mongo GridFS.
   * <p>
   * Unlike the <em>bare</em> Vert.x variant, this method returns a {@link io.smallrye.mutiny.Uni Uni}.
   * Don't forget to <em>subscribe</em> on it to trigger the operation.
   * @return the {@link io.smallrye.mutiny.Uni uni} firing the result of the operation when completed, or a failure if the operation failed.
   */
  @CheckReturnValue
  public io.smallrye.mutiny.Uni<io.vertx.mutiny.ext.mongo.MongoGridFsClient> createDefaultGridFsBucketService() { 
    return io.smallrye.mutiny.vertx.AsyncResultUni.toUni(resultHandler -> {
        delegate.createDefaultGridFsBucketService(new io.smallrye.mutiny.vertx.DelegatingHandler<>(resultHandler, ar -> ar.map(event -> io.vertx.mutiny.ext.mongo.MongoGridFsClient.newInstance((io.vertx.ext.mongo.MongoGridFsClient)event))));
    });
  }

  /**
   * Blocking variant of {@link io.vertx.mutiny.ext.mongo.MongoClient#createDefaultGridFsBucketService}.
   * <p>
   * This method waits for the completion of the underlying asynchronous operation.
   * If the operation completes successfully, the result is returned, otherwise the failure is thrown (potentially wrapped in a RuntimeException).
   * @return the MongoGridFsClient instance produced by the operation.
   */
  public io.vertx.mutiny.ext.mongo.MongoGridFsClient createDefaultGridFsBucketServiceAndAwait() { 
    return (io.vertx.mutiny.ext.mongo.MongoGridFsClient) createDefaultGridFsBucketService().await().indefinitely();
  }

  /**
   * Variant of {@link io.vertx.mutiny.ext.mongo.MongoClient#createDefaultGridFsBucketService} that ignores the result of the operation.
   * <p>
   * This method subscribes on the result of {@link io.vertx.mutiny.ext.mongo.MongoClient#createDefaultGridFsBucketService}, but discards the outcome (item or failure).
   * This method is useful to trigger the asynchronous operation from {@link io.vertx.mutiny.ext.mongo.MongoClient#createDefaultGridFsBucketService} but you don't need to compose it with other operations.
   * @return the instance of MongoClient to chain method calls.
   */
  @Fluent
  public io.vertx.mutiny.ext.mongo.MongoClient createDefaultGridFsBucketServiceAndForget() { 
    createDefaultGridFsBucketService().subscribe().with(io.smallrye.mutiny.vertx.UniHelper.NOOP);
    return this;
  }

  /**
   * Creates a {@link io.vertx.mutiny.ext.mongo.MongoGridFsClient} used to interact with Mongo GridFS.
   * <p>
   * Unlike the <em>bare</em> Vert.x variant, this method returns a {@link io.smallrye.mutiny.Uni Uni}.
   * Don't forget to <em>subscribe</em> on it to trigger the operation.
   * @param bucketName the name of the GridFS bucket
   * @return the {@link io.smallrye.mutiny.Uni uni} firing the result of the operation when completed, or a failure if the operation failed.
   */
  @CheckReturnValue
  public io.smallrye.mutiny.Uni<io.vertx.mutiny.ext.mongo.MongoGridFsClient> createGridFsBucketService(String bucketName) { 
    return io.smallrye.mutiny.vertx.AsyncResultUni.toUni(resultHandler -> {
        delegate.createGridFsBucketService(bucketName, new io.smallrye.mutiny.vertx.DelegatingHandler<>(resultHandler, ar -> ar.map(event -> io.vertx.mutiny.ext.mongo.MongoGridFsClient.newInstance((io.vertx.ext.mongo.MongoGridFsClient)event))));
    });
  }

  /**
   * Blocking variant of {@link io.vertx.mutiny.ext.mongo.MongoClient#createGridFsBucketService(String)}.
   * <p>
   * This method waits for the completion of the underlying asynchronous operation.
   * If the operation completes successfully, the result is returned, otherwise the failure is thrown (potentially wrapped in a RuntimeException).
   * @param bucketName the name of the GridFS bucket
   * @return the MongoGridFsClient instance produced by the operation.
   */
  public io.vertx.mutiny.ext.mongo.MongoGridFsClient createGridFsBucketServiceAndAwait(String bucketName) { 
    return (io.vertx.mutiny.ext.mongo.MongoGridFsClient) createGridFsBucketService(bucketName).await().indefinitely();
  }

  /**
   * Variant of {@link io.vertx.mutiny.ext.mongo.MongoClient#createGridFsBucketService(String)} that ignores the result of the operation.
   * <p>
   * This method subscribes on the result of {@link io.vertx.mutiny.ext.mongo.MongoClient#createGridFsBucketService(String)}, but discards the outcome (item or failure).
   * This method is useful to trigger the asynchronous operation from {@link io.vertx.mutiny.ext.mongo.MongoClient#createGridFsBucketService(String)} but you don't need to compose it with other operations.
   * @param bucketName the name of the GridFS bucket
   * @return the instance of MongoClient to chain method calls.
   */
  @Fluent
  public io.vertx.mutiny.ext.mongo.MongoClient createGridFsBucketServiceAndForget(String bucketName) { 
    createGridFsBucketService(bucketName).subscribe().with(io.smallrye.mutiny.vertx.UniHelper.NOOP);
    return this;
  }

  /**
   * Close the client and release its resources
   * <p>
   * Unlike the <em>bare</em> Vert.x variant, this method returns a {@link io.smallrye.mutiny.Uni Uni}.
   * Don't forget to <em>subscribe</em> on it to trigger the operation.
   * @return the {@link io.smallrye.mutiny.Uni uni} firing the result of the operation when completed, or a failure if the operation failed.
   */
  @CheckReturnValue
  public io.smallrye.mutiny.Uni<Void> close() { 
    return io.smallrye.mutiny.vertx.AsyncResultUni.toUni(handler -> {
        delegate.close(handler);
    });
  }

  /**
   * Blocking variant of {@link io.vertx.mutiny.ext.mongo.MongoClient#close}.
   * <p>
   * This method waits for the completion of the underlying asynchronous operation.
   * If the operation completes successfully, the result is returned, otherwise the failure is thrown (potentially wrapped in a RuntimeException).
   * @return the Void instance produced by the operation.
   */
  public Void closeAndAwait() { 
    return (Void) close().await().indefinitely();
  }

  /**
   * Variant of {@link io.vertx.mutiny.ext.mongo.MongoClient#close} that ignores the result of the operation.
   * <p>
   * This method subscribes on the result of {@link io.vertx.mutiny.ext.mongo.MongoClient#close}, but discards the outcome (item or failure).
   * This method is useful to trigger the asynchronous operation from {@link io.vertx.mutiny.ext.mongo.MongoClient#close} but you don't need to compose it with other operations.
   */
  public void closeAndForget() { 
    close().subscribe().with(io.smallrye.mutiny.vertx.UniHelper.NOOP);
  }

  /**
   * @param collection the collection
   * @param pipeline watching pipeline to be executed
   * @param withUpdatedDoc whether to get updated fullDocument for "update" operation
   * @param batchSize the number of documents to load in a batch
   * @return 
   */
  public io.vertx.mutiny.core.streams.ReadStream<com.mongodb.client.model.changestream.ChangeStreamDocument<JsonObject>> watch(String collection, JsonArray pipeline, boolean withUpdatedDoc, int batchSize) { 
    io.vertx.mutiny.core.streams.ReadStream<com.mongodb.client.model.changestream.ChangeStreamDocument<JsonObject>> ret = io.vertx.mutiny.core.streams.ReadStream.newInstance((io.vertx.core.streams.ReadStream)delegate.watch(collection, pipeline, withUpdatedDoc, batchSize), TypeArg.unknown());
    return ret;
  }

  /**
   * The name of the default pool
   */
  public static final String DEFAULT_POOL_NAME = io.vertx.ext.mongo.MongoClient.DEFAULT_POOL_NAME;
  /**
   * The name of the default database
   */
  public static final String DEFAULT_DB_NAME = io.vertx.ext.mongo.MongoClient.DEFAULT_DB_NAME;
  public static  MongoClient newInstance(io.vertx.ext.mongo.MongoClient arg) {
    return arg != null ? new MongoClient(arg) : null;
  }

}
